/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.particle;

import dev.sterner.witchery.client.particle.SneezeData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016BI\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/sterner/witchery/client/particle/SneezeParticle;", "Lnet/minecraft/client/particle/TextureSheetParticle;", "level", "Lnet/minecraft/client/multiplayer/ClientLevel;", "x", "", "y", "z", "xSpeed", "ySpeed", "zSpeed", "sprites", "Lnet/minecraft/client/particle/SpriteSet;", "<init>", "(Lnet/minecraft/client/multiplayer/ClientLevel;DDDDDDLnet/minecraft/client/particle/SpriteSet;)V", "getRenderType", "Lnet/minecraft/client/particle/ParticleRenderType;", "getQuadSize", "", "scaleFactor", "tick", "", "SneezeProvider", "witchery"})
public final class SneezeParticle
extends TextureSheetParticle {
    @NotNull
    private final SpriteSet sprites;

    public SneezeParticle(@NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @NotNull SpriteSet sprites) {
        float g;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)sprites, (String)"sprites");
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.friction = 0.96f;
        this.sprites = sprites;
        float f = 2.5f;
        this.xd *= 0.1;
        this.yd *= 0.1;
        this.zd *= 0.1;
        this.xd += xSpeed;
        this.yd += ySpeed;
        this.zd += zSpeed;
        this.alpha = 0.4f;
        this.rCol = g = 1.0f - (float)(Math.random() * (double)0.3f);
        this.gCol = g;
        this.bCol = g;
        this.quadSize *= 1.875f;
        int i = (int)(8.0 / (Math.random() * 0.8 + 0.3));
        this.lifetime = (int)Math.max((double)((float)i * 2.5f), 1.0);
        this.hasPhysics = false;
        this.setSpriteFromAge(sprites);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        ParticleRenderType particleRenderType = ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
        Intrinsics.checkNotNullExpressionValue((Object)particleRenderType, (String)"PARTICLE_SHEET_TRANSLUCENT");
        return particleRenderType;
    }

    public float getQuadSize(float scaleFactor) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + scaleFactor) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        super.tick();
        if (!this.removed) {
            this.setSpriteFromAge(this.sprites);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006JH\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/sterner/witchery/client/particle/SneezeParticle$SneezeProvider;", "Lnet/minecraft/client/particle/ParticleProvider;", "Ldev/sterner/witchery/client/particle/SneezeData;", "sprites", "Lnet/minecraft/client/particle/SpriteSet;", "<init>", "(Lnet/minecraft/client/particle/SpriteSet;)V", "createParticle", "Lnet/minecraft/client/particle/Particle;", "type", "level", "Lnet/minecraft/client/multiplayer/ClientLevel;", "x", "", "y", "z", "xSpeed", "ySpeed", "zSpeed", "witchery"})
    public static final class SneezeProvider
    implements ParticleProvider<SneezeData> {
        @NotNull
        private final SpriteSet sprites;

        public SneezeProvider(@NotNull SpriteSet sprites) {
            Intrinsics.checkNotNullParameter((Object)sprites, (String)"sprites");
            this.sprites = sprites;
        }

        @NotNull
        public Particle createParticle(@NotNull SneezeData type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Particle particle = (Particle)new SneezeParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites);
            particle.setColor(200.0f, 50.0f, 120.0f);
            return particle;
        }
    }
}

