/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.model.SpinningWheelBlockEntityModel;
import dev.sterner.witchery.client.model.SpinningWheelWheelBlockEntityModel;
import dev.sterner.witchery.content.block.spining_wheel.SpinningWheelBlockEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/sterner/witchery/client/renderer/block/SpinningWheelBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Ldev/sterner/witchery/content/block/spining_wheel/SpinningWheelBlockEntity;", "ctx", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "wheelModel", "Ldev/sterner/witchery/client/model/SpinningWheelWheelBlockEntityModel;", "baseModel", "Ldev/sterner/witchery/client/model/SpinningWheelBlockEntityModel;", "render", "", "blockEntity", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "witchery"})
public final class SpinningWheelBlockEntityRenderer
implements BlockEntityRenderer<SpinningWheelBlockEntity> {
    @NotNull
    private SpinningWheelWheelBlockEntityModel wheelModel;
    @NotNull
    private SpinningWheelBlockEntityModel baseModel;

    public SpinningWheelBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ModelPart modelPart = ctx.bakeLayer(SpinningWheelWheelBlockEntityModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        this.wheelModel = new SpinningWheelWheelBlockEntityModel(modelPart);
        ModelPart modelPart2 = ctx.bakeLayer(SpinningWheelBlockEntityModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart2, (String)"bakeLayer(...)");
        this.baseModel = new SpinningWheelBlockEntityModel(modelPart2);
    }

    public void render(@NotNull SpinningWheelBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        Level level = blockEntity.getLevel();
        long gameTime = level != null ? level.getGameTime() : 0L;
        float rotation = blockEntity.getDataAccess().get(0) > 0 ? ((float)gameTime + partialTick) % (float)360 : 0.0f;
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5, -1.5, 0.5);
        this.baseModel.getBase().render(poseStack, bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)Witchery.Companion.id("textures/block/spinner.png"))), packedLight, packedOverlay);
        double oscillationAngle = 10.0 * Math.sin(Math.toRadians((double)rotation * (double)8));
        poseStack.pushPose();
        poseStack.translate(0.0, -0.4, -0.25);
        poseStack.translate(0.0, 1.0, 0.0);
        poseStack.mulPose(Axis.XP.rotationDegrees((float)oscillationAngle));
        poseStack.translate(0.0, -0.55, 0.2);
        this.baseModel.getString().render(poseStack, bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)Witchery.Companion.id("textures/block/spinner.png"))), packedLight, packedOverlay);
        poseStack.popPose();
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.5, -0.7, 0.8);
        poseStack.pushPose();
        poseStack.translate(0.0, 1.5, 0.0);
        poseStack.mulPose(Axis.XP.rotationDegrees(rotation));
        poseStack.translate(0.0, -1.5, 0.0);
        this.wheelModel.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)Witchery.Companion.id("textures/block/spinning_wheel_wheel.png"))), packedLight, packedOverlay);
        poseStack.popPose();
        poseStack.popPose();
    }
}

