/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.sterner.witchery.content.block.SuspiciousGraveyardDirtBlockEntity;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldev/sterner/witchery/client/renderer/block/SuspiciousGraveyardDirtBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Ldev/sterner/witchery/content/block/SuspiciousGraveyardDirtBlockEntity;", "context", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "itemRenderer", "Lnet/minecraft/client/renderer/entity/ItemRenderer;", "render", "", "blockEntity", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "translations", "", "direction", "Lnet/minecraft/core/Direction;", "dustedLevel", "witchery"})
public final class SuspiciousGraveyardDirtBlockEntityRenderer
implements BlockEntityRenderer<SuspiciousGraveyardDirtBlockEntity> {
    @NotNull
    private final ItemRenderer itemRenderer;

    public SuspiciousGraveyardDirtBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ItemRenderer itemRenderer = context.getItemRenderer();
        Intrinsics.checkNotNullExpressionValue((Object)itemRenderer, (String)"getItemRenderer(...)");
        this.itemRenderer = itemRenderer;
    }

    public void render(@NotNull SuspiciousGraveyardDirtBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        if (blockEntity.getLevel() != null) {
            ItemStack itemStack;
            Direction direction;
            Comparable comparable = blockEntity.getBlockState().getValue((Property)BlockStateProperties.DUSTED);
            Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type kotlin.Int");
            int i = (Integer)comparable;
            if (i > 0 && (direction = blockEntity.getHitDirection()) != null && !(itemStack = blockEntity.getStoredItem()).isEmpty()) {
                poseStack.pushPose();
                poseStack.translate(0.0f, 0.5f, 0.0f);
                float[] fs = this.translations(direction, i);
                poseStack.translate(fs[0], fs[1], fs[2]);
                poseStack.mulPose(Axis.YP.rotationDegrees(75.0f));
                boolean bl = direction == Direction.EAST || direction == Direction.WEST;
                poseStack.mulPose(Axis.YP.rotationDegrees((float)((bl ? 90 : 0) + 11)));
                poseStack.scale(0.5f, 0.5f, 0.5f);
                Level level = blockEntity.getLevel();
                Intrinsics.checkNotNull((Object)level);
                int j = LevelRenderer.getLightColor((BlockAndTintGetter)((BlockAndTintGetter)level), (BlockState)blockEntity.getBlockState(), (BlockPos)blockEntity.getBlockPos().relative(direction));
                this.itemRenderer.renderStatic(itemStack, ItemDisplayContext.FIXED, j, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, blockEntity.getLevel(), 0);
                poseStack.popPose();
            }
        }
    }

    private final float[] translations(Direction direction, int dustedLevel) {
        float[] fArray = new float[]{0.5f, 0.0f, 0.5f};
        float[] fs = fArray;
        float f = (float)dustedLevel / 10.0f * 0.75f;
        switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                fs[0] = 0.73f + f;
                break;
            }
            case 2: {
                fs[0] = 0.25f - f;
                break;
            }
            case 3: {
                fs[1] = 0.25f + f;
                break;
            }
            case 4: {
                fs[1] = -0.23f - f;
                break;
            }
            case 5: {
                fs[2] = 0.25f - f;
                break;
            }
            case 6: {
                fs[2] = 0.73f + f;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fs;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.EAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

