/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.layer.BabaItemLayer;
import dev.sterner.witchery.client.model.BabaYagaEntityModel;
import dev.sterner.witchery.client.model.WitchesRobesModel;
import dev.sterner.witchery.content.entity.BabaYagaEntity;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J8\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0007R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Ldev/sterner/witchery/client/renderer/entity/BabaYagaEntityRenderer;", "Lnet/minecraft/client/renderer/entity/MobRenderer;", "Ldev/sterner/witchery/content/entity/BabaYagaEntity;", "Ldev/sterner/witchery/client/model/BabaYagaEntityModel;", "context", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "getContext", "()Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "setContext", "hatModel", "Ldev/sterner/witchery/client/model/WitchesRobesModel;", "getHatModel", "()Ldev/sterner/witchery/client/model/WitchesRobesModel;", "setHatModel", "(Ldev/sterner/witchery/client/model/WitchesRobesModel;)V", "render", "", "entity", "entityYaw", "", "partialTicks", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "getTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "witchery"})
public final class BabaYagaEntityRenderer
extends MobRenderer<BabaYagaEntity, BabaYagaEntityModel<BabaYagaEntity>> {
    @NotNull
    private EntityRendererProvider.Context context;
    @NotNull
    private WitchesRobesModel hatModel;

    public BabaYagaEntityRenderer(@NotNull EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ModelPart modelPart = context.bakeLayer(BabaYagaEntityModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        super(context, (EntityModel)new BabaYagaEntityModel(modelPart), 0.6f);
        this.context = context;
        ModelPart modelPart2 = this.context.bakeLayer(WitchesRobesModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart2, (String)"bakeLayer(...)");
        this.hatModel = new WitchesRobesModel(modelPart2);
        RenderLayerParent renderLayerParent = (RenderLayerParent)this;
        ItemInHandRenderer itemInHandRenderer = this.context.getItemInHandRenderer();
        Intrinsics.checkNotNullExpressionValue((Object)itemInHandRenderer, (String)"getItemInHandRenderer(...)");
        this.addLayer((RenderLayer)new BabaItemLayer((RenderLayerParent<BabaYagaEntity, BabaYagaEntityModel<BabaYagaEntity>>)renderLayerParent, itemInHandRenderer));
    }

    @NotNull
    public final EntityRendererProvider.Context getContext() {
        return this.context;
    }

    public final void setContext(@NotNull EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.context = context;
    }

    @NotNull
    public final WitchesRobesModel getHatModel() {
        return this.hatModel;
    }

    public final void setHatModel(@NotNull WitchesRobesModel witchesRobesModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)witchesRobesModel), (String)"<set-?>");
        this.hatModel = witchesRobesModel;
    }

    public void render(@NotNull BabaYagaEntity entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ((BabaYagaEntityModel)this.model).getLeftLeg().visible = false;
        ((BabaYagaEntityModel)this.model).getRightLeg().visible = false;
        ((BabaYagaEntityModel)this.model).setHoldingItem(!entity.getMainHandItem().isEmpty());
        poseStack.pushPose();
        poseStack.translate(0.0, -0.25, 0.0);
        float f = Mth.rotLerp((float)partialTicks, (float)entity.yBodyRotO, (float)entity.yBodyRot);
        float k = Mth.rotLerp((float)partialTicks, (float)entity.yHeadRotO, (float)entity.yHeadRot);
        float g = Mth.rotLerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot());
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(0.0, -2.6, 0.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(k));
        poseStack.translate(0.0, 1.1, 0.0);
        poseStack.mulPose(Axis.XP.rotationDegrees(-g));
        poseStack.translate(0.0, -1.1, 0.0);
        this.hatModel.head.visible = true;
        this.hatModel.body.visible = false;
        this.hatModel.leftArm.visible = false;
        this.hatModel.rightArm.visible = false;
        this.hatModel.leftLeg.visible = false;
        this.hatModel.rightLeg.visible = false;
        this.hatModel.renderToBuffer(poseStack, buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)Witchery.Companion.id("textures/models/armor/baba_yagas_hat.png"))), packedLight, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - f));
        poseStack.translate(-0.5, 0.0, -0.5);
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(((Block)WitcheryBlocks.INSTANCE.getCAULDRON_DUMMY().get()).defaultBlockState(), poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull BabaYagaEntity entity) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        ResourceLocation resourceLocation = Witchery.Companion.id("textures/entity/baba_yaga.png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        return resourceLocation;
    }
}

