/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.screen;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.block.altar.AltarBlockEntity;
import dev.sterner.witchery.content.menu.AltarMenu;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0017\u0018B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0014J(\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0014J(\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0019"}, d2={"Ldev/sterner/witchery/client/screen/AltarScreen;", "Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;", "Ldev/sterner/witchery/content/menu/AltarMenu;", "menu", "inventory", "Lnet/minecraft/world/entity/player/Inventory;", "title", "Lnet/minecraft/network/chat/Component;", "<init>", "(Ldev/sterner/witchery/content/menu/AltarMenu;Lnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/chat/Component;)V", "isPauseScreen", "", "init", "", "renderBg", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "partialTick", "", "mouseX", "", "mouseY", "render", "Companion", "NamelessInventory", "witchery"})
public final class AltarScreen
extends AbstractContainerScreen<AltarMenu> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final ResourceLocation TEXTURE = Witchery.Companion.id("textures/gui/altar.png");
    @NotNull
    public static final String POWER_FORMAT = "%s/%s (%sx)";

    public AltarScreen(@NotNull AltarMenu menu, @NotNull Inventory inventory, @NotNull Component title) {
        Intrinsics.checkNotNullParameter((Object)((Object)menu), (String)"menu");
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super((AbstractContainerMenu)menu, (Inventory)new NamelessInventory(inventory), (Component)Component.empty().append(title).withStyle(ChatFormatting.WHITE));
        this.imageWidth = 256;
        this.imageHeight = 144;
        this.titleLabelY += 32;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        super.init();
        this.titleLabelX = this.imageWidth / 2 - this.font.width((FormattedText)this.title) / 2;
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        int x = this.leftPos;
        int y = this.topPos;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        String string = POWER_FORMAT;
        Object[] objectArray = new Object[3];
        objectArray[0] = ((AltarMenu)this.menu).getCurrentPower();
        objectArray[1] = ((AltarMenu)this.menu).getMaxPower();
        AltarBlockEntity altarBlockEntity = ((AltarMenu)this.menu).getAltar();
        objectArray[2] = altarBlockEntity != null ? (Number)altarBlockEntity.getPowerMultiplier() : (Number)1;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        Integer n = ChatFormatting.WHITE.getColor();
        guiGraphics.drawCenteredString(this.font, string2, this.width / 2, this.height / 2 - this.font.lineHeight / 2, n != null ? n : 0xFFFFFF);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/sterner/witchery/client/screen/AltarScreen$Companion;", "", "<init>", "()V", "TEXTURE", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "getTEXTURE", "()Lnet/minecraft/resources/ResourceLocation;", "POWER_FORMAT", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public final ResourceLocation getTEXTURE() {
            return TEXTURE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Ldev/sterner/witchery/client/screen/AltarScreen$NamelessInventory;", "Lnet/minecraft/world/entity/player/Inventory;", "inventory", "<init>", "(Lnet/minecraft/world/entity/player/Inventory;)V", "getDisplayName", "Lnet/minecraft/network/chat/MutableComponent;", "witchery"})
    public static final class NamelessInventory
    extends Inventory {
        public NamelessInventory(@NotNull Inventory inventory) {
            Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
            super(inventory.player);
        }

        @NotNull
        public MutableComponent getDisplayName() {
            MutableComponent mutableComponent = Component.literal((String)"");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
            return mutableComponent;
        }
    }
}

