/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.screen;

import dev.sterner.witchery.client.hud.HudPositionData;
import dev.sterner.witchery.core.registry.WitcheryKeyMappings;
import dev.sterner.witchery.features.misc.HudPlayerAttachment;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0006\n\u0002\b\u000e\u0018\u0000 #2\u00020\u0001:\u0003!\"#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0014J(\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J \u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J0\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0016H\u0016J \u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\b\u0010\u001e\u001a\u00020\fH\u0002J\b\u0010\u001f\u001a\u00020\fH\u0002J\b\u0010 \u001a\u00020\u0015H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Ldev/sterner/witchery/client/screen/HudEditorScreen;", "Lnet/minecraft/client/gui/screens/Screen;", "<init>", "()V", "draggedElement", "Ldev/sterner/witchery/client/screen/HudEditorScreen$HudElement;", "dragOffsetX", "", "dragOffsetY", "hudElements", "", "init", "", "render", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "mouseX", "mouseY", "partialTick", "", "mouseClicked", "", "", "button", "mouseReleased", "mouseDragged", "dragX", "dragY", "isMouseOver", "el", "savePositions", "resetPositions", "isPauseScreen", "ElementType", "HudElement", "Companion", "witchery"})
public final class HudEditorScreen
extends Screen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private HudElement draggedElement;
    private int dragOffsetX;
    private int dragOffsetY;
    @NotNull
    private final List<HudElement> hudElements = new ArrayList();

    public HudEditorScreen() {
        super((Component)Component.literal((String)"HUD Editor"));
    }

    protected void init() {
        super.init();
        Minecraft minecraft = this.minecraft;
        Intrinsics.checkNotNull((Object)minecraft);
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        HudPositionData positions = HudPlayerAttachment.getData((Player)player).getHudPositions();
        this.hudElements.clear();
        HudPositionData.Coord coord = positions.getInfusionPos(this.height);
        int infusionX = coord.component1();
        int infusionY = coord.component2();
        this.hudElements.add(new HudElement(ElementType.INFUSION, infusionX - 4, infusionY - 4, 23, 55, "Infusion Meter"));
        HudPositionData.Coord coord2 = positions.getManifestationPos(this.height);
        int manifestationX = coord2.component1();
        int manifestationY = coord2.component2();
        this.hudElements.add(new HudElement(ElementType.MANIFESTATION, manifestationX - 4, manifestationY - 4, 20, 32, "Manifestation Meter"));
        HudPositionData.Coord coord3 = positions.getBarkBeltPos(this.width, this.height);
        int barkX = coord3.component1();
        int barkY = coord3.component2();
        this.hudElements.add(new HudElement(ElementType.BARK_BELT, barkX - 4, barkY - 4, 88, 16, "Bark Belt"));
        HudPositionData.Coord coord4 = positions.getQuestHudPos(this.width, this.height);
        int questX = coord4.component1();
        int questY = coord4.component2();
        this.hudElements.add(new HudElement(ElementType.QUEST_HUD, questX - 4, questY - 4, 64, 64, "Quests"));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)((Component)Component.literal((String)"Reset Positions")), arg_0 -> HudEditorScreen.init$lambda$0(this, arg_0)).bounds(this.width / 2 - 75, this.height - 30, 150, 20).build());
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        guiGraphics.fill(RenderType.guiOverlay(), 0, 0, this.width, this.height, -2013265920);
        for (HudElement el : this.hudElements) {
            boolean isHovered = this.isMouseOver(mouseX, mouseY, el);
            boolean isDragged = Intrinsics.areEqual((Object)this.draggedElement, (Object)el);
            int color = isDragged ? -16711936 : (isHovered ? -256 : -7829368);
            guiGraphics.renderOutline(el.getX(), el.getY(), el.getWidth(), el.getHeight(), color);
            guiGraphics.fill(RenderType.guiOverlay(), el.getX() + 1, el.getY() + 1, el.getX() + el.getWidth() - 1, el.getY() + el.getHeight() - 1, 0x44444444);
            int labelWidth = this.font.width(el.getLabel());
            guiGraphics.drawString(this.font, el.getLabel(), el.getX() + (el.getWidth() - labelWidth) / 2, el.getY() - 12, 0xFFFFFF);
        }
        guiGraphics.drawCenteredString(this.font, "Click and drag HUD elements to reposition them", this.width / 2, 10, 0xFFFFFF);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (HudElement el : this.hudElements) {
                if (!this.isMouseOver((int)mouseX, (int)mouseY, el)) continue;
                this.draggedElement = el;
                this.dragOffsetX = (int)mouseX - el.getX();
                this.dragOffsetY = (int)mouseY - el.getY();
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggedElement != null) {
            this.savePositions();
            this.draggedElement = null;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.draggedElement != null) {
            HudElement hudElement = this.draggedElement;
            Intrinsics.checkNotNull((Object)hudElement);
            HudElement el = hudElement;
            int newX = (int)mouseX - this.dragOffsetX;
            int newY = (int)mouseY - this.dragOffsetY;
            newX = Mth.clamp((int)newX, (int)0, (int)(this.width - el.getWidth()));
            newY = Mth.clamp((int)newY, (int)0, (int)(this.height - el.getHeight()));
            el.setX(newX);
            el.setY(newY);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    private final boolean isMouseOver(int mouseX, int mouseY, HudElement el) {
        return mouseX >= el.getX() && mouseX <= el.getX() + el.getWidth() && mouseY >= el.getY() && mouseY <= el.getY() + el.getHeight();
    }

    private final void savePositions() {
        Minecraft minecraft = this.minecraft;
        Intrinsics.checkNotNull((Object)minecraft);
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        HudPositionData.Coord infusionCoord = new HudPositionData.Coord(10, -1);
        HudPositionData.Coord manifestationCoord = new HudPositionData.Coord(28, -1);
        HudPositionData.Coord barkCoord = new HudPositionData.Coord(-1, -1);
        HudPositionData.Coord questCoord = new HudPositionData.Coord(10, -1);
        block6: for (HudElement el : this.hudElements) {
            switch (WhenMappings.$EnumSwitchMapping$0[el.getType().ordinal()]) {
                case 1: {
                    infusionCoord = new HudPositionData.Coord(el.getX() + 4, el.getY() + 4);
                    continue block6;
                }
                case 2: {
                    manifestationCoord = new HudPositionData.Coord(el.getX() + 4, el.getY() + 4);
                    continue block6;
                }
                case 3: {
                    barkCoord = new HudPositionData.Coord(el.getX() + 4, el.getY() + 4);
                    continue block6;
                }
                case 4: {
                    questCoord = new HudPositionData.Coord(el.getX() + 4, el.getY() + 4);
                    continue block6;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        HudPositionData newPositions = new HudPositionData(infusionCoord, manifestationCoord, barkCoord, questCoord);
        HudPlayerAttachment.INSTANCE.setHudPositions((Player)player, newPositions);
    }

    private final void resetPositions() {
        Minecraft minecraft = this.minecraft;
        Intrinsics.checkNotNull((Object)minecraft);
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        HudPlayerAttachment.INSTANCE.setHudPositions((Player)player, new HudPositionData(null, null, null, null, 15, null));
        this.onClose();
        Minecraft minecraft2 = this.minecraft;
        Intrinsics.checkNotNull((Object)minecraft2);
        minecraft2.setScreen((Screen)new HudEditorScreen());
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static final void init$lambda$0(HudEditorScreen this$0, Button button) {
        this$0.resetPositions();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Ldev/sterner/witchery/client/screen/HudEditorScreen$Companion;", "", "<init>", "()V", "handleKeyPress", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public final void handleKeyPress() {
            Minecraft mc = Minecraft.getInstance();
            if (WitcheryKeyMappings.INSTANCE.getEDIT_HUD().consumeClick()) {
                mc.setScreen((Screen)new HudEditorScreen());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Ldev/sterner/witchery/client/screen/HudEditorScreen$ElementType;", "", "<init>", "(Ljava/lang/String;I)V", "INFUSION", "MANIFESTATION", "BARK_BELT", "QUEST_HUD", "witchery"})
    public static final class ElementType
    extends Enum<ElementType> {
        public static final /* enum */ ElementType INFUSION = new ElementType();
        public static final /* enum */ ElementType MANIFESTATION = new ElementType();
        public static final /* enum */ ElementType BARK_BELT = new ElementType();
        public static final /* enum */ ElementType QUEST_HUD = new ElementType();
        private static final /* synthetic */ ElementType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ElementType[] values() {
            return (ElementType[])$VALUES.clone();
        }

        public static ElementType valueOf(String value) {
            return Enum.valueOf(ElementType.class, value);
        }

        @NotNull
        public static EnumEntries<ElementType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = elementTypeArray = new ElementType[]{ElementType.INFUSION, ElementType.MANIFESTATION, ElementType.BARK_BELT, ElementType.QUEST_HUD};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\nH\u00c6\u0003JE\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020\u0005H\u00d6\u0001J\t\u0010(\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0012R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006)"}, d2={"Ldev/sterner/witchery/client/screen/HudEditorScreen$HudElement;", "", "type", "Ldev/sterner/witchery/client/screen/HudEditorScreen$ElementType;", "x", "", "y", "width", "height", "label", "", "<init>", "(Ldev/sterner/witchery/client/screen/HudEditorScreen$ElementType;IIIILjava/lang/String;)V", "getType", "()Ldev/sterner/witchery/client/screen/HudEditorScreen$ElementType;", "getX", "()I", "setX", "(I)V", "getY", "setY", "getWidth", "setWidth", "getHeight", "setHeight", "getLabel", "()Ljava/lang/String;", "setLabel", "(Ljava/lang/String;)V", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "witchery"})
    public static final class HudElement {
        @NotNull
        private final ElementType type;
        private int x;
        private int y;
        private int width;
        private int height;
        @NotNull
        private String label;

        public HudElement(@NotNull ElementType type, int x, int y, int width, int height, @NotNull String label) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            this.type = type;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.label = label;
        }

        @NotNull
        public final ElementType getType() {
            return this.type;
        }

        public final int getX() {
            return this.x;
        }

        public final void setX(int n) {
            this.x = n;
        }

        public final int getY() {
            return this.y;
        }

        public final void setY(int n) {
            this.y = n;
        }

        public final int getWidth() {
            return this.width;
        }

        public final void setWidth(int n) {
            this.width = n;
        }

        public final int getHeight() {
            return this.height;
        }

        public final void setHeight(int n) {
            this.height = n;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.label = string;
        }

        @NotNull
        public final ElementType component1() {
            return this.type;
        }

        public final int component2() {
            return this.x;
        }

        public final int component3() {
            return this.y;
        }

        public final int component4() {
            return this.width;
        }

        public final int component5() {
            return this.height;
        }

        @NotNull
        public final String component6() {
            return this.label;
        }

        @NotNull
        public final HudElement copy(@NotNull ElementType type, int x, int y, int width, int height, @NotNull String label) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            return new HudElement(type, x, y, width, height, label);
        }

        public static /* synthetic */ HudElement copy$default(HudElement hudElement, ElementType elementType, int n, int n2, int n3, int n4, String string, int n5, Object object) {
            if ((n5 & 1) != 0) {
                elementType = hudElement.type;
            }
            if ((n5 & 2) != 0) {
                n = hudElement.x;
            }
            if ((n5 & 4) != 0) {
                n2 = hudElement.y;
            }
            if ((n5 & 8) != 0) {
                n3 = hudElement.width;
            }
            if ((n5 & 0x10) != 0) {
                n4 = hudElement.height;
            }
            if ((n5 & 0x20) != 0) {
                string = hudElement.label;
            }
            return hudElement.copy(elementType, n, n2, n3, n4, string);
        }

        @NotNull
        public String toString() {
            return "HudElement(type=" + this.type + ", x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ", label=" + this.label + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + Integer.hashCode(this.x);
            result = result * 31 + Integer.hashCode(this.y);
            result = result * 31 + Integer.hashCode(this.width);
            result = result * 31 + Integer.hashCode(this.height);
            result = result * 31 + this.label.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HudElement)) {
                return false;
            }
            HudElement hudElement = (HudElement)other;
            if (this.type != hudElement.type) {
                return false;
            }
            if (this.x != hudElement.x) {
                return false;
            }
            if (this.y != hudElement.y) {
                return false;
            }
            if (this.width != hudElement.width) {
                return false;
            }
            if (this.height != hudElement.height) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.label, (Object)hudElement.label);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ElementType.values().length];
            try {
                nArray[ElementType.INFUSION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.MANIFESTATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.BARK_BELT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.QUEST_HUD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

