/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.blood_crucible;

import dev.sterner.witchery.content.block.WitcheryBaseBlockEntity;
import dev.sterner.witchery.content.item.WineGlassItem;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.util.WitcheryUtil;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.blood.BloodPoolHandler;
import dev.sterner.witchery.features.blood.BloodPoolLivingEntityAttachment;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tJ\u0006\u0010\u0010\u001a\u00020\tJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0018\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001eH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ldev/sterner/witchery/content/block/blood_crucible/BloodCrucibleBlockEntity;", "Ldev/sterner/witchery/content/block/WitcheryBaseBlockEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "BLOOD_TRANSFER_AMOUNT", "", "bloodAmount", "maxBloodStorage", "addBlood", "", "amount", "removeBlood", "getBloodAmount", "bloodPercent", "", "handleWineGlass", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "item", "Lnet/minecraft/world/item/ItemStack;", "onUseWithoutItem", "Lnet/minecraft/world/InteractionResult;", "saveAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "pTag", "pRegistries", "witchery"})
public final class BloodCrucibleBlockEntity
extends WitcheryBaseBlockEntity {
    private final int BLOOD_TRANSFER_AMOUNT;
    private int bloodAmount;
    private final int maxBloodStorage;

    public BloodCrucibleBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getBLOOD_CRUCIBLE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, blockPos, blockState);
        this.BLOOD_TRANSFER_AMOUNT = 300;
        this.maxBloodStorage = this.BLOOD_TRANSFER_AMOUNT * 16;
    }

    public final void addBlood(int amount) {
        this.bloodAmount = RangesKt.coerceAtMost((int)(this.bloodAmount + amount), (int)this.maxBloodStorage);
        this.setChanged();
    }

    public final int removeBlood(int amount) {
        int removed = RangesKt.coerceAtMost((int)amount, (int)this.bloodAmount);
        this.bloodAmount -= removed;
        this.setChanged();
        return removed;
    }

    public final int getBloodAmount() {
        return this.bloodAmount;
    }

    public final double bloodPercent() {
        return (double)this.bloodAmount / (double)this.maxBloodStorage;
    }

    public final void handleWineGlass(@NotNull Player pPlayer, @NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        boolean bl = item.has((DataComponentType)WitcheryDataComponents.INSTANCE.getBLOOD().get());
        if (bl) {
            if (this.getBloodAmount() <= this.maxBloodStorage - this.BLOOD_TRANSFER_AMOUNT) {
                this.addBlood(this.BLOOD_TRANSFER_AMOUNT);
                ItemStack itemStack = ((WineGlassItem)((Object)WitcheryItems.INSTANCE.getWINE_GLASS().get())).getDefaultInstance();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getDefaultInstance(...)");
                WitcheryUtil.INSTANCE.addItemToInventoryAndConsume(pPlayer, InteractionHand.MAIN_HAND, itemStack);
            }
        } else if (this.getBloodAmount() >= this.BLOOD_TRANSFER_AMOUNT) {
            ItemStack wineBlood = ((WineGlassItem)((Object)WitcheryItems.INSTANCE.getWINE_GLASS().get())).getDefaultInstance();
            wineBlood.set((DataComponentType)WitcheryDataComponents.INSTANCE.getBLOOD().get(), (Object)UUID.randomUUID());
            this.removeBlood(this.BLOOD_TRANSFER_AMOUNT);
            Intrinsics.checkNotNull((Object)wineBlood);
            WitcheryUtil.INSTANCE.addItemToInventoryAndConsume(pPlayer, InteractionHand.MAIN_HAND, wineBlood);
        }
    }

    @Override
    @NotNull
    public InteractionResult onUseWithoutItem(@NotNull Player pPlayer) {
        int availableBlood;
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Level level = pPlayer.level();
        int vampData = AfflictionPlayerAttachment.getData(pPlayer).getVampireLevel();
        if (vampData <= 0) {
            return InteractionResult.PASS;
        }
        BloodPoolLivingEntityAttachment.Data playerBloodData = BloodPoolLivingEntityAttachment.getData((LivingEntity)pPlayer);
        if (playerBloodData.getBloodPool() >= playerBloodData.getMaxBlood()) {
            return InteractionResult.PASS;
        }
        if (this.getBloodAmount() <= 0) {
            return InteractionResult.PASS;
        }
        int neededBlood = playerBloodData.getMaxBlood() - playerBloodData.getBloodPool();
        int transferAmount = Math.min(neededBlood, Math.min(availableBlood = this.getBloodAmount(), this.BLOOD_TRANSFER_AMOUNT));
        if (transferAmount <= 0) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide) {
            this.removeBlood(transferAmount);
            BloodPoolHandler.increaseBlood((LivingEntity)pPlayer, transferAmount);
            level.playSound(null, this.getBlockPos(), SoundEvents.GENERIC_DRINK, SoundSource.PLAYERS, 0.5f, 0.9f + level.random.nextFloat() * 0.2f);
        }
        InteractionResult interactionResult = InteractionResult.sidedSuccess((boolean)level.isClientSide);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"sidedSuccess(...)");
        return interactionResult;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.putInt("BloodAmount", this.bloodAmount);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        super.loadAdditional(pTag, pRegistries);
        this.bloodAmount = pTag.getInt("BloodAmount");
    }
}

