/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.coffin;

import dev.sterner.witchery.content.block.WitcheryBaseBlockEntity;
import dev.sterner.witchery.content.block.coffin.CoffinBlock;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0006\u0010\u0013\u001a\u00020\tJ \u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldev/sterner/witchery/content/block/coffin/CoffinBlockEntity;", "Ldev/sterner/witchery/content/block/WitcheryBaseBlockEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "openProgress", "", "targetOpenProgress", "maxAngle", "openLerpFactor", "closeLerpFactor", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "getEasedOpenProgress", "lerpAngle", "current", "target", "factor", "easeInOut", "x", "witchery"})
public final class CoffinBlockEntity
extends WitcheryBaseBlockEntity {
    private float openProgress;
    private float targetOpenProgress;
    private final float maxAngle;
    private final float openLerpFactor;
    private final float closeLerpFactor;

    public CoffinBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getCOFFIN().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, blockPos, blockState);
        this.maxAngle = 45.0f;
        this.openLerpFactor = 0.15f;
        this.closeLerpFactor = 0.15f;
    }

    @Override
    public void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super.tick(level, pos, blockState);
        if (!level.isClientSide) {
            return;
        }
        Boolean isOpen = (Boolean)blockState.getValue((Property)CoffinBlock.Companion.getOPEN());
        this.targetOpenProgress = isOpen != false ? this.maxAngle : 0.0f;
        float previousOpenProgress = this.openProgress;
        this.openProgress = this.lerpAngle(this.openProgress, this.targetOpenProgress, isOpen != false ? this.openLerpFactor : this.closeLerpFactor);
        if (Math.abs(previousOpenProgress - this.openProgress) > 0.01f) {
            this.setChanged();
        }
    }

    public final float getEasedOpenProgress() {
        return this.easeInOut(this.openProgress);
    }

    private final float lerpAngle(float current, float target, float factor) {
        return current + factor * (target - current);
    }

    private final float easeInOut(float x) {
        int v = 45;
        int c = -v / 2;
        int g = -2;
        int s = 16;
        return (float)((double)v / (1.0 + Math.pow(10.0, (float)g * ((float)c + x) / (float)s)));
    }
}

