/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.mirror;

import dev.sterner.witchery.WitcheryConfig;
import dev.sterner.witchery.content.block.mirror.MirrorBlock;
import dev.sterner.witchery.core.api.multiblock.MultiBlockCoreEntity;
import dev.sterner.witchery.core.api.multiblock.MultiBlockHorizontalDirectionStructure;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.features.infusion.InfusionPlayerAttachment;
import dev.sterner.witchery.features.infusion.InfusionType;
import dev.sterner.witchery.features.mirror.MirrorRegistryAttachment;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 =2\u00020\u0001:\u0002<=B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0014J\u0018\u0010.\u001a\u00020(2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0014J\u000e\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u00020(2\u0006\u00100\u001a\u000201H\u0002J\u0010\u00103\u001a\u00020(2\u0006\u00104\u001a\u000205H\u0016J\u000e\u00106\u001a\u00020(2\u0006\u00107\u001a\u00020\u0011J\b\u00108\u001a\u00020(H\u0002J\n\u00109\u001a\u0004\u0018\u00010\u0017H\u0002J\u000e\u0010:\u001a\u00020\t2\u0006\u00100\u001a\u000201J\u000e\u0010;\u001a\u00020(2\u0006\u00100\u001a\u000201R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u001d0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Ldev/sterner/witchery/content/block/mirror/MirrorBlockEntity;", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockCoreEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "hasDemon", "", "getHasDemon", "()Z", "setHasDemon", "(Z)V", "isSmallMirror", "setSmallMirror", "pairId", "Ljava/util/UUID;", "getPairId", "()Ljava/util/UUID;", "setPairId", "(Ljava/util/UUID;)V", "cachedLinkedMirror", "Lnet/minecraft/core/GlobalPos;", "getCachedLinkedMirror", "()Lnet/minecraft/core/GlobalPos;", "setCachedLinkedMirror", "(Lnet/minecraft/core/GlobalPos;)V", "cacheValidUntil", "", "mode", "Ldev/sterner/witchery/content/block/mirror/MirrorBlockEntity$Mode;", "getMode", "()Ldev/sterner/witchery/content/block/mirror/MirrorBlockEntity$Mode;", "setMode", "(Ldev/sterner/witchery/content/block/mirror/MirrorBlockEntity$Mode;)V", "entityCooldowns", "", "", "onLoad", "", "saveAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "isOnCooldown", "entity", "Lnet/minecraft/world/entity/Entity;", "setCooldown", "onBreak", "player", "Lnet/minecraft/world/entity/player/Player;", "putPairId", "uuid", "registerInRegistry", "getLinkedMirror", "canEntityTeleport", "tryTeleportEntity", "Mode", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nMirrorBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MirrorBlockEntity.kt\ndev/sterner/witchery/content/block/mirror/MirrorBlockEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n1#2:224\n2746#3,3:225\n*S KotlinDebug\n*F\n+ 1 MirrorBlockEntity.kt\ndev/sterner/witchery/content/block/mirror/MirrorBlockEntity\n*L\n165#1:225,3\n*E\n"})
public final class MirrorBlockEntity
extends MultiBlockCoreEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean hasDemon;
    private boolean isSmallMirror;
    @Nullable
    private UUID pairId;
    @Nullable
    private GlobalPos cachedLinkedMirror;
    private long cacheValidUntil;
    @NotNull
    private Mode mode;
    @NotNull
    private final Map<Integer, Long> entityCooldowns;
    public static final int TELEPORT_COOLDOWN = 20;
    public static final long CACHE_DURATION = 100L;

    public MirrorBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getMIRROR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        BlockEntityType blockEntityType = (BlockEntityType)object;
        MultiBlockHorizontalDirectionStructure multiBlockHorizontalDirectionStructure = MirrorBlock.Companion.getSTRUCTURE().get();
        Intrinsics.checkNotNullExpressionValue((Object)multiBlockHorizontalDirectionStructure, (String)"get(...)");
        super(blockEntityType, multiBlockHorizontalDirectionStructure, blockPos, blockState);
        this.mode = Mode.TELEPORT;
        this.entityCooldowns = new LinkedHashMap();
    }

    public final boolean getHasDemon() {
        return this.hasDemon;
    }

    public final void setHasDemon(boolean bl) {
        this.hasDemon = bl;
    }

    public final boolean isSmallMirror() {
        return this.isSmallMirror;
    }

    public final void setSmallMirror(boolean bl) {
        this.isSmallMirror = bl;
    }

    @Nullable
    public final UUID getPairId() {
        return this.pairId;
    }

    public final void setPairId(@Nullable UUID uUID) {
        this.pairId = uUID;
    }

    @Nullable
    public final GlobalPos getCachedLinkedMirror() {
        return this.cachedLinkedMirror;
    }

    public final void setCachedLinkedMirror(@Nullable GlobalPos globalPos) {
        this.cachedLinkedMirror = globalPos;
    }

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"<set-?>");
        this.mode = mode;
    }

    public void onLoad() {
        super.onLoad();
        this.registerInRegistry();
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            super.saveAdditional(tag, registries);
            tag.putBoolean("HasDemon", this.hasDemon);
            tag.putBoolean("IsSmallMirror", this.isSmallMirror);
            tag.putString("Mode", this.mode.getSerializedName());
            UUID uUID = this.pairId;
            if (uUID == null) break block0;
            UUID it = uUID;
            boolean bl = false;
            tag.putUUID("PairId", it);
        }
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.hasDemon = tag.getBoolean("HasDemon");
        this.isSmallMirror = tag.getBoolean("IsSmallMirror");
        if (tag.contains("Mode")) {
            String string = tag.getString("Mode");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            this.mode = Mode.valueOf(string2);
        }
        if (tag.contains("PairId")) {
            this.pairId = tag.getUUID("PairId");
        }
    }

    public final boolean isOnCooldown(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Level level = this.level;
        if (level == null) {
            return false;
        }
        long currentTime = level.getGameTime();
        Long l = this.entityCooldowns.get(entity.getId());
        if (l == null) {
            return false;
        }
        long lastTeleport = l;
        return currentTime - lastTeleport < 20L;
    }

    private final void setCooldown(Entity entity) {
        Map<Integer, Long> map = this.entityCooldowns;
        Integer n = entity.getId();
        Level level = this.level;
        Long l = level != null ? level.getGameTime() : 0L;
        map.put(n, l);
    }

    @Override
    public void onBreak(@NotNull Player player) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            super.onBreak(player);
            Level level = this.level;
            boolean bl = level != null ? !level.isClientSide : false;
            if (!bl || !(this.level instanceof ServerLevel) || this.pairId == null) break block2;
            Level level2 = this.level;
            Intrinsics.checkNotNull((Object)level2);
            GlobalPos globalPos = GlobalPos.of((ResourceKey)level2.dimension(), (BlockPos)this.getBlockPos());
            Level level3 = this.level;
            Intrinsics.checkNotNull((Object)level3, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level3;
            GlobalPos pairedMirrorPos = this.getLinkedMirror();
            Intrinsics.checkNotNull((Object)globalPos);
            MirrorRegistryAttachment.unregisterMirror(serverLevel, globalPos);
            GlobalPos globalPos2 = pairedMirrorPos;
            if (globalPos2 != null) {
                MirrorBlockEntity pairedEntity;
                ServerLevel pairedLevel;
                GlobalPos targetPos = globalPos2;
                boolean bl2 = false;
                ServerLevel serverLevel2 = pairedLevel = serverLevel.getServer().getLevel(targetPos.dimension());
                BlockEntity blockEntity = serverLevel2 != null ? serverLevel2.getBlockEntity(targetPos.pos()) : null;
                MirrorBlockEntity mirrorBlockEntity = pairedEntity = blockEntity instanceof MirrorBlockEntity ? (MirrorBlockEntity)blockEntity : null;
                if (mirrorBlockEntity != null) {
                    BlockEntity $this$onBreak_u24lambda_u240_u240 = blockEntity = mirrorBlockEntity;
                    boolean bl3 = false;
                    $this$onBreak_u24lambda_u240_u240.mode = Mode.DEMONIC;
                    $this$onBreak_u24lambda_u240_u240.hasDemon = true;
                    $this$onBreak_u24lambda_u240_u240.pairId = null;
                    $this$onBreak_u24lambda_u240_u240.cachedLinkedMirror = null;
                    $this$onBreak_u24lambda_u240_u240.setChanged();
                }
            }
        }
    }

    public final void putPairId(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.pairId = uuid;
        this.mode = Mode.TELEPORT;
        this.cachedLinkedMirror = null;
        this.cacheValidUntil = 0L;
        this.setChanged();
        this.registerInRegistry();
    }

    private final void registerInRegistry() {
        if (this.level instanceof ServerLevel && this.pairId != null) {
            Level level = this.level;
            Intrinsics.checkNotNull((Object)level);
            GlobalPos globalPos = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)this.getBlockPos());
            Level level2 = this.level;
            Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level2;
            UUID uUID = this.pairId;
            Intrinsics.checkNotNull((Object)uUID);
            Intrinsics.checkNotNull((Object)globalPos);
            MirrorRegistryAttachment.registerMirror(serverLevel, uUID, globalPos);
        }
    }

    private final GlobalPos getLinkedMirror() {
        long currentTime;
        if (this.pairId == null || this.mode != Mode.TELEPORT) {
            return null;
        }
        Level level = this.level;
        long l = currentTime = level != null ? level.getGameTime() : 0L;
        if (this.cachedLinkedMirror != null && currentTime < this.cacheValidUntil) {
            return this.cachedLinkedMirror;
        }
        if (this.level instanceof ServerLevel) {
            Level level2 = this.level;
            Intrinsics.checkNotNull((Object)level2);
            GlobalPos globalPos = GlobalPos.of((ResourceKey)level2.dimension(), (BlockPos)this.getBlockPos());
            Level level3 = this.level;
            Intrinsics.checkNotNull((Object)level3, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level3;
            UUID uUID = this.pairId;
            Intrinsics.checkNotNull((Object)uUID);
            Intrinsics.checkNotNull((Object)globalPos);
            this.cachedLinkedMirror = MirrorRegistryAttachment.findPairedMirror(serverLevel, uUID, globalPos);
            this.cacheValidUntil = currentTime + 100L;
        }
        return this.cachedLinkedMirror;
    }

    public final boolean canEntityTeleport(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof Player && ((Boolean)WitcheryConfig.REQUIRE_GHOST_OF_LIGHT_INFUSION.get()).booleanValue()) {
            InfusionPlayerAttachment.Data infusion = InfusionPlayerAttachment.getData((Player)entity);
            return infusion.getType() == InfusionType.LIGHT;
        }
        return true;
    }

    public final void tryTeleportEntity(@NotNull Entity entity) {
        GlobalPos globalPos;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (this.mode != Mode.TELEPORT) {
            return;
        }
        if (!this.canEntityTeleport(entity)) {
            return;
        }
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel serverLevel2 = serverLevel;
        UUID uUID = this.pairId;
        if (uUID != null) {
            boolean bl;
            UUID id;
            block15: {
                id = uUID;
                boolean bl2 = false;
                globalPos = GlobalPos.of((ResourceKey)serverLevel2.dimension(), (BlockPos)this.getBlockPos());
                MirrorRegistryAttachment.Data data2 = MirrorRegistryAttachment.getData(serverLevel2);
                Iterable $this$none$iv = data2.getEntries();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        MirrorRegistryAttachment.MirrorEntry it = (MirrorRegistryAttachment.MirrorEntry)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getPos(), (Object)globalPos)) continue;
                        bl = false;
                        break block15;
                    }
                    bl = true;
                }
            }
            if (bl) {
                Intrinsics.checkNotNull((Object)globalPos);
                MirrorRegistryAttachment.registerMirror(serverLevel2, id, globalPos);
            }
        }
        GlobalPos globalPos2 = this.getLinkedMirror();
        if (globalPos2 == null) {
            return;
        }
        GlobalPos targetPos = globalPos2;
        ServerLevel serverLevel3 = serverLevel2.getServer().getLevel(targetPos.dimension());
        if (serverLevel3 == null) {
            return;
        }
        ServerLevel targetLevel = serverLevel3;
        globalPos = targetLevel.getBlockEntity(targetPos.pos());
        MirrorBlockEntity mirrorBlockEntity = globalPos instanceof MirrorBlockEntity ? (MirrorBlockEntity)globalPos : null;
        if (mirrorBlockEntity == null) {
            return;
        }
        MirrorBlockEntity targetBe = mirrorBlockEntity;
        if (!Intrinsics.areEqual((Object)targetBe.pairId, (Object)this.pairId)) {
            this.cachedLinkedMirror = null;
            this.cacheValidUntil = 0L;
            return;
        }
        this.setCooldown(entity);
        targetBe.setCooldown(entity);
        Direction fromFacing = (Direction)this.getBlockState().getValue((Property)MirrorBlock.Companion.getFACING());
        Direction toFacing = (Direction)targetBe.getBlockState().getValue((Property)MirrorBlock.Companion.getFACING());
        float angleDelta = toFacing.toYRot() - fromFacing.toYRot() + 180.0f;
        float newYRot = (entity.getYRot() + angleDelta) % 360.0f;
        Vec3 exitFacingVec = new Vec3((double)toFacing.getNormal().getX(), (double)toFacing.getNormal().getY(), (double)toFacing.getNormal().getZ());
        Vec3 tpTarget = Vec3.atCenterOf((Vec3i)((Vec3i)targetPos.pos())).add(exitFacingVec.scale(0.05));
        double launchSpeed = entity instanceof ItemEntity ? 0.5 : 0.3;
        Vec3 launchVel = exitFacingVec.multiply(launchSpeed, 0.0, launchSpeed);
        if (!Intrinsics.areEqual((Object)serverLevel2.dimension(), (Object)targetPos.dimension())) {
            entity.changeDimension(new DimensionTransition(targetLevel, tpTarget, launchVel, newYRot, entity.getXRot(), DimensionTransition.DO_NOTHING));
        } else {
            entity.teleportTo(tpTarget.x, tpTarget.y, tpTarget.z);
            entity.setYRot(newYRot);
            entity.setDeltaMovement(launchVel);
            entity.hurtMarked = true;
            if (entity instanceof ServerPlayer) {
                entity.fallDistance = 0.0f;
                ((ServerPlayer)entity).connection.teleport(tpTarget.x, tpTarget.y, tpTarget.z, newYRot, ((ServerPlayer)entity).getXRot());
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldev/sterner/witchery/content/block/mirror/MirrorBlockEntity$Companion;", "", "<init>", "()V", "TELEPORT_COOLDOWN", "", "CACHE_DURATION", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\u000b"}, d2={"Ldev/sterner/witchery/content/block/mirror/MirrorBlockEntity$Mode;", "Lnet/minecraft/util/StringRepresentable;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "DEMONIC", "TELEPORT", "POCKET_DIMENSION", "getSerializedName", "", "witchery"})
    public static final class Mode
    extends Enum<Mode>
    implements StringRepresentable {
        public static final /* enum */ Mode NONE = new Mode();
        public static final /* enum */ Mode DEMONIC = new Mode();
        public static final /* enum */ Mode TELEPORT = new Mode();
        public static final /* enum */ Mode POCKET_DIMENSION = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public String getSerializedName() {
            String string = this.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return string;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.NONE, Mode.DEMONIC, Mode.TELEPORT, Mode.POCKET_DIMENSION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

