/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.ritual;

import com.mojang.brigadier.ParseResults;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.WitcheryConfig;
import dev.sterner.witchery.content.block.ritual.CommandType;
import dev.sterner.witchery.content.block.ritual.GoldenChalkBlockEntity;
import dev.sterner.witchery.content.entity.FloatingItemEntity;
import dev.sterner.witchery.content.recipe.ritual.RitualRecipe;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J&\u0010\u0017\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0019H\u0002JU\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001b\u001a\u00020\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002\u00a2\u0006\u0002\u0010#\u00a8\u0006$"}, d2={"Ldev/sterner/witchery/content/block/ritual/RitualHelper;", "", "<init>", "()V", "usesCurseCommands", "", "recipe", "Ldev/sterner/witchery/content/recipe/ritual/RitualRecipe;", "isDaytime", "level", "Lnet/minecraft/world/level/Level;", "isNighttime", "isFullMoon", "isNewMoon", "isWaxing", "isWaning", "summonItems", "", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockEntity", "Ldev/sterner/witchery/content/block/ritual/GoldenChalkBlockEntity;", "summonSummons", "runCommand", "phase", "", "isCurseCommand", "command", "minecraftServer", "Lnet/minecraft/server/MinecraftServer;", "waystonePos", "player", "Lnet/minecraft/world/entity/player/Player;", "entityId", "", "(Ldev/sterner/witchery/content/block/ritual/GoldenChalkBlockEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Ljava/lang/String;Lnet/minecraft/world/entity/player/Player;Ljava/lang/Integer;)V", "witchery"})
@SourceDebugExtension(value={"SMAP\nRitualHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RitualHelper.kt\ndev/sterner/witchery/content/block/ritual/RitualHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n1761#2,3:204\n1#3:207\n*S KotlinDebug\n*F\n+ 1 RitualHelper.kt\ndev/sterner/witchery/content/block/ritual/RitualHelper\n*L\n23#1:204,3\n*E\n"})
public final class RitualHelper {
    @NotNull
    public static final RitualHelper INSTANCE = new RitualHelper();

    private RitualHelper() {
    }

    public final boolean usesCurseCommands(@NotNull RitualRecipe recipe) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
            Iterable $this$any$iv = recipe.getCommands();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CommandType command = (CommandType)element$iv;
                    boolean bl2 = false;
                    if (!(StringsKt.contains((CharSequence)command.command(), (CharSequence)"curse apply", (boolean)true) || StringsKt.contains((CharSequence)command.command(), (CharSequence)"werewolf level try_curse", (boolean)true) || StringsKt.contains((CharSequence)command.command(), (CharSequence)"vampire level try_curse", (boolean)true))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isDaytime(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        long timeOfDay = level.getDayTime() % (long)24000;
        return 0L <= timeOfDay ? timeOfDay < 12000L : false;
    }

    public final boolean isNighttime(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        long timeOfDay = level.getDayTime() % (long)24000;
        level.getMoonPhase();
        return 12000L <= timeOfDay ? timeOfDay < 24000L : false;
    }

    public final boolean isFullMoon(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return level.getMoonPhase() == 0 && this.isNighttime(level);
    }

    public final boolean isNewMoon(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return level.getMoonPhase() == 4 && this.isNighttime(level);
    }

    public final boolean isWaxing(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        int n = level.getMoonPhase();
        return (5 <= n ? n < 8 : false) && this.isNighttime(level);
    }

    public final boolean isWaning(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        int n = level.getMoonPhase();
        return (1 <= n ? n < 4 : false) && this.isNighttime(level);
    }

    public final void summonItems(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull GoldenChalkBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        double x = (double)blockPos.getX() + 0.5;
        double y = (double)blockPos.getY() + 0.5;
        double z = (double)blockPos.getZ() + 0.5;
        if (blockEntity.getRitualRecipe() != null) {
            RitualRecipe ritualRecipe = blockEntity.getRitualRecipe();
            Intrinsics.checkNotNull((Object)ritualRecipe);
            for (ItemStack output : ritualRecipe.getOutputItems()) {
                RitualRecipe ritualRecipe2 = blockEntity.getRitualRecipe();
                Intrinsics.checkNotNull((Object)ritualRecipe2);
                if (ritualRecipe2.getFloatingItemOutput()) {
                    FloatingItemEntity itemEntity = new FloatingItemEntity(level);
                    ItemStack itemStack = output.copy();
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
                    itemEntity.setItem(itemStack);
                    itemEntity.moveTo((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, 0.0f, 0.0f);
                    level.addFreshEntity((Entity)itemEntity);
                    continue;
                }
                Containers.dropItemStack((Level)level, (double)x, (double)y, (double)z, (ItemStack)output.copy());
            }
        }
    }

    public final void summonSummons(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull GoldenChalkBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        if (blockEntity.getRitualRecipe() != null) {
            RitualRecipe ritualRecipe = blockEntity.getRitualRecipe();
            Intrinsics.checkNotNull((Object)ritualRecipe);
            for (EntityType<?> entityType : ritualRecipe.getOutputEntities()) {
                Entity entity = entityType.create(level);
                if (!(entity instanceof LivingEntity)) continue;
                float angle = level.random.nextFloat() * (float)360;
                double distance = level.random.nextDouble() * (double)2;
                double x = (double)blockPos.getX() + distance * Math.cos(Math.toRadians(angle));
                double z = (double)blockPos.getZ() + distance * Math.sin(Math.toRadians(angle));
                ((LivingEntity)entity).moveTo(x, (double)blockPos.getY() + 0.2, z, level.random.nextFloat() * (float)360, 0.0f);
                level.addFreshEntity(entity);
            }
        }
    }

    public final void runCommand(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull GoldenChalkBlockEntity blockEntity, @NotNull String phase) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)phase, (String)"phase");
        MinecraftServer server = level.getServer();
        if (blockEntity.getRitualRecipe() != null) {
            RitualRecipe ritualRecipe = blockEntity.getRitualRecipe();
            Intrinsics.checkNotNull((Object)ritualRecipe);
            for (CommandType commandType : ritualRecipe.getCommands()) {
                ServerLevel dimensionLevel;
                Object object;
                ServerPlayer serverPlayer;
                if (!Intrinsics.areEqual((Object)commandType.type(), (Object)phase)) continue;
                if (!((Boolean)WitcheryConfig.ENABLE_CURSES.get()).booleanValue() && this.isCurseCommand(commandType.command())) {
                    Witchery.Companion.logDebugRitual("Skipping curse command - curses disabled in config");
                    continue;
                }
                UUID playerUuid = blockEntity.getTargetPlayer();
                if (playerUuid != null) {
                    UUID it;
                    boolean bl = false;
                    MinecraftServer minecraftServer = server;
                    serverPlayer = minecraftServer != null && (minecraftServer = minecraftServer.getPlayerList()) != null ? minecraftServer.getPlayer(it) : null;
                } else {
                    serverPlayer = null;
                }
                ServerPlayer player = serverPlayer;
                Integer targetEntity = blockEntity.getTargetEntity();
                GlobalPos targetPos = blockEntity.getTargetPos();
                GlobalPos globalPos = targetPos;
                if (globalPos != null && (globalPos = globalPos.dimension()) != null) {
                    GlobalPos it = globalPos;
                    boolean bl = false;
                    MinecraftServer minecraftServer = server;
                    object = minecraftServer != null ? minecraftServer.getLevel((ResourceKey)it) : null;
                } else {
                    object = null;
                }
                ServerLevel serverLevel = dimensionLevel = object;
                GlobalPos globalPos2 = targetPos;
                this.runCommand(blockEntity, serverLevel != null ? (Level)serverLevel : level, server, blockPos, (BlockPos)(globalPos2 != null ? globalPos2.pos() : null), commandType.command(), (Player)player, targetEntity);
            }
        }
    }

    private final boolean isCurseCommand(String command) {
        return StringsKt.contains((CharSequence)command, (CharSequence)"curse apply", (boolean)true) || StringsKt.contains((CharSequence)command, (CharSequence)"werewolf level try_curse", (boolean)true) || StringsKt.contains((CharSequence)command, (CharSequence)"vampire level try_curse", (boolean)true);
    }

    private final void runCommand(GoldenChalkBlockEntity blockEntity, Level level, MinecraftServer minecraftServer, BlockPos blockPos, BlockPos waystonePos, String command, Player player, Integer entityId) {
        Object formattedCommand = command;
        if (minecraftServer != null && ((CharSequence)formattedCommand).length() > 0) {
            String tag;
            Entity entity;
            CommandSourceStack commandSourceStack = minecraftServer.createCommandSourceStack().withSuppressedOutput();
            Intrinsics.checkNotNullExpressionValue((Object)commandSourceStack, (String)"withSuppressedOutput(...)");
            CommandSourceStack commandSource = commandSourceStack;
            Commands commands = minecraftServer.getCommands();
            Intrinsics.checkNotNullExpressionValue((Object)commands, (String)"getCommands(...)");
            Commands commandManager = commands;
            if (player != null) {
                String string = player.getName().getString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                formattedCommand = StringsKt.replace$default((String)formattedCommand, (String)"{taglockPlayer}", (String)string, (boolean)false, (int)4, null);
            }
            if (entityId != null) {
                MinecraftServer minecraftServer2 = level.getServer();
                Intrinsics.checkNotNull((Object)minecraftServer2);
                for (ServerLevel serverLevels : minecraftServer2.getAllLevels()) {
                    entity = serverLevels.getEntity(entityId.intValue());
                    if (!(entity instanceof LivingEntity)) continue;
                    tag = "Waystone_" + ((LivingEntity)entity).getUUID();
                    if (!((LivingEntity)entity).getTags().contains(tag)) {
                        ((LivingEntity)entity).addTag(tag);
                    }
                    formattedCommand = StringsKt.replace$default((String)formattedCommand, (String)"{taglockEntity}", (String)("@e[tag=" + tag + "]"), (boolean)false, (int)4, null);
                    break;
                }
            }
            if (StringsKt.contains$default((CharSequence)((CharSequence)formattedCommand), (CharSequence)"{taglockPlayerOrEntity}", (boolean)false, (int)2, null)) {
                if (player != null) {
                    String string = player.getName().getString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                    formattedCommand = StringsKt.replace$default((String)formattedCommand, (String)"{taglockPlayerOrEntity}", (String)string, (boolean)false, (int)4, null);
                } else if (entityId != null) {
                    MinecraftServer minecraftServer3 = level.getServer();
                    Intrinsics.checkNotNull((Object)minecraftServer3);
                    for (ServerLevel serverLevels : minecraftServer3.getAllLevels()) {
                        entity = serverLevels.getEntity(entityId.intValue());
                        if (!(entity instanceof LivingEntity)) continue;
                        tag = "Waystone_" + ((LivingEntity)entity).getUUID();
                        if (!((LivingEntity)entity).getTags().contains(tag)) {
                            ((LivingEntity)entity).addTag(tag);
                        }
                        formattedCommand = StringsKt.replace$default((String)formattedCommand, (String)"{taglockPlayerOrEntity}", (String)("@e[tag=" + tag + "]"), (boolean)false, (int)4, null);
                        break;
                    }
                }
            }
            if (waystonePos != null) {
                formattedCommand = StringsKt.replace$default((String)formattedCommand, (String)"{waystonePos}", (String)(waystonePos.getX() + " " + waystonePos.getY() + " " + waystonePos.getZ()), (boolean)false, (int)4, null);
            }
            formattedCommand = StringsKt.replace$default((String)formattedCommand, (String)"{time}", (String)String.valueOf(level.getDayTime()), (boolean)false, (int)4, null);
            formattedCommand = StringsKt.replace$default((String)formattedCommand, (String)"{owner}", (String)String.valueOf(blockEntity.getOwnerName()), (boolean)false, (int)4, null);
            formattedCommand = StringsKt.replace$default((String)formattedCommand, (String)"{chalkPos}", (String)(blockPos.getX() + " " + blockPos.getY() + " " + blockPos.getZ()), (boolean)false, (int)4, null);
            formattedCommand = "execute as " + blockEntity.getOwnerName() + " run execute in " + level.dimension().location().getPath() + " run " + (String)formattedCommand;
            ParseResults parseResults = commandManager.getDispatcher().parse((String)formattedCommand, (Object)commandSource);
            Intrinsics.checkNotNullExpressionValue((Object)parseResults, (String)"parse(...)");
            ParseResults parseResults2 = parseResults;
            commandManager.performCommand(parseResults2, (String)formattedCommand);
        }
    }
}

