/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.ritual;

import dev.sterner.witchery.content.recipe.ritual.RitualRecipe;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0002\u00a8\u0006\u0013"}, d2={"Ldev/sterner/witchery/content/block/ritual/RitualPatternUtil;", "", "<init>", "()V", "matchesPattern", "", "level", "Lnet/minecraft/world/level/Level;", "center", "Lnet/minecraft/core/BlockPos;", "recipe", "Ldev/sterner/witchery/content/recipe/ritual/RitualRecipe;", "pattern", "", "", "blockMapping", "", "", "Lnet/minecraft/world/level/block/Block;", "witchery"})
public final class RitualPatternUtil {
    @NotNull
    public static final RitualPatternUtil INSTANCE = new RitualPatternUtil();

    private RitualPatternUtil() {
    }

    public final boolean matchesPattern(@NotNull Level level, @NotNull BlockPos center, @NotNull RitualRecipe recipe) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        List<String> pattern = recipe.getPattern();
        Map<Character, Block> blockMapping = recipe.getBlockMapping();
        return this.matchesPattern(level, center, pattern, blockMapping);
    }

    private final boolean matchesPattern(Level level, BlockPos center, List<String> pattern, Map<Character, ? extends Block> blockMapping) {
        int size = pattern.size();
        int halfSize = size / 2;
        int n = ((Collection)pattern).size();
        for (int z = 0; z < n; ++z) {
            int n2 = ((CharSequence)pattern.get(z)).length();
            for (int x = 0; x < n2; ++x) {
                char c = pattern.get(z).charAt(x);
                if (c == '_') continue;
                BlockPos targetBlockPos = center.offset(x - halfSize, 0, z - halfSize);
                Block targetBlock = level.getBlockState(targetBlockPos).getBlock();
                if (x == halfSize && z == halfSize && !Intrinsics.areEqual((Object)targetBlock, (Object)WitcheryBlocks.INSTANCE.getGOLDEN_CHALK_BLOCK().get())) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)blockMapping.get(Character.valueOf(c)), (Object)targetBlock)) continue;
                return false;
            }
        }
        return true;
    }
}

