/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.spirit_portal;

import dev.sterner.witchery.content.block.spirit_portal.SpiritPortalBlock;
import dev.sterner.witchery.core.api.multiblock.MultiBlockComponentBlock;
import dev.sterner.witchery.core.api.multiblock.MultiBlockComponentBlockEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J(\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J8\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0016J\u001c\u0010\"\u001a\u00020\u00152\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00070$H\u0014J\u0010\u0010%\u001a\u00020&2\u0006\u0010\f\u001a\u00020\u0007H\u0014\u00a8\u0006'"}, d2={"Ldev/sterner/witchery/content/block/spirit_portal/SpiritPortalBlockComponent;", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockComponentBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getStateForPlacement", "Lnet/minecraft/world/level/block/state/BlockState;", "blockPlaceContext", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "state", "level", "Lnet/minecraft/world/level/BlockGetter;", "pos", "Lnet/minecraft/core/BlockPos;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "getCollisionShape", "entityInside", "", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "neighborChanged", "pState", "pLevel", "pPos", "pBlock", "Lnet/minecraft/world/level/block/Block;", "pFromPos", "pIsMoving", "", "createBlockStateDefinition", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "witchery"})
public final class SpiritPortalBlockComponent
extends MultiBlockComponentBlock {
    public SpiritPortalBlockComponent(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        BlockBehaviour.Properties properties2 = properties.noOcclusion().noCollission().lightLevel(SpiritPortalBlock.Companion.litBlockEmission(8));
        Intrinsics.checkNotNullExpressionValue((Object)properties2, (String)"lightLevel(...)");
        super(properties2);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext blockPlaceContext) {
        Intrinsics.checkNotNullParameter((Object)blockPlaceContext, (String)"blockPlaceContext");
        Object object = this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)blockPlaceContext.getHorizontalDirection().getOpposite());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction dir;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Direction direction = dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> SpiritPortalBlock.Companion.getNORTH();
            case 2 -> SpiritPortalBlock.Companion.getEAST();
            case 3 -> SpiritPortalBlock.Companion.getWEST();
            default -> SpiritPortalBlock.Companion.getSOUTH();
        };
    }

    @NotNull
    protected VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction dir;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (((Boolean)state.getValue((Property)BlockStateProperties.OPEN)).booleanValue()) {
            VoxelShape voxelShape = Shapes.empty();
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"empty(...)");
            return voxelShape;
        }
        Direction direction = dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> SpiritPortalBlock.Companion.getNORTH();
            case 2 -> SpiritPortalBlock.Companion.getEAST();
            case 3 -> SpiritPortalBlock.Companion.getWEST();
            default -> SpiritPortalBlock.Companion.getSOUTH();
        };
    }

    protected void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof Player && ((Boolean)state.getValue((Property)BlockStateProperties.OPEN)).booleanValue()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            MultiBlockComponentBlockEntity multiBlockComponentBlockEntity = blockEntity instanceof MultiBlockComponentBlockEntity ? (MultiBlockComponentBlockEntity)blockEntity : null;
            if (multiBlockComponentBlockEntity == null) {
                return;
            }
            MultiBlockComponentBlockEntity componentBlockEntity = multiBlockComponentBlockEntity;
            BlockPos blockPos = componentBlockEntity.getCorePos();
            if (blockPos == null) {
                return;
            }
            BlockPos corePos = blockPos;
            BlockState coreBlockState = level.getBlockState(corePos);
            if (coreBlockState.getBlock() instanceof SpiritPortalBlock) {
                VoxelShape voxelShape;
                Direction dir;
                Block block = coreBlockState.getBlock();
                Intrinsics.checkNotNull((Object)block, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.block.spirit_portal.SpiritPortalBlock");
                SpiritPortalBlock corePortalBlock = (SpiritPortalBlock)block;
                Direction direction = dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                    case 1: {
                        voxelShape = SpiritPortalBlock.Companion.getNORTH();
                        break;
                    }
                    case 2: {
                        voxelShape = SpiritPortalBlock.Companion.getEAST();
                        break;
                    }
                    case 3: {
                        voxelShape = SpiritPortalBlock.Companion.getWEST();
                        break;
                    }
                    case 4: {
                        voxelShape = SpiritPortalBlock.Companion.getSOUTH();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                VoxelShape portalShape = voxelShape;
                AABB portalBoundingBox = portalShape.bounds().move(pos);
                if (portalBoundingBox.intersects(((Player)entity).getBoundingBox())) {
                    corePortalBlock.handleEntityInside(level, (Player)entity);
                }
            }
        }
        super.entityInside(state, level, pos, entity);
    }

    @Override
    public void neighborChanged(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Block pBlock, @NotNull BlockPos pFromPos, boolean pIsMoving) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlock, (String)"pBlock");
        Intrinsics.checkNotNullParameter((Object)pFromPos, (String)"pFromPos");
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        BlockState neighborState = pLevel.getBlockState(pFromPos);
        if (neighborState.getBlock() instanceof SpiritPortalBlock || neighborState.getBlock() instanceof SpiritPortalBlockComponent) {
            Boolean isOpen = (Boolean)neighborState.getValue((Property)BlockStateProperties.OPEN);
            if (!Intrinsics.areEqual((Object)pState.getValue((Property)BlockStateProperties.OPEN), (Object)isOpen)) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)BlockStateProperties.OPEN, (Comparable)isOpen), 3);
            }
        }
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.OPEN};
        builder.add(propertyArray);
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.INVISIBLE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

