/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.werewolf_altar;

import dev.sterner.witchery.content.block.bear_trap.BearTrapBlock;
import dev.sterner.witchery.content.block.werewolf_altar.WerewolfAltarBlock;
import dev.sterner.witchery.content.entity.WerewolfEntity;
import dev.sterner.witchery.content.item.curios.MoonCharmItem;
import dev.sterner.witchery.core.api.multiblock.MultiBlockCoreEntity;
import dev.sterner.witchery.core.api.multiblock.MultiBlockStructure;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.werewolf.WerewolfLeveling;
import dev.sterner.witchery.network.SpawnItemParticlesS2CPayload;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0018\u0010 \u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\nH\u0002J\u0018\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014J\u0018\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020&H\u0014R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ldev/sterner/witchery/content/block/werewolf_altar/WerewolfAltarBlockEntity;", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockCoreEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "items", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "getItems", "()Lnet/minecraft/core/NonNullList;", "setItems", "(Lnet/minecraft/core/NonNullList;)V", "conversionTicks", "", "onUseWithItem", "Lnet/minecraft/world/ItemInteractionResult;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "pStack", "pHand", "Lnet/minecraft/world/InteractionHand;", "play", "", "tickServer", "serverLevel", "Lnet/minecraft/server/level/ServerLevel;", "lookForWerewolf", "level", "pos", "spawnConsumeParticles", "itemStack", "loadAdditional", "pTag", "Lnet/minecraft/nbt/CompoundTag;", "pRegistries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "tag", "registries", "witchery"})
@SourceDebugExtension(value={"SMAP\nWerewolfAltarBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WerewolfAltarBlockEntity.kt\ndev/sterner/witchery/content/block/werewolf_altar/WerewolfAltarBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n774#2:199\n865#2,2:200\n1869#2,2:202\n774#2:204\n865#2,2:205\n1869#2,2:207\n1869#2,2:209\n*S KotlinDebug\n*F\n+ 1 WerewolfAltarBlockEntity.kt\ndev/sterner/witchery/content/block/werewolf_altar/WerewolfAltarBlockEntity\n*L\n115#1:199\n115#1:200,2\n119#1:202,2\n134#1:204\n134#1:205,2\n138#1:207,2\n156#1:209,2\n*E\n"})
public final class WerewolfAltarBlockEntity
extends MultiBlockCoreEntity {
    @NotNull
    private NonNullList<ItemStack> items;
    private int conversionTicks;

    public WerewolfAltarBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = WitcheryBlockEntityTypes.INSTANCE.getWEREWOLF_ALTAR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        BlockEntityType blockEntityType = (BlockEntityType)object;
        MultiBlockStructure multiBlockStructure = WerewolfAltarBlock.Companion.getSTRUCTURE().get();
        Intrinsics.checkNotNullExpressionValue((Object)multiBlockStructure, (String)"get(...)");
        super(blockEntityType, multiBlockStructure, blockPos, blockState);
        NonNullList nonNullList = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.items = nonNullList;
    }

    @NotNull
    public final NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public final void setItems(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"<set-?>");
        this.items = nonNullList;
    }

    @Override
    @NotNull
    public ItemInteractionResult onUseWithItem(@NotNull Player pPlayer, @NotNull ItemStack pStack, @NotNull InteractionHand pHand) {
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Intrinsics.checkNotNullParameter((Object)pStack, (String)"pStack");
        Intrinsics.checkNotNullParameter((Object)pHand, (String)"pHand");
        if (pPlayer instanceof ServerPlayer && pHand == InteractionHand.MAIN_HAND) {
            boolean hasWolf;
            AfflictionPlayerAttachment.Data data2 = AfflictionPlayerAttachment.getData(pPlayer);
            boolean hasSheep = data2.getKilledSheep() >= 20;
            boolean bl = hasWolf = data2.getKilledWolves() >= 10;
            if (((ItemStack)this.items.get(0)).isEmpty() && pStack.is(Items.GOLD_INGOT) && pStack.getCount() >= 3) {
                pStack.shrink(3);
                this.items.set(0, (Object)new ItemStack((ItemLike)Items.GOLD_INGOT, 3).copy());
                WerewolfLeveling.INSTANCE.setHasGivenGold((ServerPlayer)pPlayer);
                this.play();
            } else if (hasSheep && ((ItemStack)this.items.get(0)).isEmpty() && pStack.is(Items.MUTTON) && pStack.getCount() >= 30) {
                pStack.shrink(30);
                this.items.set(0, (Object)new ItemStack((ItemLike)Items.MUTTON, 30));
                this.play();
            } else if (hasWolf && ((ItemStack)this.items.get(0)).isEmpty() && pStack.is((Item)WitcheryItems.INSTANCE.getTONGUE_OF_DOG().get()) && pStack.getCount() >= 10) {
                pStack.shrink(10);
                this.items.set(0, (Object)new ItemStack((ItemLike)WitcheryItems.INSTANCE.getTONGUE_OF_DOG().get(), 10).copy());
                this.play();
            } else if (((ServerPlayer)pPlayer).getMainHandItem().isEmpty()) {
                pPlayer.setItemInHand(InteractionHand.MAIN_HAND, (ItemStack)this.items.get(0));
                this.items.clear();
                this.play();
            }
            this.setChanged();
        }
        return super.onUseWithItem(pPlayer, pStack, pHand);
    }

    public final void play() {
        block0: {
            Level level = this.level;
            if (level == null) break block0;
            level.playSound(null, this.getBlockPos(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void tickServer(@NotNull ServerLevel serverLevel) {
        block11: {
            block17: {
                block16: {
                    block13: {
                        block15: {
                            block14: {
                                block12: {
                                    Intrinsics.checkNotNullParameter((Object)serverLevel, (String)"serverLevel");
                                    super.tickServer(serverLevel);
                                    v0 = this.items.get(0);
                                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"get(...)");
                                    item = (ItemStack)v0;
                                    if (item.isEmpty()) break block11;
                                    if (!item.is(Items.GOLD_INGOT)) break block12;
                                    var3_3 = this.conversionTicks;
                                    this.conversionTicks = var3_3 + 1;
                                    this.spawnConsumeParticles(serverLevel, item);
                                    if (this.conversionTicks >= 40) {
                                        this.conversionTicks = 0;
                                        this.items.clear();
                                        this.items.set(0, (Object)((MoonCharmItem)WitcheryItems.INSTANCE.getMOON_CHARM().get()).getDefaultInstance());
                                        this.setChanged();
                                    }
                                    break block11;
                                }
                                if (!item.is(Items.MUTTON)) break block13;
                                var3_4 = this.conversionTicks;
                                this.conversionTicks = var3_4 + 1;
                                this.spawnConsumeParticles(serverLevel, item);
                                if (this.conversionTicks < 40) break block11;
                                this.conversionTicks = 0;
                                this.items.clear();
                                box = new AABB(this.getBlockPos()).inflate(12.0);
                                v1 /* !! */  = this.level;
                                if (v1 /* !! */  == null || (v1 /* !! */  = v1 /* !! */ .getEntitiesOfClass(ServerPlayer.class, box)) == null) break block14;
                                $this$filter$iv = (Iterable)v1 /* !! */ ;
                                $i$f$filter = false;
                                var9_14 = $this$filter$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    it = (ServerPlayer)element$iv$iv;
                                    $i$a$-filter-WerewolfAltarBlockEntity$tickServer$players$1 = false;
                                    if (!it.isAlive()) ** GOTO lbl-1000
                                    Intrinsics.checkNotNull((Object)it);
                                    if (AfflictionPlayerAttachment.getData((Player)it).getWerewolfLevel() == 2) {
                                        v2 = true;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v2 = false;
                                    }
                                    if (!v2) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                v3 = (List)destination$iv$iv;
                                break block15;
                            }
                            v3 = null;
                        }
                        v4 = players = v3;
                        if (v4 != null) {
                            $this$forEach$iv = v4;
                            $i$f$forEach = false;
                            for (E element$iv : $this$forEach$iv) {
                                player = (ServerPlayer)element$iv;
                                $i$a$-forEach-WerewolfAltarBlockEntity$tickServer$1 = false;
                                Intrinsics.checkNotNull((Object)player);
                                WerewolfLeveling.INSTANCE.setHasOfferedMutton(player);
                            }
                        }
                        this.setChanged();
                        break block11;
                    }
                    if (!item.is((Item)WitcheryItems.INSTANCE.getTONGUE_OF_DOG().get())) break block11;
                    box = this.conversionTicks;
                    this.conversionTicks = box + 1;
                    this.spawnConsumeParticles(serverLevel, item);
                    if (this.conversionTicks < 40) break block11;
                    this.conversionTicks = 0;
                    this.items.clear();
                    box = new AABB(this.getBlockPos()).inflate(12.0);
                    v5 /* !! */  = this.level;
                    if (v5 /* !! */  == null || (v5 /* !! */  = v5 /* !! */ .getEntitiesOfClass(ServerPlayer.class, box)) == null) break block16;
                    $this$filter$iv = (Iterable)v5 /* !! */ ;
                    $i$f$filter = false;
                    player = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (ServerPlayer)element$iv$iv;
                        $i$a$-filter-WerewolfAltarBlockEntity$tickServer$players$2 = false;
                        if (!it.isAlive()) ** GOTO lbl-1000
                        Intrinsics.checkNotNull((Object)it);
                        if (AfflictionPlayerAttachment.getData((Player)it).getWerewolfLevel() == 3) {
                            v6 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v6 = false;
                        }
                        if (!v6) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    v7 = (List)destination$iv$iv;
                    break block17;
                }
                v7 = null;
            }
            v8 = players = v7;
            if (v8 != null) {
                $this$forEach$iv = v8;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    player = (ServerPlayer)element$iv;
                    $i$a$-forEach-WerewolfAltarBlockEntity$tickServer$2 = false;
                    Intrinsics.checkNotNull((Object)player);
                    WerewolfLeveling.INSTANCE.setHasOfferedTongues((ServerPlayer)player);
                }
            }
            this.setChanged();
        }
        v9 = this.getBlockPos();
        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getBlockPos(...)");
        this.lookForWerewolf(serverLevel, v9);
    }

    private final void lookForWerewolf(ServerLevel level, BlockPos pos) {
        if (level.getGameTime() % (long)20 == 0L) {
            AABB box = new AABB(pos).inflate(4.0);
            Stream<Object> traps = BlockPos.betweenClosedStream((AABB)box).filter(arg_0 -> WerewolfAltarBlockEntity.lookForWerewolf$lambda$1(arg_0 -> WerewolfAltarBlockEntity.lookForWerewolf$lambda$0(level, arg_0), arg_0));
            traps.forEach(arg_0 -> WerewolfAltarBlockEntity.lookForWerewolf$lambda$3(arg_0 -> WerewolfAltarBlockEntity.lookForWerewolf$lambda$2(level, arg_0), arg_0));
        }
    }

    private final void spawnConsumeParticles(ServerLevel level, ItemStack itemStack) {
        if ((double)level.random.nextFloat() < 0.3) {
            Direction dir = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            Vec3 offset = new Vec3(-0.35, 0.4, 0.9);
            Direction direction = dir;
            Vec3 rotatedOffset = switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1 -> offset;
                case 2 -> new Vec3(-offset.x, offset.y, -offset.z);
                case 3 -> new Vec3(offset.z, offset.y, -offset.x);
                case 4 -> new Vec3(-offset.z, offset.y, offset.x);
                default -> offset;
            };
            Vec3 spawnPos = this.getBlockPos().getCenter().add(rotatedOffset);
            ChunkPos chunkPos = new ChunkPos(this.getBlockPos());
            Intrinsics.checkNotNull((Object)spawnPos);
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)chunkPos, (CustomPacketPayload)new SpawnItemParticlesS2CPayload(spawnPos, itemStack), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistries) {
        Intrinsics.checkNotNullParameter((Object)pTag, (String)"pTag");
        Intrinsics.checkNotNullParameter((Object)pRegistries, (String)"pRegistries");
        super.loadAdditional(pTag, pRegistries);
        NonNullList nonNullList = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.items = nonNullList;
        ContainerHelper.loadAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)pRegistries);
        this.conversionTicks = pTag.getInt("ConversionTicks");
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        tag.putInt("ConversionTicks", this.conversionTicks);
    }

    private static final boolean lookForWerewolf$lambda$0(ServerLevel $level, BlockPos it) {
        return $level.getBlockState(it).getBlock() instanceof BearTrapBlock;
    }

    private static final boolean lookForWerewolf$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit lookForWerewolf$lambda$2(ServerLevel $level, BlockPos blockPos) {
        AABB trapAabb = new AABB(blockPos).inflate(0.0, 1.0, 0.0);
        List werewolves = $level.getEntities((EntityTypeTest)WitcheryEntityTypes.INSTANCE.getWEREWOLF().get(), trapAabb, arg_0 -> WerewolfAltarBlockEntity.lookForWerewolf$lambda$2$1(WerewolfAltarBlockEntity::lookForWerewolf$lambda$2$0, arg_0));
        Intrinsics.checkNotNull((Object)werewolves);
        Iterable $this$forEach$iv = werewolves;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WerewolfEntity entity = (WerewolfEntity)((Object)element$iv);
            boolean bl = false;
            entity.getEntityData().set(WerewolfEntity.Companion.getCAN_INFECT(), (Object)true);
        }
        return Unit.INSTANCE;
    }

    private static final boolean lookForWerewolf$lambda$2$0(WerewolfEntity it) {
        return it.isAlive();
    }

    private static final boolean lookForWerewolf$lambda$2$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void lookForWerewolf$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

