/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import java.lang.invoke.LambdaMetafactory;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0002*+B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J \u0010\u0011\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u001a\u001a\u00020\u0018H\u0014J\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0016J\b\u0010\u001f\u001a\u00020\rH\u0016J\u0010\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010%\u001a\u00020$H\u0014J\u0018\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020$H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006,"}, d2={"Ldev/sterner/witchery/content/entity/BabaYagaEntity;", "Lnet/minecraft/world/entity/monster/Monster;", "Lnet/minecraft/world/entity/monster/RangedAttackMob;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "usingTime", "", "attackPlayersGoal", "Ldev/sterner/witchery/content/entity/BabaYagaEntity$NearestAttackableBabaTargetGoal;", "Lnet/minecraft/world/entity/player/Player;", "registerGoals", "", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "dropCustomDeathLoot", "Lnet/minecraft/server/level/ServerLevel;", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "recentlyHit", "", "getAmbientSound", "Lnet/minecraft/sounds/SoundEvent;", "getHurtSound", "getDeathSound", "setUsingItem", "usingItem", "isDrinkingPotion", "()Z", "aiStep", "handleEntityEvent", "id", "", "getDamageAfterMagicAbsorb", "", "damageAmount", "performRangedAttack", "target", "Lnet/minecraft/world/entity/LivingEntity;", "velocity", "Companion", "NearestAttackableBabaTargetGoal", "witchery"})
@SourceDebugExtension(value={"SMAP\nBabaYagaEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BabaYagaEntity.kt\ndev/sterner/witchery/content/entity/BabaYagaEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,275:1\n1869#2,2:276\n*S KotlinDebug\n*F\n+ 1 BabaYagaEntity.kt\ndev/sterner/witchery/content/entity/BabaYagaEntity\n*L\n168#1:276,2\n*E\n"})
public final class BabaYagaEntity
extends Monster
implements RangedAttackMob {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int usingTime;
    @Nullable
    private NearestAttackableBabaTargetGoal<Player> attackPlayersGoal;
    @NotNull
    private static final ResourceLocation SPEED_MODIFIER_DRINKING_ID;
    @NotNull
    private static final AttributeModifier SPEED_MODIFIER_DRINKING;
    @NotNull
    private static final EntityDataAccessor<Boolean> DATA_USING_ITEM;

    public BabaYagaEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getBABA_YAGA().get(), level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.attackPlayersGoal = new NearestAttackableBabaTargetGoal<Player>(this, Player.class, 10, null);
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 60, 10.0f));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        NearestAttackableBabaTargetGoal<Player> nearestAttackableBabaTargetGoal = this.attackPlayersGoal;
        Intrinsics.checkNotNull(nearestAttackableBabaTargetGoal);
        this.targetSelector.addGoal(3, (Goal)nearestAttackableBabaTargetGoal);
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(DATA_USING_ITEM, (Object)false);
    }

    protected void dropCustomDeathLoot(@NotNull ServerLevel level, @NotNull DamageSource damageSource, boolean recentlyHit) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        this.spawnAtLocation((ItemLike)WitcheryItems.INSTANCE.getBABA_YAGAS_HAT().get());
        super.dropCustomDeathLoot(level, damageSource, recentlyHit);
    }

    @NotNull
    protected SoundEvent getAmbientSound() {
        SoundEvent soundEvent = SoundEvents.WITCH_AMBIENT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"WITCH_AMBIENT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        SoundEvent soundEvent = SoundEvents.WITCH_HURT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"WITCH_HURT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        SoundEvent soundEvent = SoundEvents.WITCH_DEATH;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"WITCH_DEATH");
        return soundEvent;
    }

    public final void setUsingItem(boolean usingItem) {
        this.getEntityData().set(DATA_USING_ITEM, (Object)usingItem);
    }

    public final boolean isDrinkingPotion() {
        Object object = this.getEntityData().get(DATA_USING_ITEM);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    /*
     * Unable to fully structure code
     */
    public void aiStep() {
        block14: {
            block16: {
                block18: {
                    block19: {
                        block17: {
                            block15: {
                                if (this.level().isClientSide || !this.isAlive()) break block14;
                                v0 = this.attackPlayersGoal;
                                Intrinsics.checkNotNull(v0);
                                v0.setCanAttack(true);
                                if (!this.isDrinkingPotion()) break block15;
                                var1_1 = this.usingTime;
                                this.usingTime = var1_1 + -1;
                                if (var1_1 <= 0) {
                                    this.setUsingItem(false);
                                    itemStack = this.getMainHandItem();
                                    this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                                    potionContents = (PotionContents)itemStack.get(DataComponents.POTION_CONTENTS);
                                    if (itemStack.is(Items.POTION) && potionContents != null) {
                                        potionContents.forEachEffect((Consumer<MobEffectInstance>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, aiStep$lambda$0(dev.sterner.witchery.content.entity.BabaYagaEntity net.minecraft.world.effect.MobEffectInstance ), (Lnet/minecraft/world/effect/MobEffectInstance;)V)((BabaYagaEntity)this));
                                    }
                                    this.gameEvent((Holder)GameEvent.DRINK);
                                    v1 = this.getAttribute(Attributes.MOVEMENT_SPEED);
                                    if (v1 != null) {
                                        v1.removeModifier(BabaYagaEntity.SPEED_MODIFIER_DRINKING.id());
                                    }
                                }
                                break block16;
                            }
                            holder = null;
                            if (!(this.random.nextFloat() < 0.15f) || !this.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value()) || this.hasEffect(MobEffects.WATER_BREATHING)) break block17;
                            holder = Potions.WATER_BREATHING;
                            break block18;
                        }
                        if (!(this.random.nextFloat() < 0.15f)) ** GOTO lbl-1000
                        if (this.isOnFire()) break block19;
                        if (this.getLastDamageSource() == null) ** GOTO lbl-1000
                        v2 = this.getLastDamageSource();
                        Intrinsics.checkNotNull((Object)v2);
                        if (!v2.is(DamageTypeTags.IS_FIRE)) ** GOTO lbl-1000
                    }
                    if (!this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
                        holder = Potions.FIRE_RESISTANCE;
                    } else if (this.random.nextFloat() < 0.05f && this.getHealth() < this.getMaxHealth()) {
                        holder = Potions.HEALING;
                    } else if (this.random.nextFloat() < 0.5f && this.getTarget() != null && !this.hasEffect(MobEffects.MOVEMENT_SPEED)) {
                        v3 = this.getTarget();
                        Intrinsics.checkNotNull((Object)v3);
                        if (v3.distanceToSqr((Entity)this) > 121.0) {
                            holder = Potions.SWIFTNESS;
                        }
                    }
                }
                if (holder != null) {
                    this.setItemSlot(EquipmentSlot.MAINHAND, PotionContents.createItemStack((Item)Items.POTION, (Holder)holder));
                    this.usingTime = this.getMainHandItem().getUseDuration((LivingEntity)this);
                    this.setUsingItem(true);
                    if (!this.isSilent()) {
                        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WITCH_DRINK, this.getSoundSource(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
                    }
                    v4 = attributeInstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
                    if (v4 != null) {
                        v4.removeModifier(BabaYagaEntity.SPEED_MODIFIER_DRINKING_ID);
                    }
                    v5 = attributeInstance;
                    if (v5 != null) {
                        v5.addTransientModifier(BabaYagaEntity.SPEED_MODIFIER_DRINKING);
                    }
                }
            }
            if (this.random.nextFloat() < 7.5E-4f) {
                this.level().broadcastEntityEvent((Entity)this, (byte)15);
            }
        }
        super.aiStep();
    }

    public void handleEntityEvent(byte id) {
        if (id == 15) {
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)(this.random.nextInt(35) + 10));
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int i = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                this.level().addParticle((ParticleOptions)ParticleTypes.WITCH, this.getX() + this.random.nextGaussian() * (double)0.13f, this.getBoundingBox().maxY + 0.5 + this.random.nextGaussian() * (double)0.13f, this.getZ() + this.random.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    protected float getDamageAfterMagicAbsorb(@NotNull DamageSource damageSource, float damageAmount) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        float damageAmount2 = damageAmount;
        damageAmount2 = super.getDamageAfterMagicAbsorb(damageSource, damageAmount2);
        if (damageSource.getEntity() == this) {
            damageAmount2 = 0.0f;
        }
        if (damageSource.is(DamageTypeTags.WITCH_RESISTANT_TO)) {
            damageAmount2 *= 0.15f;
        }
        return damageAmount2;
    }

    public void performRangedAttack(@NotNull LivingEntity target, float velocity) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!this.isDrinkingPotion()) {
            Vec3 vec3 = target.getDeltaMovement();
            double d = target.getX() + vec3.x - this.getX();
            double e = target.getEyeY() - (double)1.1f - this.getY();
            double f = target.getZ() + vec3.z - this.getZ();
            double g = Math.sqrt(d * d + f * f);
            Holder holder = Potions.HARMING;
            if (target instanceof Raider) {
                holder = ((Raider)target).getHealth() <= 4.0f ? Potions.HEALING : Potions.REGENERATION;
                this.setTarget(null);
            } else if (g >= 8.0 && !target.hasEffect(MobEffects.MOVEMENT_SLOWDOWN)) {
                holder = Potions.SLOWNESS;
            } else if (target.getHealth() >= 8.0f && !target.hasEffect(MobEffects.POISON)) {
                holder = Potions.POISON;
            } else if (g <= 3.0 && !target.hasEffect(MobEffects.WEAKNESS) && this.random.nextFloat() < 0.25f) {
                holder = Potions.WEAKNESS;
            }
            ThrownPotion thrownPotion = new ThrownPotion(this.level(), (LivingEntity)this);
            thrownPotion.setItem(PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)holder));
            thrownPotion.setXRot(thrownPotion.getXRot() - -20.0f);
            thrownPotion.shoot(d, e + g * 0.2, f, 0.75f, 8.0f);
            if (!this.isSilent()) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WITCH_THROW, this.getSoundSource(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
            }
            this.level().addFreshEntity((Entity)thrownPotion);
        }
    }

    private static final void aiStep$lambda$0(BabaYagaEntity this$0, MobEffectInstance effectInstance) {
        Intrinsics.checkNotNullParameter((Object)effectInstance, (String)"effectInstance");
        this$0.addEffect(effectInstance);
    }

    static {
        ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace((String)"drinking");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"withDefaultNamespace(...)");
        SPEED_MODIFIER_DRINKING_ID = resourceLocation;
        SPEED_MODIFIER_DRINKING = new AttributeModifier(SPEED_MODIFIER_DRINKING_ID, -0.25, AttributeModifier.Operation.ADD_VALUE);
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(BabaYagaEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        DATA_USING_ITEM = entityDataAccessor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/content/entity/BabaYagaEntity$Companion;", "", "<init>", "()V", "SPEED_MODIFIER_DRINKING_ID", "Lnet/minecraft/resources/ResourceLocation;", "SPEED_MODIFIER_DRINKING", "Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;", "DATA_USING_ITEM", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 64.0).add(Attributes.MOVEMENT_SPEED, 0.24);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fJ\b\u0010\u0013\u001a\u00020\u000fH\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/content/entity/BabaYagaEntity$NearestAttackableBabaTargetGoal;", "T", "Lnet/minecraft/world/entity/LivingEntity;", "Lnet/minecraft/world/entity/ai/goal/target/NearestAttackableTargetGoal;", "mob", "Ldev/sterner/witchery/content/entity/BabaYagaEntity;", "targetType", "Ljava/lang/Class;", "randomInterval", "", "targetPredicate", "Ljava/util/function/Predicate;", "<init>", "(Ldev/sterner/witchery/content/entity/BabaYagaEntity;Ljava/lang/Class;ILjava/util/function/Predicate;)V", "canAttack", "", "setCanAttack", "", "active", "canUse", "witchery"})
    public static final class NearestAttackableBabaTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        private boolean canAttack;

        public NearestAttackableBabaTargetGoal(@NotNull BabaYagaEntity mob, @NotNull Class<T> targetType, int randomInterval, @Nullable Predicate<LivingEntity> targetPredicate) {
            Intrinsics.checkNotNullParameter((Object)((Object)mob), (String)"mob");
            Intrinsics.checkNotNullParameter(targetType, (String)"targetType");
            super((Mob)mob, targetType, randomInterval, true, false, targetPredicate);
            this.canAttack = true;
        }

        public final void setCanAttack(boolean active) {
            this.canAttack = active;
        }

        public boolean canUse() {
            return this.canAttack && super.canUse();
        }
    }
}

