/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import java.util.Collection;
import java.util.function.IntFunction;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0002 !B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0018J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010\u001f\u001a\u00020\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ldev/sterner/witchery/content/entity/EntEntity;", "Lnet/minecraft/world/entity/monster/Monster;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "attackAnimationTick", "", "registerGoals", "", "aiStep", "handleEntityEvent", "id", "", "getAttackDamage", "", "doHurtTarget", "", "target", "Lnet/minecraft/world/entity/Entity;", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "getVariant", "Ldev/sterner/witchery/content/entity/EntEntity$Type;", "setVariant", "variant", "addAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "getAttackAnimationTick", "Companion", "Type", "witchery"})
public final class EntEntity
extends Monster {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int attackAnimationTick;
    @NotNull
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID;

    public EntEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getENT().get(), level);
        this.setPersistenceRequired();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
        super.registerGoals();
    }

    public void aiStep() {
        super.aiStep();
        if (this.attackAnimationTick > 0) {
            this.attackAnimationTick += -1;
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.attackAnimationTick = 10;
        } else {
            super.handleEntityEvent(id);
        }
    }

    private final float getAttackDamage() {
        return (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
    }

    public boolean doHurtTarget(@NotNull Entity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.attackAnimationTick = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        float damage = this.getAttackDamage();
        float randomDamage = (int)damage > 0 ? damage / 2.0f + (float)this.random.nextInt((int)damage) : damage;
        DamageSource damageSource = this.damageSources().mobAttack((LivingEntity)this);
        boolean bl = target.hurt(damageSource, randomDamage);
        if (bl) {
            double knockback = target instanceof LivingEntity ? ((LivingEntity)target).getAttributeValue(Attributes.KNOCKBACK_RESISTANCE) : 0.0;
            double e = Math.max(0.0, 1.0 - knockback);
            target.setDeltaMovement(target.getDeltaMovement().add(0.0, 0.4 * e, 0.0));
            Level level = this.level();
            if (level instanceof ServerLevel) {
                EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)level), (Entity)target, (DamageSource)damageSource);
            }
        }
        return bl;
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(DATA_TYPE_ID, (Object)0);
    }

    @NotNull
    public final Type getVariant() {
        Object object = this.entityData.get(DATA_TYPE_ID);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return Type.Companion.byId(((Number)object).intValue());
    }

    public final void setVariant(@NotNull Type variant) {
        Intrinsics.checkNotNullParameter((Object)((Object)variant), (String)"variant");
        this.entityData.set(DATA_TYPE_ID, (Object)variant.getId());
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.addAdditionalSaveData(compound);
        compound.putString("Type", this.getVariant().getSerializedName());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.readAdditionalSaveData(compound);
        this.setVariant(Type.Companion.byName(compound.getString("Type")));
    }

    public final int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(EntEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        DATA_TYPE_ID = entityDataAccessor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Ldev/sterner/witchery/content/entity/EntEntity$Companion;", "", "<init>", "()V", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "DATA_TYPE_ID", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getDATA_TYPE_ID", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.FOLLOW_RANGE, 48.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getDATA_TYPE_ID() {
            return DATA_TYPE_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u0000 \u000f2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u000fB\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u0006H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u0010"}, d2={"Ldev/sterner/witchery/content/entity/EntEntity$Type;", "Lnet/minecraft/util/StringRepresentable;", "", "id", "", "inName", "", "<init>", "(Ljava/lang/String;IILjava/lang/String;)V", "getId", "()I", "ROWAN", "ALDER", "HAWTHORN", "getSerializedName", "Companion", "witchery"})
    @SourceDebugExtension(value={"SMAP\nEntEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntEntity.kt\ndev/sterner/witchery/content/entity/EntEntity$Type\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,165:1\n37#2,2:166\n37#2,2:168\n*S KotlinDebug\n*F\n+ 1 EntEntity.kt\ndev/sterner/witchery/content/entity/EntEntity$Type\n*L\n152#1:166,2\n154#1:168,2\n*E\n"})
    public static final class Type
    extends Enum<Type>
    implements StringRepresentable {
        @NotNull
        public static final Companion Companion;
        private final int id;
        @NotNull
        private final String inName;
        @NotNull
        private static final StringRepresentable.EnumCodec<Type> CODEC;
        @NotNull
        private static final IntFunction<Type> BY_ID;
        public static final /* enum */ Type ROWAN;
        public static final /* enum */ Type ALDER;
        public static final /* enum */ Type HAWTHORN;
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Type(int id, String inName) {
            this.id = id;
            this.inName = inName;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public String getSerializedName() {
            return this.inName;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        private static final Type[] CODEC$lambda$0() {
            Collection $this$toTypedArray$iv = (Collection)Type.getEntries();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new Type[0]);
        }

        private static final int BY_ID$lambda$0(Type obj) {
            Intrinsics.checkNotNullParameter((Object)((Object)obj), (String)"obj");
            return obj.id;
        }

        static {
            ROWAN = new Type(0, "rowan");
            ALDER = new Type(1, "alder");
            HAWTHORN = new Type(2, "hawthorn");
            $VALUES = typeArray = new Type[]{Type.ROWAN, Type.ALDER, Type.HAWTHORN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            StringRepresentable.EnumCodec enumCodec = StringRepresentable.fromEnum(Type::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)enumCodec, (String)"fromEnum(...)");
            CODEC = enumCodec;
            Collection $this$toTypedArray$iv = (Collection)Type.getEntries();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            IntFunction intFunction = ByIdMap.continuous(Type::BY_ID$lambda$0, (Object[])thisCollection$iv.toArray(new Type[0]), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            Intrinsics.checkNotNullExpressionValue((Object)intFunction, (String)"continuous(...)");
            BY_ID = intFunction;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/sterner/witchery/content/entity/EntEntity$Type$Companion;", "", "<init>", "()V", "CODEC", "Lnet/minecraft/util/StringRepresentable$EnumCodec;", "Ldev/sterner/witchery/content/entity/EntEntity$Type;", "getCODEC", "()Lnet/minecraft/util/StringRepresentable$EnumCodec;", "BY_ID", "Ljava/util/function/IntFunction;", "byName", "name", "", "byId", "index", "", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final StringRepresentable.EnumCodec<Type> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final Type byName(@Nullable String name) {
                Enum enum_ = this.getCODEC().byName(name, (Enum)ROWAN);
                Intrinsics.checkNotNull((Object)enum_, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.entity.EntEntity.Type");
                return (Type)enum_;
            }

            @NotNull
            public final Type byId(int index) {
                Object r = BY_ID.apply(index);
                Intrinsics.checkNotNull(r, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.entity.EntEntity.Type");
                return (Type)((Object)r);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

