/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import dev.sterner.witchery.content.block.arthana.ArthanaBlock;
import dev.sterner.witchery.content.block.arthana.ArthanaBlockEntity;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import dev.sterner.witchery.core.registry.WitcheryItems;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Ldev/sterner/witchery/content/item/ArthanaItem;", "Lnet/minecraft/world/item/SwordItem;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "hurtEnemy", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "target", "Lnet/minecraft/world/entity/LivingEntity;", "attacker", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "witchery"})
public final class ArthanaItem
extends SwordItem {
    public ArthanaItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super((Tier)Tiers.GOLD, properties);
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)attacker, (String)"attacker");
        if (target instanceof Chicken && attacker instanceof Player) {
            target.hurt(attacker.damageSources().playerAttack((Player)attacker), 4.0f);
        }
        if (target.isDeadOrDying() && target.getType().is(EntityTypeTags.UNDEAD) && attacker instanceof Player && attacker.level().random.nextFloat() < 0.15f) {
            ItemStack spectralDust = new ItemStack((ItemLike)WitcheryItems.INSTANCE.getSPECTRAL_DUST().get());
            target.spawnAtLocation(spectralDust);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        BlockState state = level.getBlockState(pos);
        if ((state.is((Block)WitcheryBlocks.INSTANCE.getALTAR().get()) || state.is((Block)WitcheryBlocks.INSTANCE.getALTAR_COMPONENT().get())) && face == Direction.UP) {
            if (!level.isClientSide) {
                BlockState newState = ((ArthanaBlock)((Object)WitcheryBlocks.INSTANCE.getARTHANA().get())).defaultBlockState();
                level.setBlockAndUpdate(pos.above(), newState);
                BlockPos blockPos = pos.above();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"above(...)");
                Intrinsics.checkNotNull((Object)newState);
                ArthanaBlockEntity be = new ArthanaBlockEntity(blockPos, newState);
                ItemStack itemStack = context.getItemInHand().copy();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
                be.setArthana(itemStack);
                context.getItemInHand().shrink(1);
                level.setBlockEntity((BlockEntity)be);
            }
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = super.useOn(context);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
        return interactionResult;
    }
}

