/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import dev.sterner.witchery.content.block.mirror.MirrorBlock;
import dev.sterner.witchery.content.block.mirror.MirrorBlockEntity;
import dev.sterner.witchery.core.api.multiblock.MultiBlockItem;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import java.awt.Color;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J.\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001b"}, d2={"Ldev/sterner/witchery/content/item/MirrorItem;", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockItem;", "block", "Lnet/minecraft/world/level/block/Block;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/level/block/Block;Lnet/minecraft/world/item/Item$Properties;)V", "canPlace", "", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "canSuperPlace", "placeBlock", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "witchery"})
public final class MirrorItem
extends MultiBlockItem {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public MirrorItem(@NotNull Block block, @NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(block, properties, MirrorBlock.Companion.getSTRUCTURE());
    }

    @Override
    protected boolean canPlace(@NotNull BlockPlaceContext context, @NotNull BlockState state) {
        boolean isShiftClick;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Player player = context.getPlayer();
        boolean bl = isShiftClick = player != null ? player.isShiftKeyDown() : false;
        if (isShiftClick) {
            return this.canSuperPlace(context, state);
        }
        return super.canPlace(context, state);
    }

    private final boolean canSuperPlace(BlockPlaceContext context, BlockState state) {
        Player player;
        Player player2 = player = context.getPlayer();
        CollisionContext collisionContext = player2 == null ? CollisionContext.empty() : CollisionContext.of((Entity)((Entity)player2));
        return (!this.mustSurvive() || state.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) && context.getLevel().isUnobstructed(state, context.getClickedPos(), collisionContext);
    }

    @Override
    protected boolean placeBlock(@NotNull BlockPlaceContext context, @NotNull BlockState state) {
        boolean success;
        block6: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Player player = context.getPlayer();
            boolean isShiftClick = player != null ? player.isShiftKeyDown() : false;
            ItemStack stack = context.getItemInHand();
            if (isShiftClick) {
                boolean v = context.getLevel().setBlock(context.getClickedPos(), state, 3);
                BlockEntity be = context.getLevel().getBlockEntity(context.getClickedPos());
                if (be != null && be instanceof MirrorBlockEntity) {
                    ((MirrorBlockEntity)be).setSmallMirror(true);
                    ((MirrorBlockEntity)be).setChanged();
                }
                v1 = v;
            } else {
                v1 = success = super.placeBlock(context, state);
            }
            if (!success) break block6;
            Intrinsics.checkNotNull((Object)stack);
            UUID pairId = Companion.getPairId(stack);
            if (pairId != null) {
                MirrorBlockEntity entity;
                BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
                MirrorBlockEntity mirrorBlockEntity = entity = blockEntity instanceof MirrorBlockEntity ? (MirrorBlockEntity)blockEntity : null;
                if (mirrorBlockEntity != null) {
                    mirrorBlockEntity.putPairId(pairId);
                }
                Player player2 = context.getPlayer();
                if (player2 != null) {
                    player2.displayClientMessage((Component)Component.literal((String)"Mirror linked to its pair!"), true);
                }
            }
        }
        return success;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        MutableComponent mutableComponent = Component.literal((String)"NOT YET COMPLETELY IMPLEMENTED").withColor(Color.RED.getRGB());
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withColor(...)");
        tooltipComponents.add((Component)mutableComponent);
        UUID pairId = Companion.getPairId(stack);
        if (pairId != null) {
            MutableComponent mutableComponent2 = Component.literal((String)"Paired Mirror").withColor(0xAA00FF);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"withColor(...)");
            tooltipComponents.add((Component)mutableComponent2);
            MutableComponent mutableComponent3 = Component.literal((String)"Pair ID: ").withColor(0xFFAA00);
            String string = pairId.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string;
            int n = 0;
            int n2 = 8;
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            MutableComponent mutableComponent4 = mutableComponent3.append((Component)Component.literal((String)(string3 + "...")).withColor(0x55FFFF));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"append(...)");
            v6 = tooltipComponents.add((Component)mutableComponent4);
        } else {
            MutableComponent mutableComponent5 = Component.literal((String)"Unpaired Mirror").withColor(0xFF5555);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent5, (String)"withColor(...)");
            v6 = tooltipComponents.add((Component)mutableComponent5);
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005\u00a8\u0006\u000b"}, d2={"Ldev/sterner/witchery/content/item/MirrorItem$Companion;", "", "<init>", "()V", "getPairId", "Ljava/util/UUID;", "stack", "Lnet/minecraft/world/item/ItemStack;", "setPairId", "", "pairId", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final UUID getPairId(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return (UUID)stack.get((DataComponentType)WitcheryDataComponents.INSTANCE.getMIRROR_PAIR_ID().get());
        }

        public final void setPairId(@NotNull ItemStack stack, @NotNull UUID pairId) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)pairId, (String)"pairId");
            stack.set((DataComponentType)WitcheryDataComponents.INSTANCE.getMIRROR_PAIR_ID().get(), (Object)pairId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

