/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item;

import dev.sterner.witchery.content.block.WormwoodCropBlock;
import dev.sterner.witchery.content.block.critter_snare.CritterSnareBlock;
import dev.sterner.witchery.content.block.grassper.GrassperBlock;
import dev.sterner.witchery.content.block.grassper.GrassperBlockEntity;
import dev.sterner.witchery.content.block.soul_cage.SoulCageBlockEntity;
import dev.sterner.witchery.content.entity.OwlEntity;
import dev.sterner.witchery.content.entity.ParasiticLouseEntity;
import dev.sterner.witchery.content.item.AttunedStoneItem;
import dev.sterner.witchery.content.item.MutandisItem;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.features.necromancy.EtherealEntityAttachment;
import dev.sterner.witchery.integration.CompatHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVinesPlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006 "}, d2={"Ldev/sterner/witchery/content/item/MutatingSpringItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "makeFromSnare", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "makeWormwood", "makeGrassper", "makeLifeBlood", "spawnLifebloodTransformationParticles", "Lnet/minecraft/server/level/ServerLevel;", "makeCritterSnare", "checkCardinal", "", "block", "Lnet/minecraft/world/level/block/Block;", "checkWaterDiagonals", "isWaterloggedOrWater", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "removeDiagonals", "removeCardinal", "witchery"})
@SourceDebugExtension(value={"SMAP\nMutatingSpringItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutatingSpringItem.kt\ndev/sterner/witchery/content/item/MutatingSpringItem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,572:1\n1788#2,4:573\n1788#2,4:577\n1788#2,4:581\n1869#2,2:585\n1869#2,2:587\n1869#2,2:589\n1869#2,2:591\n1788#2,4:593\n1788#2,4:597\n1869#2,2:601\n1869#2,2:603\n1869#2,2:605\n*S KotlinDebug\n*F\n+ 1 MutatingSpringItem.kt\ndev/sterner/witchery/content/item/MutatingSpringItem\n*L\n102#1:573,4\n104#1:577,4\n105#1:581,4\n256#1:585,2\n330#1:587,2\n352#1:589,2\n375#1:591,2\n421#1:593,4\n423#1:597,4\n494#1:601,2\n530#1:603,2\n557#1:605,2\n*E\n"})
public final class MutatingSpringItem
extends Item {
    public MutatingSpringItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (level.getBlockState(pos).is(Blocks.WHEAT)) {
            Intrinsics.checkNotNull((Object)level);
            Intrinsics.checkNotNull((Object)pos);
            this.makeWormwood(level, pos);
            return InteractionResult.SUCCESS;
        }
        if (level.getBlockState(pos).is(Blocks.CHEST)) {
            Intrinsics.checkNotNull((Object)level);
            Intrinsics.checkNotNull((Object)pos);
            this.makeGrassper(level, pos);
            return InteractionResult.SUCCESS;
        }
        if (level.getBlockState(pos).is(Blocks.COBWEB)) {
            Intrinsics.checkNotNull((Object)level);
            Intrinsics.checkNotNull((Object)pos);
            this.makeCritterSnare(level, pos);
            this.makeLifeBlood(level, pos);
            return InteractionResult.SUCCESS;
        }
        if (level.getBlockState(pos).is((Block)WitcheryBlocks.INSTANCE.getCRITTER_SNARE().get())) {
            Intrinsics.checkNotNull((Object)level);
            Intrinsics.checkNotNull((Object)pos);
            this.makeFromSnare(level, pos);
            return InteractionResult.SUCCESS;
        }
        BlockState blockState = level.getBlockState(pos);
        if (blockState.is(Blocks.GRASS_BLOCK)) {
            level.setBlockAndUpdate(pos, Blocks.MYCELIUM.defaultBlockState());
            return InteractionResult.SUCCESS;
        }
        if (blockState.is(Blocks.DIRT)) {
            level.setBlockAndUpdate(pos, Blocks.CLAY.defaultBlockState());
            return InteractionResult.SUCCESS;
        }
        if (blockState.is(Blocks.CLAY)) {
            level.setBlockAndUpdate(pos, Blocks.DIRT.defaultBlockState());
            return InteractionResult.SUCCESS;
        }
        if (blockState.is(Blocks.MYCELIUM)) {
            level.setBlockAndUpdate(pos, Blocks.GRASS_BLOCK.defaultBlockState());
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = super.useOn(context);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
        return interactionResult;
    }

    private final void makeFromSnare(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof CritterSnareBlock && state.hasProperty((Property)CritterSnareBlock.Companion.getCAPTURED_STATE()) && state.getValue((Property)CritterSnareBlock.Companion.getCAPTURED_STATE()) == CritterSnareBlock.CapturedEntity.SILVERFISH) {
            Block block = Blocks.LILY_PAD;
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"LILY_PAD");
            boolean bl = this.checkCardinal(level, pos, block);
            BlockPos blockPos = pos.below();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"below(...)");
            Block block2 = Blocks.WATER;
            Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"WATER");
            boolean bl2 = this.checkCardinal(level, blockPos, block2);
            BlockEntity grassperNW = level.getBlockEntity(pos.north().west());
            BlockEntity grassperNE = level.getBlockEntity(pos.north().east());
            BlockEntity grassperSW = level.getBlockEntity(pos.south().west());
            BlockEntity grassperSE = level.getBlockEntity(pos.south().east());
            if (grassperNW instanceof GrassperBlockEntity && grassperNE instanceof GrassperBlockEntity && grassperSW instanceof GrassperBlockEntity && grassperSE instanceof GrassperBlockEntity) {
                int tongueOfDogCount;
                int n;
                int n2;
                Object[] objectArray = new ItemStack[]{((GrassperBlockEntity)grassperNW).getItem(0), ((GrassperBlockEntity)grassperNE).getItem(0), ((GrassperBlockEntity)grassperSW).getItem(0), ((GrassperBlockEntity)grassperSE).getItem(0)};
                List items = CollectionsKt.listOf((Object[])objectArray);
                MutandisItem mutandis = (MutandisItem)((Object)WitcheryItems.INSTANCE.getMUTANDIS().get());
                AttunedStoneItem attunedStone = (AttunedStoneItem)((Object)WitcheryItems.INSTANCE.getATTUNED_STONE().get());
                Item tongueOfDog = (Item)WitcheryItems.INSTANCE.getTONGUE_OF_DOG().get();
                Iterable $this$count$iv = items;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n2 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        ItemStack it = (ItemStack)element$iv;
                        boolean bl3 = false;
                        if (!it.is((Item)mutandis) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n2 = count$iv;
                }
                int mutandisCount = n2;
                Iterable $this$count$iv2 = items;
                boolean $i$f$count2 = false;
                if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv2) {
                        ItemStack it = (ItemStack)element$iv;
                        boolean bl4 = false;
                        if (!(it.is((Item)attunedStone) && Intrinsics.areEqual((Object)it.get((DataComponentType)WitcheryDataComponents.INSTANCE.getATTUNED().get()), (Object)true)) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                int attunedStoneCount = n;
                Iterable $this$count$iv3 = items;
                boolean $i$f$count3 = false;
                if ($this$count$iv3 instanceof Collection && ((Collection)$this$count$iv3).isEmpty()) {
                    v5 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv3) {
                        ItemStack it = (ItemStack)element$iv;
                        boolean bl5 = false;
                        if (!it.is(tongueOfDog) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    v5 = tongueOfDogCount = count$iv;
                }
                if (bl && bl2 && mutandisCount >= 2 && attunedStoneCount >= 1 && tongueOfDogCount >= 1) {
                    ParasiticLouseEntity louse;
                    int mutandisLeft = 2;
                    int attunedStoneLeft = 1;
                    int tongueOfDogLeft = 1;
                    for (ItemStack itemStack : items) {
                        int toConsume;
                        Item it = itemStack.getItem();
                        if (Intrinsics.areEqual((Object)it, (Object)((Object)mutandis))) {
                            toConsume = Math.min(mutandisLeft, itemStack.getCount());
                            itemStack.shrink(toConsume);
                            mutandisLeft -= toConsume;
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)it, (Object)((Object)attunedStone))) {
                            toConsume = Math.min(attunedStoneLeft, itemStack.getCount());
                            itemStack.shrink(toConsume);
                            attunedStoneLeft -= toConsume;
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)it, (Object)tongueOfDog)) continue;
                        toConsume = Math.min(tongueOfDogLeft, itemStack.getCount());
                        itemStack.shrink(toConsume);
                        tongueOfDogLeft -= toConsume;
                    }
                    ParasiticLouseEntity parasiticLouseEntity = louse = (ParasiticLouseEntity)((EntityType)WitcheryEntityTypes.INSTANCE.getPARASITIC_LOUSE().get()).create(level);
                    if (parasiticLouseEntity != null) {
                        ParasiticLouseEntity it = parasiticLouseEntity;
                        boolean bl6 = false;
                        it.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0f, 0.0f);
                        level.addFreshEntity((Entity)it);
                    }
                    this.removeCardinal(level, pos);
                    BlockPos blockPos2 = pos.below();
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"below(...)");
                    this.removeCardinal(level, blockPos2);
                    level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                }
            }
        }
    }

    private final void makeWormwood(Level level, BlockPos pos) {
        Object object = WitcheryBlocks.INSTANCE.getWISPY_COTTON().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (this.checkCardinal(level, pos, (Block)object) && this.checkWaterDiagonals(level, pos)) {
            level.setBlockAndUpdate(pos, ((WormwoodCropBlock)((Object)WitcheryBlocks.INSTANCE.getWORMWOOD_CROP().get())).defaultBlockState());
            this.removeCardinal(level, pos);
            this.removeDiagonals(level, pos);
            level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS);
        }
    }

    private final void makeGrassper(Level level, BlockPos pos) {
        Block block = Blocks.SHORT_GRASS;
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"SHORT_GRASS");
        if (this.checkCardinal(level, pos, block) && level.getBlockState(pos.below()).is(Blocks.WATER)) {
            this.removeCardinal(level, pos);
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            level.setBlockAndUpdate(pos.below(), Blocks.AIR.defaultBlockState());
            level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS);
            level.setBlockAndUpdate(pos.south(), ((GrassperBlock)((Object)WitcheryBlocks.INSTANCE.getGRASSPER().get())).defaultBlockState());
            level.setBlockAndUpdate(pos.north(), ((GrassperBlock)((Object)WitcheryBlocks.INSTANCE.getGRASSPER().get())).defaultBlockState());
            level.setBlockAndUpdate(pos.west(), ((GrassperBlock)((Object)WitcheryBlocks.INSTANCE.getGRASSPER().get())).defaultBlockState());
            level.setBlockAndUpdate(pos.east(), ((GrassperBlock)((Object)WitcheryBlocks.INSTANCE.getGRASSPER().get())).defaultBlockState());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void makeLifeBlood(Level level, BlockPos pos) {
        boolean hasChorusPlants;
        boolean hasCaveVines;
        Object object;
        BlockPos foundSoulCage;
        List hasZombieVill;
        List hasGuard;
        List hasVillager;
        block12: {
            BlockPos blockPos;
            hasVillager = level.getEntities((EntityTypeTest)EntityType.VILLAGER, AABB.ofSize((Vec3)pos.getCenter(), (double)1.0, (double)1.0, (double)1.0), arg_0 -> MutatingSpringItem.makeLifeBlood$lambda$1(MutatingSpringItem::makeLifeBlood$lambda$0, arg_0));
            hasGuard = CompatHelper.INSTANCE.isLoaded() ? level.getEntities((EntityTypeTest)CompatHelper.INSTANCE.getGuard(), AABB.ofSize((Vec3)pos.getCenter(), (double)1.0, (double)1.0, (double)1.0), arg_0 -> MutatingSpringItem.makeLifeBlood$lambda$3(MutatingSpringItem::makeLifeBlood$lambda$2, arg_0)) : CollectionsKt.emptyList();
            hasZombieVill = level.getEntities((EntityTypeTest)EntityType.ZOMBIE_VILLAGER, AABB.ofSize((Vec3)pos.getCenter(), (double)1.0, (double)1.0, (double)1.0), arg_0 -> MutatingSpringItem.makeLifeBlood$lambda$5(MutatingSpringItem::makeLifeBlood$lambda$4, arg_0));
            List list = BlockPos.betweenClosedStream((AABB)AABB.ofSize((Vec3)pos.getCenter(), (double)3.0, (double)3.0, (double)3.0)).toList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
            for (BlockPos blockPos2 : (Iterable)list) {
                boolean bl = false;
                BlockEntity blockEntity = level.getBlockEntity(blockPos2);
                if ((blockPos2 = blockEntity instanceof SoulCageBlockEntity && ((SoulCageBlockEntity)blockEntity).getHasSoul() ? (SoulCageBlockEntity)blockEntity : null) == null) continue;
                blockPos = blockPos2;
                break block12;
            }
            blockPos = foundSoulCage = null;
        }
        if (hasVillager.isEmpty() && hasGuard.isEmpty() && hasZombieVill.isEmpty() && foundSoulCage == null) {
            return;
        }
        Intrinsics.checkNotNull((Object)hasVillager);
        if (!((Collection)hasVillager).isEmpty()) {
            object = (Entity)hasVillager.get(0);
        } else {
            Intrinsics.checkNotNull((Object)hasZombieVill);
            if (!((Collection)hasZombieVill).isEmpty()) {
                object = (Entity)hasZombieVill.get(0);
            } else {
                Intrinsics.checkNotNull((Object)hasGuard);
                object = !((Collection)hasGuard).isEmpty() ? (Entity)hasGuard.get(0) : null;
            }
        }
        Entity soulEntity = object;
        BlockPos ne = pos.north().east().below();
        BlockPos nw = pos.north().west().below();
        BlockPos se = pos.south().east().below();
        BlockPos sw = pos.south().west().below();
        boolean bl = hasCaveVines = !(!level.getBlockState(ne).is(Blocks.CAVE_VINES) && !level.getBlockState(ne).is(Blocks.CAVE_VINES_PLANT) || !level.getBlockState(nw).is(Blocks.CAVE_VINES) && !level.getBlockState(nw).is(Blocks.CAVE_VINES_PLANT) || !level.getBlockState(se).is(Blocks.CAVE_VINES) && !level.getBlockState(se).is(Blocks.CAVE_VINES_PLANT) || !level.getBlockState(sw).is(Blocks.CAVE_VINES) && !level.getBlockState(sw).is(Blocks.CAVE_VINES_PLANT));
        if (!hasCaveVines) {
            return;
        }
        BlockPos nea = pos.north().east().above();
        BlockPos nwa = pos.north().west().above();
        BlockPos sea = pos.south().east().above();
        BlockPos swa = pos.south().west().above();
        boolean bl2 = hasChorusPlants = !(!level.getBlockState(nea).is(Blocks.CHORUS_PLANT) && !level.getBlockState(nea).is(Blocks.CHORUS_FLOWER) || !level.getBlockState(nwa).is(Blocks.CHORUS_PLANT) && !level.getBlockState(nea).is(Blocks.CHORUS_FLOWER) || !level.getBlockState(sea).is(Blocks.CHORUS_PLANT) && !level.getBlockState(nea).is(Blocks.CHORUS_FLOWER) || !level.getBlockState(swa).is(Blocks.CHORUS_PLANT) && !level.getBlockState(nea).is(Blocks.CHORUS_FLOWER));
        if (!hasChorusPlants) {
            return;
        }
        if (level instanceof ServerLevel) {
            void $this$forEach$iv;
            Entity entity = soulEntity;
            if (entity != null) {
                entity.discard();
            }
            BlockPos blockPos = foundSoulCage;
            if (blockPos != null) {
                blockPos.extractSoul();
            }
            Object object2 = new BlockPos[]{pos.north().east().below(), pos.north().west().below(), pos.south().east().below(), pos.south().west().below()};
            object2 = CollectionsKt.listOf((Object[])object2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BlockPos vinePos = (BlockPos)element$iv;
                boolean bl3 = false;
                level.setBlockAndUpdate(vinePos, (BlockState)((Block)WitcheryBlocks.INSTANCE.getLIFE_BLOOD().get()).defaultBlockState().setValue((Property)CaveVinesPlantBlock.BERRIES, (Comparable)Boolean.valueOf(true)));
            }
            level.setBlockAndUpdate(pos.north().east().above(), Blocks.AIR.defaultBlockState());
            level.setBlockAndUpdate(pos.north().west().above(), Blocks.AIR.defaultBlockState());
            level.setBlockAndUpdate(pos.south().east().above(), Blocks.AIR.defaultBlockState());
            level.setBlockAndUpdate(pos.south().west().above(), Blocks.AIR.defaultBlockState());
            this.spawnLifebloodTransformationParticles((ServerLevel)level, pos);
            ((ServerLevel)level).playSound(null, pos, SoundEvents.END_PORTAL_SPAWN, SoundSource.BLOCKS, 1.0f, 0.8f);
            ((ServerLevel)level).playSound(null, pos, (SoundEvent)SoundEvents.SOUL_ESCAPE.value(), SoundSource.BLOCKS, 1.5f, 1.2f);
        }
    }

    private final void spawnLifebloodTransformationParticles(ServerLevel level, BlockPos pos) {
        Object $this$forEach$iv;
        double radius;
        double angle;
        int i;
        Vec3 center = pos.getCenter();
        for (i = 0; i < 51; ++i) {
            angle = (double)i / 50.0 * Math.PI * (double)2;
            radius = (double)i / 25.0;
            double x = center.x + Math.cos(angle) * radius;
            double z = center.z + Math.sin(angle) * radius;
            level.sendParticles((ParticleOptions)ParticleTypes.SOUL, x, center.y + 0.5, z, 2, 0.0, 0.1, 0.0, 0.05);
        }
        for (i = 0; i < 61; ++i) {
            angle = (double)i / 60.0 * Math.PI * (double)6;
            radius = 0.5 + (double)i / 60.0 * 2.0;
            double height = (double)i / 60.0 * 3.0;
            double x = center.x + Math.cos(angle) * radius;
            double z = center.z + Math.sin(angle) * radius;
            double y = center.y + height;
            level.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        Object i2 = new BlockPos[]{pos.north().east(), pos.north().west(), pos.south().east(), pos.south().west()};
        i2 = CollectionsKt.listOf((Object[])i2);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            BlockPos chorusPos = (BlockPos)element$iv;
            boolean bl = false;
            Vec3 chorusCenter = chorusPos.getCenter();
            for (int i3 = 0; i3 < 21; ++i3) {
                level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, chorusCenter.x, chorusCenter.y, chorusCenter.z, 1, Mth.nextDouble((RandomSource)level.random, (double)-0.3, (double)0.3), Mth.nextDouble((RandomSource)level.random, (double)0.1, (double)0.5), Mth.nextDouble((RandomSource)level.random, (double)-0.3, (double)0.3), 0.2);
            }
        }
        $this$forEach$iv = new BlockPos[]{pos.north(), pos.south(), pos.east(), pos.west()};
        $this$forEach$iv = CollectionsKt.listOf((Object[])$this$forEach$iv);
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            BlockPos vinePos = (BlockPos)element$iv;
            boolean bl = false;
            Vec3 vineCenter = vinePos.getCenter();
            for (int i4 = 0; i4 < 16; ++i4) {
                level.sendParticles((ParticleOptions)ParticleTypes.FALLING_NECTAR, vineCenter.x, vineCenter.y + (double)i4 * 0.1, vineCenter.z, 1, 0.0, -0.1, 0.0, 0.0);
            }
        }
    }

    private final void makeCritterSnare(Level level, BlockPos pos) {
        List hasZombie = level.getEntities((EntityTypeTest)EntityType.ZOMBIE, AABB.ofSize((Vec3)pos.getCenter(), (double)1.0, (double)1.0, (double)1.0), arg_0 -> MutatingSpringItem.makeCritterSnare$lambda$1(MutatingSpringItem::makeCritterSnare$lambda$0, arg_0));
        List hasWolf = level.getEntities((EntityTypeTest)EntityType.WOLF, AABB.ofSize((Vec3)pos.getCenter(), (double)1.0, (double)1.0, (double)1.0), arg_0 -> MutatingSpringItem.makeCritterSnare$lambda$3(MutatingSpringItem::makeCritterSnare$lambda$2, arg_0));
        Intrinsics.checkNotNull((Object)hasZombie);
        if (!((Collection)hasZombie).isEmpty()) {
            Object object = WitcheryBlocks.INSTANCE.getALDER_SAPLING().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            if (this.checkCardinal(level, pos, (Block)object) && level.getBlockState(pos.below()).is(Blocks.WATER)) {
                this.removeCardinal(level, pos);
                Iterable $this$forEach$iv = hasZombie;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Zombie it = (Zombie)element$iv;
                    boolean bl = false;
                    it.discard();
                }
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                level.setBlockAndUpdate(pos.below(), Blocks.AIR.defaultBlockState());
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS);
                level.setBlockAndUpdate(pos.south(), ((CritterSnareBlock)((Object)WitcheryBlocks.INSTANCE.getCRITTER_SNARE().get())).defaultBlockState());
                level.setBlockAndUpdate(pos.north(), ((CritterSnareBlock)((Object)WitcheryBlocks.INSTANCE.getCRITTER_SNARE().get())).defaultBlockState());
                level.setBlockAndUpdate(pos.west(), ((CritterSnareBlock)((Object)WitcheryBlocks.INSTANCE.getCRITTER_SNARE().get())).defaultBlockState());
                level.setBlockAndUpdate(pos.east(), ((CritterSnareBlock)((Object)WitcheryBlocks.INSTANCE.getCRITTER_SNARE().get())).defaultBlockState());
            }
        }
        Intrinsics.checkNotNull((Object)hasWolf);
        if (!((Collection)hasWolf).isEmpty() && level.getBlockState(pos.below()).is(Blocks.WATER)) {
            boolean batW;
            boolean batN = level.getBlockState(pos.north()).is((Block)WitcheryBlocks.INSTANCE.getCRITTER_SNARE().get()) && level.getBlockState(pos.north()).hasProperty((Property)CritterSnareBlock.Companion.getCAPTURED_STATE()) && level.getBlockState(pos.north()).getValue((Property)CritterSnareBlock.Companion.getCAPTURED_STATE()) == CritterSnareBlock.CapturedEntity.BAT;
            boolean batS = level.getBlockState(pos.south()).is((Block)WitcheryBlocks.INSTANCE.getCRITTER_SNARE().get()) && level.getBlockState(pos.south()).hasProperty((Property)CritterSnareBlock.Companion.getCAPTURED_STATE()) && level.getBlockState(pos.south()).getValue((Property)CritterSnareBlock.Companion.getCAPTURED_STATE()) == CritterSnareBlock.CapturedEntity.BAT;
            boolean batE = level.getBlockState(pos.east()).is((Block)WitcheryBlocks.INSTANCE.getCRITTER_SNARE().get()) && level.getBlockState(pos.east()).hasProperty((Property)CritterSnareBlock.Companion.getCAPTURED_STATE()) && level.getBlockState(pos.east()).getValue((Property)CritterSnareBlock.Companion.getCAPTURED_STATE()) == CritterSnareBlock.CapturedEntity.BAT;
            boolean bl = batW = level.getBlockState(pos.west()).is((Block)WitcheryBlocks.INSTANCE.getCRITTER_SNARE().get()) && level.getBlockState(pos.west()).hasProperty((Property)CritterSnareBlock.Companion.getCAPTURED_STATE()) && level.getBlockState(pos.west()).getValue((Property)CritterSnareBlock.Companion.getCAPTURED_STATE()) == CritterSnareBlock.CapturedEntity.BAT;
            if (batN || batS || batW || batE) {
                BlockEntity grassperNW = level.getBlockEntity(pos.north().west());
                BlockEntity grassperNE = level.getBlockEntity(pos.north().east());
                BlockEntity grassperSW = level.getBlockEntity(pos.south().west());
                BlockEntity grassperSE = level.getBlockEntity(pos.south().east());
                if (grassperNW instanceof GrassperBlockEntity && grassperNE instanceof GrassperBlockEntity && grassperSW instanceof GrassperBlockEntity && grassperSE instanceof GrassperBlockEntity) {
                    int attunedStoneCount;
                    int n;
                    Object[] objectArray = new ItemStack[]{((GrassperBlockEntity)grassperNW).getItem(0), ((GrassperBlockEntity)grassperNE).getItem(0), ((GrassperBlockEntity)grassperSW).getItem(0), ((GrassperBlockEntity)grassperSE).getItem(0)};
                    List items = CollectionsKt.listOf((Object[])objectArray);
                    MutandisItem mutandis = (MutandisItem)((Object)WitcheryItems.INSTANCE.getMUTANDIS_EXTREMIS().get());
                    AttunedStoneItem attunedStone = (AttunedStoneItem)((Object)WitcheryItems.INSTANCE.getATTUNED_STONE().get());
                    Iterable $this$count$iv = items;
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv : $this$count$iv) {
                            ItemStack it = (ItemStack)element$iv;
                            boolean bl2 = false;
                            if (!it.is((Item)mutandis) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count$iv;
                    }
                    int mutandisCount = n;
                    Iterable $this$count$iv2 = items;
                    boolean $i$f$count2 = false;
                    if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                        v3 = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv : $this$count$iv2) {
                            ItemStack it = (ItemStack)element$iv;
                            boolean bl3 = false;
                            if (!(it.is((Item)attunedStone) && Intrinsics.areEqual((Object)it.get((DataComponentType)WitcheryDataComponents.INSTANCE.getATTUNED().get()), (Object)true)) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        v3 = attunedStoneCount = count$iv;
                    }
                    if (mutandisCount >= 3 && attunedStoneCount >= 1) {
                        BlockPos no;
                        OwlEntity owl;
                        int mutandisLeft = 3;
                        int attunedStoneLeft = 1;
                        for (ItemStack itemStack : items) {
                            int toConsume;
                            Item item = itemStack.getItem();
                            if (Intrinsics.areEqual((Object)item, (Object)((Object)mutandis))) {
                                toConsume = Math.min(mutandisLeft, itemStack.getCount());
                                itemStack.shrink(toConsume);
                                mutandisLeft -= toConsume;
                                continue;
                            }
                            if (!Intrinsics.areEqual((Object)item, (Object)((Object)attunedStone))) continue;
                            toConsume = Math.min(attunedStoneLeft, itemStack.getCount());
                            itemStack.shrink(toConsume);
                            attunedStoneLeft -= toConsume;
                        }
                        if (batN) {
                            owl = (OwlEntity)((EntityType)WitcheryEntityTypes.INSTANCE.getOWL().get()).create(level);
                            no = pos.north();
                            OwlEntity owlEntity = owl;
                            if (owlEntity != null) {
                                OwlEntity it = owlEntity;
                                boolean bl4 = false;
                                it.moveTo((double)no.getX() + 0.5, (double)no.getY() + 0.5, (double)no.getZ() + 0.5, 0.0f, 0.0f);
                                level.addFreshEntity((Entity)it);
                            }
                            level.setBlockAndUpdate(pos.north(), ((CritterSnareBlock)((Object)WitcheryBlocks.INSTANCE.getCRITTER_SNARE().get())).defaultBlockState());
                        }
                        if (batS) {
                            owl = (OwlEntity)((EntityType)WitcheryEntityTypes.INSTANCE.getOWL().get()).create(level);
                            no = pos.south();
                            OwlEntity owlEntity = owl;
                            if (owlEntity != null) {
                                OwlEntity it = owlEntity;
                                boolean bl5 = false;
                                it.moveTo((double)no.getX() + 0.5, (double)no.getY() + 0.5, (double)no.getZ() + 0.5, 0.0f, 0.0f);
                                level.addFreshEntity((Entity)it);
                            }
                            level.setBlockAndUpdate(pos.south(), ((CritterSnareBlock)((Object)WitcheryBlocks.INSTANCE.getCRITTER_SNARE().get())).defaultBlockState());
                        }
                        if (batE) {
                            owl = (OwlEntity)((EntityType)WitcheryEntityTypes.INSTANCE.getOWL().get()).create(level);
                            no = pos.east();
                            OwlEntity owlEntity = owl;
                            if (owlEntity != null) {
                                OwlEntity it = owlEntity;
                                boolean bl6 = false;
                                it.moveTo((double)no.getX() + 0.5, (double)no.getY() + 0.5, (double)no.getZ() + 0.5, 0.0f, 0.0f);
                                level.addFreshEntity((Entity)it);
                            }
                            level.setBlockAndUpdate(pos.east(), ((CritterSnareBlock)((Object)WitcheryBlocks.INSTANCE.getCRITTER_SNARE().get())).defaultBlockState());
                        }
                        if (batW) {
                            owl = (OwlEntity)((EntityType)WitcheryEntityTypes.INSTANCE.getOWL().get()).create(level);
                            no = pos.west();
                            OwlEntity owlEntity = owl;
                            if (owlEntity != null) {
                                OwlEntity it = owlEntity;
                                boolean bl7 = false;
                                it.moveTo((double)no.getX() + 0.5, (double)no.getY() + 0.5, (double)no.getZ() + 0.5, 0.0f, 0.0f);
                                level.addFreshEntity((Entity)it);
                            }
                            level.setBlockAndUpdate(pos.west(), ((CritterSnareBlock)((Object)WitcheryBlocks.INSTANCE.getCRITTER_SNARE().get())).defaultBlockState());
                        }
                        Iterable $this$forEach$iv = hasWolf;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Wolf it = (Wolf)element$iv;
                            boolean bl8 = false;
                            it.discard();
                        }
                        level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                        level.setBlockAndUpdate(pos.below(), Blocks.AIR.defaultBlockState());
                    }
                }
            }
        }
    }

    private final boolean checkCardinal(Level level, BlockPos pos, Block block) {
        return level.getBlockState(pos.north()).is(block) && level.getBlockState(pos.south()).is(block) && level.getBlockState(pos.east()).is(block) && level.getBlockState(pos.west()).is(block);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkWaterDiagonals(Level level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos.north().east().below());
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        if (!this.isWaterloggedOrWater(blockState)) return false;
        BlockState blockState2 = level.getBlockState(pos.north().west().below());
        Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"getBlockState(...)");
        if (!this.isWaterloggedOrWater(blockState2)) return false;
        BlockState blockState3 = level.getBlockState(pos.south().east().below());
        Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"getBlockState(...)");
        if (!this.isWaterloggedOrWater(blockState3)) return false;
        BlockState blockState4 = level.getBlockState(pos.south().west().below());
        Intrinsics.checkNotNullExpressionValue((Object)blockState4, (String)"getBlockState(...)");
        if (!this.isWaterloggedOrWater(blockState4)) return false;
        return true;
    }

    private final boolean isWaterloggedOrWater(BlockState state) {
        return state.is(Blocks.WATER) || state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false;
    }

    private final void removeDiagonals(Level level, BlockPos pos) {
        Object[] objectArray = new BlockPos[]{pos.north().east().below(), pos.north().west().below(), pos.south().east().below(), pos.south().west().below()};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockPos diagonalPos = (BlockPos)element$iv;
            boolean bl = false;
            BlockState state = level.getBlockState(diagonalPos);
            if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                level.setBlockAndUpdate(diagonalPos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
            } else if (state.is(Blocks.WATER)) {
                level.setBlockAndUpdate(diagonalPos, Blocks.AIR.defaultBlockState());
            }
            Vec3 center = diagonalPos.getCenter();
            for (int i = 0; i < 17; ++i) {
                level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SMOKE, true, center.x + 0.0 + Mth.nextDouble((RandomSource)level.random, (double)-0.5, (double)0.5), center.y + 0.0 + Mth.nextDouble((RandomSource)level.random, (double)-1.25, (double)1.25), center.z + 0.0 + Mth.nextDouble((RandomSource)level.random, (double)-0.5, (double)0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    private final void removeCardinal(Level level, BlockPos pos) {
        Object[] objectArray = new BlockPos[]{pos.east(), pos.north(), pos.south(), pos.west()};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockPos cardinal = (BlockPos)element$iv;
            boolean bl = false;
            level.setBlockAndUpdate(cardinal, Blocks.AIR.defaultBlockState());
            Vec3 center = cardinal.getCenter();
            for (int i = 0; i < 17; ++i) {
                level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SMOKE, true, center.x + Mth.nextDouble((RandomSource)level.random, (double)-0.5, (double)0.5), center.y + Mth.nextDouble((RandomSource)level.random, (double)-1.25, (double)1.25), center.z + Mth.nextDouble((RandomSource)level.random, (double)-0.5, (double)0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    private static final boolean makeLifeBlood$lambda$0(Villager it) {
        Intrinsics.checkNotNull((Object)it);
        return EtherealEntityAttachment.getData((LivingEntity)it).isEthereal();
    }

    private static final boolean makeLifeBlood$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean makeLifeBlood$lambda$2(Entity it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
        return EtherealEntityAttachment.getData((LivingEntity)it).isEthereal();
    }

    private static final boolean makeLifeBlood$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean makeLifeBlood$lambda$4(ZombieVillager it) {
        Intrinsics.checkNotNull((Object)it);
        return EtherealEntityAttachment.getData((LivingEntity)it).isEthereal();
    }

    private static final boolean makeLifeBlood$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean makeCritterSnare$lambda$0(Zombie it) {
        return true;
    }

    private static final boolean makeCritterSnare$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean makeCritterSnare$lambda$2(Wolf it) {
        return true;
    }

    private static final boolean makeCritterSnare$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

