/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.item.brew;

import dev.sterner.witchery.content.item.brew.ThrowableBrewItem;
import dev.sterner.witchery.core.data.ErosionReloadListener;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Ldev/sterner/witchery/content/item/brew/BrewOfErosionItem;", "Ldev/sterner/witchery/content/item/brew/ThrowableBrewItem;", "color", "", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(ILnet/minecraft/world/item/Item$Properties;)V", "applyEffectOnBlock", "", "level", "Lnet/minecraft/world/level/Level;", "blockHit", "Lnet/minecraft/world/phys/BlockHitResult;", "hasFrog", "", "Companion", "witchery"})
public final class BrewOfErosionItem
extends ThrowableBrewItem {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public BrewOfErosionItem(int color, @NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(color, properties, null, 4, null);
    }

    @Override
    public void applyEffectOnBlock(@NotNull Level level, @NotNull BlockHitResult blockHit, boolean hasFrog) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockHit, (String)"blockHit");
        if (level.isClientSide) {
            return;
        }
        BlockPos centerPos = blockHit.getBlockPos();
        int radius = hasFrog ? 4 : 3;
        Intrinsics.checkNotNull((Object)centerPos);
        List<BlockPos> positions = Companion.collectPositionsInSphere(centerPos, radius);
        for (BlockPos pos : positions) {
            BlockState blockState = level.getBlockState(pos);
            Block fromBlock = blockState.getBlock();
            Block toBlock = ErosionReloadListener.INSTANCE.getEROSION_PAIR().get(fromBlock);
            if (toBlock == null) continue;
            BlockState toBlockState = toBlock.defaultBlockState();
            for (Property property : blockState.getProperties()) {
                Comparable value;
                if (!toBlockState.hasProperty(property)) continue;
                Intrinsics.checkNotNull((Object)blockState.getValue(property), (String)"null cannot be cast to non-null type kotlin.Comparable<kotlin.Any>");
                Intrinsics.checkNotNull((Object)property, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.properties.Property<kotlin.Comparable<kotlin.Any>>");
                toBlockState = (BlockState)toBlockState.setValue(property, value);
            }
            level.setBlock(pos, toBlockState, 3);
        }
    }

    @JvmStatic
    @NotNull
    public static final List<BlockPos> collectPositionsInSphere(@NotNull BlockPos center, int radius) {
        return Companion.collectPositionsInSphere(center, radius);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Ldev/sterner/witchery/content/item/brew/BrewOfErosionItem$Companion;", "", "<init>", "()V", "collectPositionsInSphere", "", "Lnet/minecraft/core/BlockPos;", "center", "radius", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<BlockPos> collectPositionsInSphere(@NotNull BlockPos center, int radius) {
            Intrinsics.checkNotNullParameter((Object)center, (String)"center");
            List positions = new ArrayList();
            int x = -radius;
            if (x <= radius) {
                while (true) {
                    int y;
                    if ((y = -radius) <= radius) {
                        while (true) {
                            int z;
                            if ((z = -radius) <= radius) {
                                while (true) {
                                    BlockPos offset;
                                    if ((offset = new BlockPos(x, y, z)).distSqr(Vec3i.ZERO) <= (double)(radius * radius)) {
                                        BlockPos blockPos = center.offset((Vec3i)offset);
                                        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
                                        positions.add(blockPos);
                                    }
                                    if (z == radius) break;
                                    ++z;
                                }
                            }
                            if (y == radius) break;
                            ++y;
                        }
                    }
                    if (x == radius) break;
                    ++x;
                }
            }
            return positions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

