/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.mob_effect;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/content/mob_effect/ReflectArrowsMobEffect;", "Lnet/minecraft/world/effect/MobEffect;", "category", "Lnet/minecraft/world/effect/MobEffectCategory;", "color", "", "<init>", "(Lnet/minecraft/world/effect/MobEffectCategory;I)V", "applyEffectTick", "", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "amplifier", "shouldApplyEffectTickThisTick", "duration", "witchery"})
public final class ReflectArrowsMobEffect
extends MobEffect {
    public ReflectArrowsMobEffect(@NotNull MobEffectCategory category, int color) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        super(category, color);
    }

    public boolean applyEffectTick(@NotNull LivingEntity entity, int amplifier) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!entity.level().isClientSide) {
            double radius = 1.0 + (double)(amplifier * 2);
            Level level = entity.level();
            List nearbyArrows = level.getEntitiesOfClass(AbstractArrow.class, entity.getBoundingBox().inflate(radius));
            for (AbstractArrow arrow : nearbyArrows) {
                Entity shooter = arrow.getOwner();
                if (!(shooter instanceof LivingEntity) || Intrinsics.areEqual((Object)shooter, (Object)entity) || arrow.isCritArrow()) continue;
                Vec3 direction = ((LivingEntity)shooter).position().subtract(arrow.position()).normalize();
                double dx = direction.x;
                double dy = direction.y;
                double dz = direction.z;
                float yaw = (float)Math.toDegrees(Math.atan2(-dx, dz));
                float pitch = (float)Math.toDegrees(-Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)));
                float speed = (float)arrow.getDeltaMovement().length() * 0.9f;
                arrow.shootFromRotation((Entity)entity, pitch, yaw, 0.0f, speed, 0.1f);
                arrow.setOwner((Entity)entity);
                arrow.hasImpulse = true;
                level.playSound(null, (double)arrow.getBlockX(), (double)arrow.getBlockY(), (double)arrow.getBlockZ(), SoundEvents.SHIELD_BLOCK, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

