/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.core.api.entity;

import com.mojang.serialization.DynamicOps;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.mixin.PlayerInvoker;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-By\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001a\"\u0004\b\u001e\u0010\u001cR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001a\"\u0004\b \u0010\u001cR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001cR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001a\"\u0004\b$\u0010\u001cR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u0006."}, d2={"Ldev/sterner/witchery/core/api/entity/PlayerShellData;", "", "id", "Ljava/util/UUID;", "resolvableProfile", "Lnet/minecraft/world/item/component/ResolvableProfile;", "mainInventory", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "armorInventory", "offHandInventory", "equipment", "extraInventory", "model", "", "<init>", "(Ljava/util/UUID;Lnet/minecraft/world/item/component/ResolvableProfile;Lnet/minecraft/core/NonNullList;Lnet/minecraft/core/NonNullList;Lnet/minecraft/core/NonNullList;Lnet/minecraft/core/NonNullList;Lnet/minecraft/core/NonNullList;B)V", "getId", "()Ljava/util/UUID;", "setId", "(Ljava/util/UUID;)V", "getResolvableProfile", "()Lnet/minecraft/world/item/component/ResolvableProfile;", "setResolvableProfile", "(Lnet/minecraft/world/item/component/ResolvableProfile;)V", "getMainInventory", "()Lnet/minecraft/core/NonNullList;", "setMainInventory", "(Lnet/minecraft/core/NonNullList;)V", "getArmorInventory", "setArmorInventory", "getOffHandInventory", "setOffHandInventory", "getEquipment", "setEquipment", "getExtraInventory", "setExtraInventory", "getModel", "()B", "setModel", "(B)V", "writeNbt", "Lnet/minecraft/nbt/CompoundTag;", "lookup", "Lnet/minecraft/core/HolderLookup$Provider;", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nPlayerShellData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerShellData.kt\ndev/sterner/witchery/core/api/entity/PlayerShellData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class PlayerShellData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private UUID id;
    @Nullable
    private ResolvableProfile resolvableProfile;
    @NotNull
    private NonNullList<ItemStack> mainInventory;
    @NotNull
    private NonNullList<ItemStack> armorInventory;
    @NotNull
    private NonNullList<ItemStack> offHandInventory;
    @NotNull
    private NonNullList<ItemStack> equipment;
    @NotNull
    private NonNullList<ItemStack> extraInventory;
    private byte model;

    public PlayerShellData(@Nullable UUID id, @Nullable ResolvableProfile resolvableProfile, @NotNull NonNullList<ItemStack> mainInventory, @NotNull NonNullList<ItemStack> armorInventory, @NotNull NonNullList<ItemStack> offHandInventory, @NotNull NonNullList<ItemStack> equipment, @NotNull NonNullList<ItemStack> extraInventory, byte model) {
        Intrinsics.checkNotNullParameter(mainInventory, (String)"mainInventory");
        Intrinsics.checkNotNullParameter(armorInventory, (String)"armorInventory");
        Intrinsics.checkNotNullParameter(offHandInventory, (String)"offHandInventory");
        Intrinsics.checkNotNullParameter(equipment, (String)"equipment");
        Intrinsics.checkNotNullParameter(extraInventory, (String)"extraInventory");
        this.id = id;
        this.resolvableProfile = resolvableProfile;
        this.mainInventory = mainInventory;
        this.armorInventory = armorInventory;
        this.offHandInventory = offHandInventory;
        this.equipment = equipment;
        this.extraInventory = extraInventory;
        this.model = model;
    }

    public /* synthetic */ PlayerShellData(UUID uUID, ResolvableProfile resolvableProfile, NonNullList nonNullList, NonNullList nonNullList2, NonNullList nonNullList3, NonNullList nonNullList4, NonNullList nonNullList5, byte by, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            uUID = new UUID(0L, 0L);
        }
        if ((n & 2) != 0) {
            resolvableProfile = null;
        }
        if ((n & 4) != 0) {
            NonNullList nonNullList6 = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList6, (String)"withSize(...)");
            nonNullList = nonNullList6;
        }
        if ((n & 8) != 0) {
            NonNullList nonNullList7 = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList7, (String)"withSize(...)");
            nonNullList2 = nonNullList7;
        }
        if ((n & 0x10) != 0) {
            NonNullList nonNullList8 = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList8, (String)"withSize(...)");
            nonNullList3 = nonNullList8;
        }
        if ((n & 0x20) != 0) {
            NonNullList nonNullList9 = NonNullList.withSize((int)EntriesMappings.entries$0.size(), (Object)ItemStack.EMPTY);
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList9, (String)"withSize(...)");
            nonNullList4 = nonNullList9;
        }
        if ((n & 0x40) != 0) {
            NonNullList nonNullList10 = NonNullList.withSize((int)45, (Object)ItemStack.EMPTY);
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList10, (String)"withSize(...)");
            nonNullList5 = nonNullList10;
        }
        if ((n & 0x80) != 0) {
            by = 0;
        }
        this(uUID, resolvableProfile, (NonNullList<ItemStack>)nonNullList, (NonNullList<ItemStack>)nonNullList2, (NonNullList<ItemStack>)nonNullList3, (NonNullList<ItemStack>)nonNullList4, (NonNullList<ItemStack>)nonNullList5, by);
    }

    @Nullable
    public final UUID getId() {
        return this.id;
    }

    public final void setId(@Nullable UUID uUID) {
        this.id = uUID;
    }

    @Nullable
    public final ResolvableProfile getResolvableProfile() {
        return this.resolvableProfile;
    }

    public final void setResolvableProfile(@Nullable ResolvableProfile resolvableProfile) {
        this.resolvableProfile = resolvableProfile;
    }

    @NotNull
    public final NonNullList<ItemStack> getMainInventory() {
        return this.mainInventory;
    }

    public final void setMainInventory(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"<set-?>");
        this.mainInventory = nonNullList;
    }

    @NotNull
    public final NonNullList<ItemStack> getArmorInventory() {
        return this.armorInventory;
    }

    public final void setArmorInventory(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"<set-?>");
        this.armorInventory = nonNullList;
    }

    @NotNull
    public final NonNullList<ItemStack> getOffHandInventory() {
        return this.offHandInventory;
    }

    public final void setOffHandInventory(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"<set-?>");
        this.offHandInventory = nonNullList;
    }

    @NotNull
    public final NonNullList<ItemStack> getEquipment() {
        return this.equipment;
    }

    public final void setEquipment(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"<set-?>");
        this.equipment = nonNullList;
    }

    @NotNull
    public final NonNullList<ItemStack> getExtraInventory() {
        return this.extraInventory;
    }

    public final void setExtraInventory(@NotNull NonNullList<ItemStack> nonNullList) {
        Intrinsics.checkNotNullParameter(nonNullList, (String)"<set-?>");
        this.extraInventory = nonNullList;
    }

    public final byte getModel() {
        return this.model;
    }

    public final void setModel(byte by) {
        this.model = by;
    }

    @NotNull
    public final CompoundTag writeNbt(@NotNull HolderLookup.Provider lookup) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        CompoundTag nbt = new CompoundTag();
        UUID uUID = this.id;
        if (uUID != null) {
            UUID it = uUID;
            boolean bl = false;
            nbt.putUUID("Id", it);
        }
        nbt.put("profile", (Tag)ResolvableProfile.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.resolvableProfile).getOrThrow());
        nbt.putByte("Model", this.model);
        PlayerShellData.Companion.writeInventory(nbt, "Main", (NonNullList<ItemStack>)this.mainInventory, lookup);
        PlayerShellData.Companion.writeInventory(nbt, "Armor", (NonNullList<ItemStack>)this.armorInventory, lookup);
        PlayerShellData.Companion.writeInventory(nbt, "Offhand", (NonNullList<ItemStack>)this.offHandInventory, lookup);
        PlayerShellData.Companion.writeInventory(nbt, "Extra", (NonNullList<ItemStack>)this.extraInventory, lookup);
        PlayerShellData.Companion.writeInventory(nbt, "Equipment", (NonNullList<ItemStack>)this.equipment, lookup);
        return nbt;
    }

    public PlayerShellData() {
        this(null, null, null, null, null, null, null, 0, 255, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002J.\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0018"}, d2={"Ldev/sterner/witchery/core/api/entity/PlayerShellData$Companion;", "", "<init>", "()V", "fromPlayer", "Ldev/sterner/witchery/core/api/entity/PlayerShellData;", "player", "Lnet/minecraft/world/entity/player/Player;", "readNbt", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "lookup", "Lnet/minecraft/core/HolderLookup$Provider;", "readInventory", "", "compound", "name", "", "inv", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "writeInventory", "key", "inventory", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PlayerShellData fromPlayer(@NotNull Player player) {
            int i;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            PlayerShellData builder = new PlayerShellData(null, null, null, null, null, null, null, 0, 255, null);
            builder.setId(UUID.randomUUID());
            builder.setResolvableProfile(new ResolvableProfile(player.getGameProfile()));
            int n = ((Collection)builder.getMainInventory()).size();
            for (i = 0; i < n; ++i) {
                builder.getMainInventory().set(i, player.getInventory().items.get(i));
            }
            n = ((Collection)builder.getArmorInventory()).size();
            for (i = 0; i < n; ++i) {
                builder.getArmorInventory().set(i, player.getInventory().armor.get(i));
            }
            n = ((Collection)builder.getOffHandInventory()).size();
            for (i = 0; i < n; ++i) {
                builder.getOffHandInventory().set(i, player.getInventory().offhand.get(i));
            }
            n = ((Collection)EntriesMappings.entries$0).size();
            for (i = 0; i < n; ++i) {
                builder.getEquipment().set(i, (Object)player.getItemBySlot((EquipmentSlot)EntriesMappings.entries$0.get(i)).copy());
            }
            EntityDataAccessor<Byte> entityDataAccessor = PlayerInvoker.getPlayerModeCustomisationAccessor();
            Intrinsics.checkNotNullExpressionValue(entityDataAccessor, (String)"getPlayerModeCustomisationAccessor(...)");
            EntityDataAccessor<Byte> playerModeCustomisation = entityDataAccessor;
            Object object = player.getEntityData().get(playerModeCustomisation);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            builder.setModel(((Number)object).byteValue());
            return builder;
        }

        @NotNull
        public final PlayerShellData readNbt(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider lookup) {
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
            PlayerShellData builder = new PlayerShellData(null, null, null, null, null, null, null, 0, 255, null);
            if (nbt.contains("Id")) {
                builder.setId(nbt.getUUID("Id"));
            } else {
                builder.setId(UUID.randomUUID());
            }
            if (nbt.contains("profile")) {
                ResolvableProfile.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("profile")).resultOrPartial(Companion::readNbt$lambda$0).ifPresent(arg_0 -> Companion.readNbt$lambda$2(arg_0 -> Companion.readNbt$lambda$1(builder, arg_0), arg_0));
            }
            this.readInventory(nbt, "Main", builder.getMainInventory(), lookup);
            this.readInventory(nbt, "Armor", builder.getArmorInventory(), lookup);
            this.readInventory(nbt, "Offhand", builder.getOffHandInventory(), lookup);
            this.readInventory(nbt, "Equipment", builder.getEquipment(), lookup);
            this.readInventory(nbt, "Extra", builder.getExtraInventory(), lookup);
            builder.setModel(nbt.getByte("Model"));
            return builder;
        }

        private final void readInventory(CompoundTag compound, String name, NonNullList<ItemStack> inv, HolderLookup.Provider lookup) {
            if (compound.contains(name, 9)) {
                ListTag listTag = compound.getList(name, 10);
                int n = ((Collection)inv).size();
                for (int i = 0; i < n; ++i) {
                    CompoundTag compoundTag = listTag.getCompound(i);
                    inv.set(i, (Object)ItemStack.parseOptional((HolderLookup.Provider)lookup, (CompoundTag)compoundTag));
                }
            }
        }

        private final void writeInventory(CompoundTag nbt, String key, NonNullList<ItemStack> inventory, HolderLookup.Provider lookup) {
            ListTag listTag = new ListTag();
            Iterator iterator = inventory.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                ItemStack itemStack = (ItemStack)iterator2.next();
                boolean bl = !itemStack.isEmpty() ? listTag.add((Object)itemStack.save(lookup)) : listTag.add((Object)new CompoundTag());
            }
            nbt.put(key, (Tag)listTag);
        }

        private static final void readNbt$lambda$0(String string) {
            Witchery.Companion.getLOGGER().error("Failed to load profile from sleeping player: {}", (Object)string);
        }

        private static final Unit readNbt$lambda$1(PlayerShellData $builder, ResolvableProfile owner) {
            $builder.setResolvableProfile(owner);
            return Unit.INSTANCE;
        }

        private static final void readNbt$lambda$2(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class EntriesMappings {
            public static final /* synthetic */ EnumEntries<EquipmentSlot> entries$0;

            static {
                entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EquipmentSlot.values()));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EquipmentSlot> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EquipmentSlot.values()));
        }
    }
}

