/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.affliction.werewolf;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.entity.HornedHuntsmanEntity;
import dev.sterner.witchery.core.util.WitcheryUtil;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.affliction.TransformationPlayerAttachment;
import dev.sterner.witchery.features.affliction.event.TransformationHandler;
import dev.sterner.witchery.features.affliction.werewolf.WerewolfAbility;
import dev.sterner.witchery.features.affliction.werewolf.WerewolfLeveling;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000eJ\u0016\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000eJ\u0016\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000eJ\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u001c\u00a8\u0006\u001d"}, d2={"Ldev/sterner/witchery/features/affliction/werewolf/WerewolfSpecificEventHandler;", "", "<init>", "()V", "killEntity", "", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "tick", "player", "Lnet/minecraft/world/entity/player/Player;", "modifyWerewolfDamage", "", "attacker", "target", "originalDamage", "handleHurtWolfman", "remainingDamage", "handleHurtWolf", "werewolfTick", "wolfTick", "tryForceTurnWerewolfToHuman", "data", "Ldev/sterner/witchery/features/affliction/AfflictionPlayerAttachment$Data;", "tryForceTurnToWerewolf", "infectPlayer", "Lnet/minecraft/server/level/ServerPlayer;", "witchery"})
@SourceDebugExtension(value={"SMAP\nWerewolfSpecificEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WerewolfSpecificEventHandler.kt\ndev/sterner/witchery/features/affliction/werewolf/WerewolfSpecificEventHandler\n+ 2 AfflictionPlayerAttachment.kt\ndev/sterner/witchery/features/affliction/AfflictionPlayerAttachment\n*L\n1#1,197:1\n69#2,15:198\n*S KotlinDebug\n*F\n+ 1 WerewolfSpecificEventHandler.kt\ndev/sterner/witchery/features/affliction/werewolf/WerewolfSpecificEventHandler\n*L\n63#1:198,15\n*E\n"})
public final class WerewolfSpecificEventHandler {
    @NotNull
    public static final WerewolfSpecificEventHandler INSTANCE = new WerewolfSpecificEventHandler();

    private WerewolfSpecificEventHandler() {
    }

    public final void killEntity(@Nullable LivingEntity livingEntity, @Nullable DamageSource damageSource) {
        boolean bl3;
        DamageSource damageSource2 = damageSource;
        if (!((damageSource2 != null ? damageSource2.getEntity() : null) instanceof ServerPlayer)) {
            return;
        }
        Entity entity = damageSource.getEntity();
        Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
        ServerPlayer player = (ServerPlayer)entity;
        AfflictionPlayerAttachment.Data wereData = AfflictionPlayerAttachment.getData((Player)player);
        int wereLevel = wereData.getWerewolfLevel();
        LivingEntity livingEntity2 = livingEntity;
        if (livingEntity2 instanceof Piglin) {
            WerewolfLeveling.INSTANCE.increaseKilledPiglin(player);
        } else if (livingEntity2 instanceof Sheep) {
            WerewolfLeveling.INSTANCE.increaseKilledSheep(player);
        } else if (livingEntity2 instanceof Wolf) {
            WerewolfLeveling.INSTANCE.increaseKilledWolf(player);
        } else if (livingEntity2 instanceof HornedHuntsmanEntity) {
            WerewolfLeveling.INSTANCE.setHasKilledHuntsman(player);
        }
        if (wereLevel >= 4 && (TransformationHandler.isWolf((Player)player) || TransformationHandler.isWerewolf((Player)player))) {
            player.getFoodData().eat(2, 0.5f);
            if (player.level() instanceof ServerLevel) {
                Level level = player.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel serverLevel = (ServerLevel)level;
                ParticleOptions particleOptions = (ParticleOptions)ParticleTypes.DAMAGE_INDICATOR;
                LivingEntity livingEntity3 = livingEntity;
                Intrinsics.checkNotNull((Object)livingEntity3);
                serverLevel.sendParticles(particleOptions, livingEntity3.getX(), livingEntity.getY() + (double)(livingEntity.getEyeHeight() / (float)2), livingEntity.getZ(), 10, 0.3, 0.3, 0.3, 0.1);
            }
        }
        boolean bl = bl3 = player.fallDistance > 0.0f && !player.onGround() && !player.onClimbable() && !player.isInWater() && !player.isPassenger();
        if (wereLevel >= 6 && bl3) {
            AfflictionPlayerAttachment.Data currentData$iv;
            AfflictionPlayerAttachment afflictionPlayerAttachment = AfflictionPlayerAttachment.INSTANCE;
            Player player$iv = (Player)player;
            boolean sync$iv = true;
            boolean $i$f$smartUpdate = false;
            AfflictionPlayerAttachment.Data $this$killEntity_u24lambda_u240 = currentData$iv = AfflictionPlayerAttachment.getData(player$iv);
            boolean bl2 = false;
            AfflictionPlayerAttachment.Data newData$iv = AfflictionPlayerAttachment.Data.incrementAirSlayMonster$default($this$killEntity_u24lambda_u240, 0, 1, null);
            AfflictionPlayerAttachment.setData(player$iv, newData$iv, false);
            if (player$iv.level() instanceof ServerLevel) {
                AfflictionPlayerAttachment.syncSmart(player$iv, newData$iv);
            }
        }
    }

    @JvmStatic
    public static final void tick(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        if (!player.level().isClientSide) {
            if (player.level().getGameTime() % (long)20 == 0L) {
                AfflictionPlayerAttachment.Data wereData = AfflictionPlayerAttachment.getData(player);
                if (!player.level().isDay() && player.level().getMoonPhase() == 0) {
                    TransformationPlayerAttachment.TransformationType type;
                    if (wereData.getWerewolfLevel() > 0 && (type = TransformationPlayerAttachment.getData(player).getTransformationType()) == TransformationPlayerAttachment.TransformationType.NONE) {
                        INSTANCE.tryForceTurnToWerewolf(player, wereData);
                    }
                } else if ((player.level().isDay() || player.level().getMoonPhase() != 0) && wereData.getWerewolfLevel() > 0) {
                    INSTANCE.tryForceTurnWerewolfToHuman(player, wereData);
                }
            }
            if (TransformationHandler.isWolf(player)) {
                INSTANCE.wolfTick(player);
            } else if (TransformationHandler.isWerewolf(player)) {
                INSTANCE.werewolfTick(player);
            }
        }
    }

    public final float modifyWerewolfDamage(@NotNull Player attacker, @NotNull LivingEntity target, float originalDamage) {
        Intrinsics.checkNotNullParameter((Object)attacker, (String)"attacker");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        AfflictionPlayerAttachment.Data wereData = AfflictionPlayerAttachment.getData(attacker);
        int wereLevel = wereData.getWerewolfLevel();
        if (!TransformationHandler.isWolf(attacker) && !TransformationHandler.isWerewolf(attacker)) {
            return originalDamage;
        }
        float damage = originalDamage;
        if (wereLevel >= 6 && attacker.isSprinting()) {
            damage *= 1.5f;
            if (attacker.fallDistance > 0.0f && !attacker.onGround() && !attacker.isPassenger() && !attacker.hasEffect(MobEffects.BLINDNESS)) {
                damage *= 1.5f;
                if (attacker.level() instanceof ServerLevel) {
                    Level level = attacker.level();
                    Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.CRIT, target.getX(), target.getY() + (double)(target.getEyeHeight() / (float)2), target.getZ(), 15, 0.3, 0.3, 0.3, 0.2);
                }
            }
        }
        return damage;
    }

    public final float handleHurtWolfman(@NotNull DamageSource damageSource, float remainingDamage) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        float damage = remainingDamage;
        damage *= 0.75f;
        if (damageSource.is(DamageTypes.FALL)) {
            return 0.0f;
        }
        return damage;
    }

    public final float handleHurtWolf(@NotNull DamageSource damageSource, float remainingDamage) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        float damage = remainingDamage;
        damage *= 0.85f;
        if (damageSource.is(DamageTypes.FALL)) {
            damage *= 0.5f;
        }
        return damage;
    }

    private final void werewolfTick(Player player) {
        TransformationPlayerAttachment.INSTANCE.sync(player, TransformationPlayerAttachment.getData(player));
    }

    private final void wolfTick(Player player) {
        TransformationPlayerAttachment.INSTANCE.sync(player, TransformationPlayerAttachment.getData(player));
    }

    private final void tryForceTurnWerewolfToHuman(Player player, AfflictionPlayerAttachment.Data data2) {
        if (data2.getWerewolfLevel() < 3 && !WerewolfAbility.Companion.hasMoonCharm(player) && TransformationHandler.isWolf(player)) {
            TransformationHandler.removeForm(player);
        } else if (data2.getWerewolfLevel() < 5 && !WerewolfAbility.Companion.hasMoonCharm(player) && TransformationHandler.isWerewolf(player)) {
            TransformationHandler.removeForm(player);
        }
    }

    private final void tryForceTurnToWerewolf(Player player, AfflictionPlayerAttachment.Data data2) {
        if (data2.getWerewolfLevel() < 3 && !WerewolfAbility.Companion.hasMoonCharm(player)) {
            TransformationHandler.setWolfForm(player);
        } else if (data2.getWerewolfLevel() < 5 && !WerewolfAbility.Companion.hasMoonCharm(player)) {
            TransformationHandler.setWereWolfForm(player);
        }
    }

    public final void infectPlayer(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (AfflictionPlayerAttachment.getData((Player)player).getWerewolfLevel() == 0) {
            ResourceLocation resourceLocation = Witchery.Companion.id("werewolf/1");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            WitcheryUtil.INSTANCE.grantAdvancementCriterion(player, resourceLocation, "impossible_1");
            WerewolfLeveling.increaseWerewolfLevel(player);
        }
    }
}

