/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.altar;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.features.altar.ChunkedAltarPositionsAttachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/features/altar/ChunkedAltarPositionsAttachment;", "", "<init>", "()V", "getData", "Ldev/sterner/witchery/features/altar/ChunkedAltarPositionsAttachment$Data;", "level", "Lnet/minecraft/server/level/ServerLevel;", "setData", "", "data", "registerAltar", "pos", "Lnet/minecraft/core/BlockPos;", "unregisterAltar", "findNearbyAltars", "", "radius", "", "Data", "witchery"})
@SourceDebugExtension(value={"SMAP\nChunkedAltarPositionsAttachment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkedAltarPositionsAttachment.kt\ndev/sterner/witchery/features/altar/ChunkedAltarPositionsAttachment\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1869#2,2:111\n*S KotlinDebug\n*F\n+ 1 ChunkedAltarPositionsAttachment.kt\ndev/sterner/witchery/features/altar/ChunkedAltarPositionsAttachment\n*L\n82#1:111,2\n*E\n"})
public final class ChunkedAltarPositionsAttachment {
    @NotNull
    public static final ChunkedAltarPositionsAttachment INSTANCE = new ChunkedAltarPositionsAttachment();

    private ChunkedAltarPositionsAttachment() {
    }

    @JvmStatic
    @NotNull
    public static final Data getData(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Object object = level.getData(WitcheryDataAttachments.getCHUNKED_ALTAR_POSITIONS_ATTACHMENT());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    @JvmStatic
    public static final void setData(@NotNull ServerLevel level, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        level.setData(WitcheryDataAttachments.getCHUNKED_ALTAR_POSITIONS_ATTACHMENT(), (Object)data2);
    }

    @JvmStatic
    public static final void registerAltar(@NotNull ServerLevel level, @NotNull BlockPos pos) {
        List currentPositions;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Data data2 = ChunkedAltarPositionsAttachment.getData(level);
        long chunkPosLong = ChunkPos.asLong((BlockPos)pos);
        List list = data2.getChunkMap().get(chunkPosLong);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if (!(currentPositions = list).contains(pos)) {
            Map updatedMap = MapsKt.toMutableMap(data2.getChunkMap());
            updatedMap.put(chunkPosLong, CollectionsKt.plus((Collection)currentPositions, (Object)pos));
            ChunkedAltarPositionsAttachment.setData(level, new Data(updatedMap));
        }
    }

    @JvmStatic
    public static final void unregisterAltar(@NotNull ServerLevel level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Data data2 = ChunkedAltarPositionsAttachment.getData(level);
        long chunkPosLong = ChunkPos.asLong((BlockPos)pos);
        List<BlockPos> list = data2.getChunkMap().get(chunkPosLong);
        if (list == null) {
            return;
        }
        List<BlockPos> currentPositions = list;
        if (currentPositions.contains(pos)) {
            Map updatedMap = MapsKt.toMutableMap(data2.getChunkMap());
            List newPositions = CollectionsKt.minus((Iterable)currentPositions, (Object)pos);
            if (newPositions.isEmpty()) {
                updatedMap.remove(chunkPosLong);
            } else {
                updatedMap.put(chunkPosLong, newPositions);
            }
            ChunkedAltarPositionsAttachment.setData(level, new Data(updatedMap));
        }
    }

    @JvmStatic
    @NotNull
    public static final List<BlockPos> findNearbyAltars(@NotNull ServerLevel level, @NotNull BlockPos pos, int radius) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Data data2 = ChunkedAltarPositionsAttachment.getData(level);
        int radiusSq = radius * radius;
        int chunkRadius = (int)Math.ceil((double)radius / 16.0);
        ChunkPos centerChunk = new ChunkPos(pos);
        List nearbyAltars = new ArrayList();
        int xOffset = -chunkRadius;
        if (xOffset <= chunkRadius) {
            while (true) {
                int zOffset;
                if ((zOffset = -chunkRadius) <= chunkRadius) {
                    while (true) {
                        int maxChunkOffset;
                        int chunkDz;
                        int chunkX = centerChunk.x + xOffset;
                        int chunkZ = centerChunk.z + zOffset;
                        int chunkCenterX = chunkX * 16 + 8;
                        int chunkCenterZ = chunkZ * 16 + 8;
                        int chunkDx = chunkCenterX - pos.getX();
                        int chunkDistSq = chunkDx * chunkDx + (chunkDz = chunkCenterZ - pos.getZ()) * chunkDz;
                        if (chunkDistSq <= (radius + (maxChunkOffset = 11)) * (radius + maxChunkOffset)) {
                            long chunkPosLong = ChunkPos.asLong((int)chunkX, (int)chunkZ);
                            List<BlockPos> list = data2.getChunkMap().get(chunkPosLong);
                            if (list != null) {
                                Iterable $this$forEach$iv = list;
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    BlockPos altarPos = (BlockPos)element$iv;
                                    boolean bl = false;
                                    if (!(altarPos.distSqr((Vec3i)pos) <= (double)radiusSq)) continue;
                                    nearbyAltars.add(altarPos);
                                }
                            }
                        }
                        if (zOffset == chunkRadius) break;
                        ++zOffset;
                    }
                }
                if (xOffset == chunkRadius) break;
                ++xOffset;
            }
        }
        return nearbyAltars;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B#\u0012\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u00c6\u0003J%\u0010\f\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Ldev/sterner/witchery/features/altar/ChunkedAltarPositionsAttachment$Data;", "", "chunkMap", "", "", "", "Lnet/minecraft/core/BlockPos;", "<init>", "(Ljava/util/Map;)V", "getChunkMap", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "witchery"})
    @SourceDebugExtension(value={"SMAP\nChunkedAltarPositionsAttachment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkedAltarPositionsAttachment.kt\ndev/sterner/witchery/features/altar/ChunkedAltarPositionsAttachment$Data\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1563#2:111\n1634#2,3:112\n*S KotlinDebug\n*F\n+ 1 ChunkedAltarPositionsAttachment.kt\ndev/sterner/witchery/features/altar/ChunkedAltarPositionsAttachment$Data\n*L\n106#1:111\n106#1:112,3\n*E\n"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<Long, List<BlockPos>> chunkMap;
        @NotNull
        private static final ResourceLocation ID;
        @NotNull
        private static final Codec<Pair<Long, List<BlockPos>>> CHUNK_ENTRY_CODEC;
        @NotNull
        private static final Codec<Data> DATA_CODEC;

        public Data(@NotNull Map<Long, ? extends List<? extends BlockPos>> chunkMap) {
            Intrinsics.checkNotNullParameter(chunkMap, (String)"chunkMap");
            this.chunkMap = chunkMap;
        }

        public /* synthetic */ Data(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @NotNull
        public final Map<Long, List<BlockPos>> getChunkMap() {
            return this.chunkMap;
        }

        @NotNull
        public final Map<Long, List<BlockPos>> component1() {
            return this.chunkMap;
        }

        @NotNull
        public final Data copy(@NotNull Map<Long, ? extends List<? extends BlockPos>> chunkMap) {
            Intrinsics.checkNotNullParameter(chunkMap, (String)"chunkMap");
            return new Data(chunkMap);
        }

        public static /* synthetic */ Data copy$default(Data data2, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = data2.chunkMap;
            }
            return data2.copy(map);
        }

        @NotNull
        public String toString() {
            return "Data(chunkMap=" + this.chunkMap + ")";
        }

        public int hashCode() {
            return ((Object)this.chunkMap).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            return Intrinsics.areEqual(this.chunkMap, data2.chunkMap);
        }

        private static final App CHUNK_ENTRY_CODEC$lambda$0(RecordCodecBuilder.Instance inst) {
            return inst.group((App)Codec.LONG.fieldOf("chunkPos").forGetter(arg_0 -> Data.CHUNK_ENTRY_CODEC$lambda$0$0((KProperty1)Companion.CHUNK_ENTRY_CODEC.1.1.INSTANCE, arg_0)), (App)BlockPos.CODEC.listOf().fieldOf("positions").forGetter(arg_0 -> Data.CHUNK_ENTRY_CODEC$lambda$0$1((KProperty1)Companion.CHUNK_ENTRY_CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)inst, Pair::new);
        }

        private static final Long CHUNK_ENTRY_CODEC$lambda$0$0(KProperty1 $tmp0, Pair p0) {
            return (Long)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final List CHUNK_ENTRY_CODEC$lambda$0$1(KProperty1 $tmp0, Pair p0) {
            return (List)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Data DATA_CODEC$lambda$0(List list) {
            Intrinsics.checkNotNull((Object)list);
            return new Data(MapsKt.toMap((Iterable)list));
        }

        private static final Data DATA_CODEC$lambda$1(Function1 $tmp0, Object p0) {
            return (Data)$tmp0.invoke(p0);
        }

        /*
         * WARNING - void declaration
         */
        private static final List DATA_CODEC$lambda$2(Data data2) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = data2.chunkMap.entrySet();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Map.Entry entry = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to(it.getKey(), it.getValue()));
            }
            return (List)destination$iv$iv;
        }

        private static final List DATA_CODEC$lambda$3(Function1 $tmp0, Object p0) {
            return (List)$tmp0.invoke(p0);
        }

        public Data() {
            this(null, 1, null);
        }

        static {
            ResourceLocation resourceLocation = Witchery.Companion.id("chunked_altar_positions");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            ID = resourceLocation;
            Codec codec = RecordCodecBuilder.create(Data::CHUNK_ENTRY_CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CHUNK_ENTRY_CODEC = codec;
            Codec codec2 = CHUNK_ENTRY_CODEC.listOf().xmap(arg_0 -> Data.DATA_CODEC$lambda$1(Data::DATA_CODEC$lambda$0, arg_0), arg_0 -> Data.DATA_CODEC$lambda$3(Data::DATA_CODEC$lambda$2, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)codec2, (String)"xmap(...)");
            DATA_CODEC = codec2;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R&\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Ldev/sterner/witchery/features/altar/ChunkedAltarPositionsAttachment$Data$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "CHUNK_ENTRY_CODEC", "Lcom/mojang/serialization/Codec;", "Lkotlin/Pair;", "", "", "Lnet/minecraft/core/BlockPos;", "DATA_CODEC", "Ldev/sterner/witchery/features/altar/ChunkedAltarPositionsAttachment$Data;", "getDATA_CODEC", "()Lcom/mojang/serialization/Codec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ResourceLocation getID() {
                return ID;
            }

            @NotNull
            public final Codec<Data> getDATA_CODEC() {
                return DATA_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

