/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.curse;

import dev.sterner.witchery.content.entity.InsanityEntity;
import dev.sterner.witchery.core.api.Curse;
import dev.sterner.witchery.core.api.WitcheryApi;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.features.coven.CovenHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Ldev/sterner/witchery/features/curse/CurseOfInsanity;", "Ldev/sterner/witchery/core/api/Curse;", "<init>", "()V", "onTickCurse", "", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "catBoosted", "", "findLocationForInsanityMob", "Lnet/minecraft/core/BlockPos;", "center", "playInsanitySounds", "witchery"})
@SourceDebugExtension(value={"SMAP\nCurseOfInsanity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurseOfInsanity.kt\ndev/sterner/witchery/features/curse/CurseOfInsanity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
public final class CurseOfInsanity
extends Curse {
    @Override
    public void onTickCurse(@NotNull Level level, @NotNull Player player, boolean catBoosted) {
        boolean hasCovenBoost;
        int n;
        int baseInterval;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int n2 = baseInterval = WitcheryApi.INSTANCE.isWitchy(player) ? 1200 : 3600;
        if (level.getGameTime() % (long)(baseInterval + (int)(level.random.nextDouble() * (double)30)) == 0L) {
            BlockPos blockPos = player.blockPosition();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
            BlockPos pos = this.findLocationForInsanityMob(blockPos, level);
            if (pos != null) {
                InsanityEntity insanityEntity;
                InsanityEntity insanityEntity2 = insanityEntity = (InsanityEntity)((EntityType)WitcheryEntityTypes.INSTANCE.getINSANITY().get()).create(level);
                if (insanityEntity2 != null) {
                    insanityEntity2.moveTo(pos.getX(), pos.getY(), pos.getZ());
                }
                InsanityEntity insanityEntity3 = insanityEntity;
                if (insanityEntity3 != null) {
                    InsanityEntity it = insanityEntity3;
                    boolean bl = false;
                    level.addFreshEntity((Entity)it);
                }
            }
        }
        if (level instanceof ServerLevel) {
            BlockPos blockPos = player.blockPosition();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
            n = CovenHandler.INSTANCE.getActiveCovenSize(player, blockPos);
        } else {
            n = 0;
        }
        int covenSize = n;
        boolean bl = hasCovenBoost = covenSize >= 3;
        if (hasCovenBoost) {
            if (level.getGameTime() % (long)600 == 0L && level.random.nextFloat() < 0.4f) {
                this.playInsanitySounds(level, player);
            }
        } else if (level.getGameTime() % (long)1800 == 0L && level.random.nextFloat() < 0.3f) {
            this.playInsanitySounds(level, player);
        }
    }

    private final BlockPos findLocationForInsanityMob(BlockPos center, Level level) {
        RandomSource random = level.random;
        int radiusX = 16;
        int radiusY = 8;
        int radiusZ = 16;
        List positions = new ArrayList();
        int dx = -radiusX;
        if (dx <= radiusX) {
            while (true) {
                int dy;
                if ((dy = -radiusY) <= radiusY) {
                    while (true) {
                        int dz;
                        if ((dz = -radiusZ) <= radiusZ) {
                            while (true) {
                                BlockPos pos = center.offset(dx, dy, dz);
                                BlockState floor = level.getBlockState(pos);
                                BlockState space1 = level.getBlockState(pos.above());
                                BlockState space2 = level.getBlockState(pos.above(2));
                                BlockState space3 = level.getBlockState(pos.above(3));
                                if (floor.isSolid() && space1.isAir() && space2.isAir() && space3.isAir()) {
                                    BlockPos blockPos = pos.above();
                                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"above(...)");
                                    positions.add(blockPos);
                                }
                                if (dz == radiusZ) break;
                                ++dz;
                            }
                        }
                        if (dy == radiusY) break;
                        ++dy;
                    }
                }
                if (dx == radiusX) break;
                ++dx;
            }
        }
        return !((Collection)positions).isEmpty() ? (BlockPos)positions.get(random.nextInt(positions.size())) : null;
    }

    private final void playInsanitySounds(Level level, Player player) {
        if (!level.isClientSide) {
            int soundType = level.random.nextInt(5);
            double offsetX = (level.random.nextDouble() - 0.5) * (double)16;
            double offsetZ = (level.random.nextDouble() - 0.5) * (double)16;
            BlockPos soundPos = player.blockPosition().offset((int)offsetX, 0, (int)offsetZ);
            SoundEvent soundEvent = switch (soundType) {
                case 0 -> SoundEvents.CREEPER_PRIMED;
                case 1 -> SoundEvents.ENDERMAN_SCREAM;
                case 2 -> {
                    if (Intrinsics.areEqual((Object)level.dimension(), (Object)Level.NETHER)) {
                        yield SoundEvents.GHAST_SCREAM;
                    }
                    yield SoundEvents.CREEPER_PRIMED;
                }
                case 3 -> {
                    if (player.blockPosition().getY() < 0) {
                        yield SoundEvents.WARDEN_ROAR;
                    }
                    yield SoundEvents.ENDERMAN_SCREAM;
                }
                default -> (SoundEvent)SoundEvents.AMBIENT_CAVE.value();
            };
            level.playSound(null, soundPos, soundEvent, SoundSource.HOSTILE, 0.8f, 0.8f + level.random.nextFloat() * 0.4f);
        }
    }
}

