/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.ent;

import dev.sterner.witchery.content.entity.EntEntity;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.features.ent.EntSpawnLevelAttachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/sterner/witchery/features/ent/EntSpawningHandler;", "", "<init>", "()V", "MAX_DISTANCE", "", "breakBlock", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "player", "Lnet/minecraft/world/entity/player/Player;", "serverTick", "minecraftServer", "Lnet/minecraft/server/MinecraftServer;", "performSpawn", "Lnet/minecraft/server/level/ServerLevel;", "state", "witchery"})
@SourceDebugExtension(value={"SMAP\nEntSpawningHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntSpawningHandler.kt\ndev/sterner/witchery/features/ent/EntSpawningHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1761#2,3:115\n1563#2:119\n1634#2,3:120\n1869#2:123\n1617#2,9:124\n1869#2:133\n1870#2:135\n1626#2:136\n1870#2:137\n1#3:118\n1#3:134\n*S KotlinDebug\n*F\n+ 1 EntSpawningHandler.kt\ndev/sterner/witchery/features/ent/EntSpawningHandler\n*L\n36#1:115,3\n45#1:119\n45#1:120,3\n72#1:123\n77#1:124,9\n77#1:133\n77#1:135\n77#1:136\n72#1:137\n77#1:134\n*E\n"})
public final class EntSpawningHandler {
    @NotNull
    public static final EntSpawningHandler INSTANCE = new EntSpawningHandler();
    private static final int MAX_DISTANCE = 24;

    private EntSpawningHandler() {
    }

    /*
     * WARNING - void declaration
     */
    public final void breakBlock(@Nullable Level level, @Nullable BlockPos blockPos, @NotNull BlockState blockState, @Nullable Player player) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        if (level instanceof ServerLevel && blockPos != null) {
            boolean isRowan = blockState.is((Block)WitcheryBlocks.INSTANCE.getROWAN_LOG().get());
            boolean isHawthorn = blockState.is((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_LOG().get());
            boolean isAlder = blockState.is((Block)WitcheryBlocks.INSTANCE.getALDER_LOG().get());
            if (isRowan || isHawthorn || isAlder) {
                boolean hasLeafAbove;
                block12: {
                    Iterable $this$any$iv = (Iterable)new IntRange(1, 8);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v0 = false;
                    } else {
                        Iterator iterator = $this$any$iv.iterator();
                        while (iterator.hasNext()) {
                            int element$iv;
                            int offset = element$iv = ((IntIterator)iterator).nextInt();
                            boolean bl = false;
                            if (!((ServerLevel)level).getBlockState(blockPos.above(offset)).is(BlockTags.LEAVES)) continue;
                            v0 = true;
                            break block12;
                        }
                        v0 = hasLeafAbove = false;
                    }
                }
                if (hasLeafAbove) {
                    List list;
                    Object v1;
                    EntSpawnLevelAttachment.Data data2;
                    block13: {
                        data2 = EntSpawnLevelAttachment.getData((ServerLevel)level);
                        Iterable element$iv = data2.getEntries();
                        for (Object bl : element$iv) {
                            EntSpawnLevelAttachment.BlockEntry it = (EntSpawnLevelAttachment.BlockEntry)bl;
                            boolean bl2 = false;
                            if (!it.getBlockPos().closerThan((Vec3i)blockPos, 24.0)) continue;
                            v1 = bl;
                            break block13;
                        }
                        v1 = null;
                    }
                    EntSpawnLevelAttachment.BlockEntry nearbyEntry = v1;
                    if (nearbyEntry != null) {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = data2.getEntries();
                        boolean $i$f$map = false;
                        Iterable bl = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            EntSpawnLevelAttachment.BlockEntry blockEntry;
                            void entry;
                            EntSpawnLevelAttachment.BlockEntry blockEntry2 = (EntSpawnLevelAttachment.BlockEntry)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl3 = false;
                            if (Intrinsics.areEqual((Object)entry, (Object)nearbyEntry)) {
                                int n = entry.getCount() + 1;
                                blockEntry = EntSpawnLevelAttachment.BlockEntry.copy$default((EntSpawnLevelAttachment.BlockEntry)entry, null, blockState, n, 6000, 1, null);
                            } else {
                                blockEntry = entry;
                            }
                            collection.add(blockEntry);
                        }
                        list = (List)destination$iv$iv;
                    } else {
                        list = CollectionsKt.plus((Collection)data2.getEntries(), (Object)new EntSpawnLevelAttachment.BlockEntry(blockPos, blockState, 1, 6000));
                    }
                    List updatedEntries = list;
                    EntSpawnLevelAttachment.setData((ServerLevel)level, data2.copy(updatedEntries));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void serverTick(@NotNull MinecraftServer minecraftServer) {
        Intrinsics.checkNotNullParameter((Object)minecraftServer, (String)"minecraftServer");
        Iterable iterable = minecraftServer.getAllLevels();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllLevels(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapNotNullTo$iv$iv;
            EntSpawnLevelAttachment.Data data2;
            ServerLevel level = (ServerLevel)element$iv;
            boolean bl = false;
            if (level == null || !(!((Collection)(data2 = EntSpawnLevelAttachment.getData(level)).getEntries()).isEmpty())) continue;
            Iterable $this$mapNotNull$iv = data2.getEntries();
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                EntSpawnLevelAttachment.BlockEntry blockEntry;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                EntSpawnLevelAttachment.BlockEntry entry = (EntSpawnLevelAttachment.BlockEntry)element$iv$iv;
                boolean bl3 = false;
                int newTimer = entry.getResetTimer() - 1;
                if (entry.getCount() >= 24) {
                    INSTANCE.performSpawn(level, entry.getBlockPos(), entry.getState());
                    blockEntry = EntSpawnLevelAttachment.BlockEntry.copy$default(entry, null, null, 0, 6000, 3, null);
                } else {
                    blockEntry = newTimer > 0 ? EntSpawnLevelAttachment.BlockEntry.copy$default(entry, null, null, 0, newTimer, 7, null) : null;
                }
                if (blockEntry == null) continue;
                EntSpawnLevelAttachment.BlockEntry it$iv$iv = blockEntry;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List updatedEntries = (List)destination$iv$iv;
            if (Intrinsics.areEqual((Object)updatedEntries, data2.getEntries())) continue;
            EntSpawnLevelAttachment.setData(level, data2.copy(updatedEntries));
        }
    }

    private final void performSpawn(ServerLevel level, BlockPos blockPos, BlockState state) {
        block2: {
            EntEntity ent = (EntEntity)((EntityType)WitcheryEntityTypes.INSTANCE.getENT().get()).create((Level)level);
            EntEntity.Type variant = state.is((Block)WitcheryBlocks.INSTANCE.getHAWTHORN_LOG().get()) ? EntEntity.Type.HAWTHORN : (state.is((Block)WitcheryBlocks.INSTANCE.getALDER_LOG().get()) ? EntEntity.Type.ALDER : EntEntity.Type.ROWAN);
            EntEntity entEntity = ent;
            if (entEntity != null) {
                entEntity.setVariant(variant);
            }
            EntEntity entEntity2 = ent;
            if (entEntity2 != null) {
                entEntity2.moveTo((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5);
            }
            EntEntity entEntity3 = ent;
            if (entEntity3 == null) break block2;
            EntEntity it = entEntity3;
            boolean bl = false;
            level.addFreshEntity((Entity)it);
        }
    }
}

