/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.hud.HudPositionData;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.features.misc.HudPlayerAttachment;
import dev.sterner.witchery.network.SyncHudPositionsS2CPayload;
import dev.sterner.witchery.network.UpdateHudPositionsC2SPayload;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty1;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010\r\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"Ldev/sterner/witchery/features/misc/HudPlayerAttachment;", "", "<init>", "()V", "getData", "Ldev/sterner/witchery/features/misc/HudPlayerAttachment$Data;", "player", "Lnet/minecraft/world/entity/player/Player;", "setData", "", "data", "sync", "Lnet/minecraft/server/level/ServerPlayer;", "setHudPositions", "positions", "Ldev/sterner/witchery/client/hud/HudPositionData;", "Data", "witchery"})
public final class HudPlayerAttachment {
    @NotNull
    public static final HudPlayerAttachment INSTANCE = new HudPlayerAttachment();

    private HudPlayerAttachment() {
    }

    @JvmStatic
    @NotNull
    public static final Data getData(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = player.getData(WitcheryDataAttachments.getHUD_PLAYER_DATA_ATTACHMENT());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    @JvmStatic
    public static final void setData(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        player.setData(WitcheryDataAttachments.getHUD_PLAYER_DATA_ATTACHMENT(), (Object)data2);
        if (player.level().isClientSide) {
            PacketDistributor.sendToServer((CustomPacketPayload)new UpdateHudPositionsC2SPayload(data2.getHudPositions()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public final void sync(@NotNull ServerPlayer player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncHudPositionsS2CPayload(data2.getHudPositions()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void setHudPositions(@NotNull Player player, @NotNull HudPositionData positions) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)positions, (String)"positions");
        Data old = HudPlayerAttachment.getData(player);
        HudPlayerAttachment.setData(player, old.copy(positions));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0013"}, d2={"Ldev/sterner/witchery/features/misc/HudPlayerAttachment$Data;", "", "hudPositions", "Ldev/sterner/witchery/client/hud/HudPositionData;", "<init>", "(Ldev/sterner/witchery/client/hud/HudPositionData;)V", "getHudPositions", "()Ldev/sterner/witchery/client/hud/HudPositionData;", "setHudPositions", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private HudPositionData hudPositions;
        @NotNull
        private static final Codec<Data> CODEC;
        @NotNull
        private static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC;
        @NotNull
        private static final ResourceLocation ID;

        public Data(@NotNull HudPositionData hudPositions) {
            Intrinsics.checkNotNullParameter((Object)hudPositions, (String)"hudPositions");
            this.hudPositions = hudPositions;
        }

        public /* synthetic */ Data(HudPositionData hudPositionData, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                hudPositionData = new HudPositionData(null, null, null, null, 15, null);
            }
            this(hudPositionData);
        }

        @NotNull
        public final HudPositionData getHudPositions() {
            return this.hudPositions;
        }

        public final void setHudPositions(@NotNull HudPositionData hudPositionData) {
            Intrinsics.checkNotNullParameter((Object)hudPositionData, (String)"<set-?>");
            this.hudPositions = hudPositionData;
        }

        @NotNull
        public final HudPositionData component1() {
            return this.hudPositions;
        }

        @NotNull
        public final Data copy(@NotNull HudPositionData hudPositions) {
            Intrinsics.checkNotNullParameter((Object)hudPositions, (String)"hudPositions");
            return new Data(hudPositions);
        }

        public static /* synthetic */ Data copy$default(Data data2, HudPositionData hudPositionData, int n, Object object) {
            if ((n & 1) != 0) {
                hudPositionData = data2.hudPositions;
            }
            return data2.copy(hudPositionData);
        }

        @NotNull
        public String toString() {
            return "Data(hudPositions=" + this.hudPositions + ")";
        }

        public int hashCode() {
            return this.hudPositions.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            return Intrinsics.areEqual((Object)this.hudPositions, (Object)data2.hudPositions);
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)HudPositionData.Companion.getCODEC().fieldOf("hudPositions").forGetter(Data::CODEC$lambda$0$0)).apply((Applicative)instance, Data::new);
        }

        private static final HudPositionData CODEC$lambda$0$0(Data it) {
            return it.hudPositions;
        }

        private static final HudPositionData STREAM_CODEC$lambda$0(KMutableProperty1 $tmp0, Data p0) {
            return (HudPositionData)((Function1)$tmp0).invoke((Object)p0);
        }

        public Data() {
            this(null, 1, null);
        }

        static {
            Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
            StreamCodec streamCodec = StreamCodec.composite(HudPositionData.Companion.getSTREAM_CODEC(), arg_0 -> Data.STREAM_CODEC$lambda$0((KMutableProperty1)Companion.STREAM_CODEC.1.INSTANCE, arg_0), Data::new);
            Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
            STREAM_CODEC = streamCodec;
            ResourceLocation resourceLocation = Witchery.Companion.id("hud_player_data");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            ID = resourceLocation;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Ldev/sterner/witchery/features/misc/HudPlayerAttachment$Data$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/misc/HudPlayerAttachment$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final StreamCodec<RegistryFriendlyByteBuf, Data> getSTREAM_CODEC() {
                return STREAM_CODEC;
            }

            @NotNull
            public final ResourceLocation getID() {
                return ID;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

