/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.network.SyncUnderWaterS2CPayload;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/features/misc/UnderWaterBreathPlayerAttachment;", "", "<init>", "()V", "getData", "Ldev/sterner/witchery/features/misc/UnderWaterBreathPlayerAttachment$Data;", "player", "Lnet/minecraft/world/entity/player/Player;", "setData", "", "data", "sync", "tick", "Data", "witchery"})
public final class UnderWaterBreathPlayerAttachment {
    @NotNull
    public static final UnderWaterBreathPlayerAttachment INSTANCE = new UnderWaterBreathPlayerAttachment();

    private UnderWaterBreathPlayerAttachment() {
    }

    @JvmStatic
    @NotNull
    public static final Data getData(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = player.getData(WitcheryDataAttachments.getUNDER_WATER_PLAYER_DATA_ATTACHMENT());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    @JvmStatic
    public static final void setData(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        player.setData(WitcheryDataAttachments.getUNDER_WATER_PLAYER_DATA_ATTACHMENT(), (Object)data2);
        INSTANCE.sync(player, data2);
    }

    public final void sync(@NotNull Player player, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (player.level() instanceof ServerLevel) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)((Entity)player), (CustomPacketPayload)new SyncUnderWaterS2CPayload(player, data2), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public final void tick(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Data data2 = UnderWaterBreathPlayerAttachment.getData(player);
        if (data2.getDuration() > 0) {
            boolean isInWater;
            int newDuration = data2.getDuration() - 1;
            Data newData = new Data(newDuration, data2.getMaxDuration());
            UnderWaterBreathPlayerAttachment.setData(player, newData);
            if (newDuration % 20 == 0) {
                this.sync(player, newData);
            }
            if (newDuration <= 0) {
                Data clearedData = new Data(0, 0);
                UnderWaterBreathPlayerAttachment.setData(player, clearedData);
                this.sync(player, clearedData);
            }
            if (isInWater = player.isEyeInFluid(FluidTags.WATER)) {
                player.setAirSupply(player.getMaxAirSupply());
            } else {
                player.setAirSupply(player.getAirSupply() - 5);
                if (player.tickCount % 5 == 0) {
                    if (player.getAirSupply() <= -20) {
                        player.setAirSupply(0);
                        player.hurt(player.damageSources().drown(), 2.0f);
                    }
                    if ((double)player.getAirSupply() < (double)player.getMaxAirSupply() * 0.3 && player.level() instanceof ServerLevel) {
                        Level level = player.level();
                        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                        ServerLevel level2 = (ServerLevel)level;
                        level2.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ(), 1, 0.1, 0.1, 0.1, 0.05);
                    }
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\b\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Ldev/sterner/witchery/features/misc/UnderWaterBreathPlayerAttachment$Data;", "", "duration", "", "maxDuration", "<init>", "(II)V", "getDuration", "()I", "getMaxDuration", "setMaxDuration", "(I)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int duration;
        private int maxDuration;
        @NotNull
        private static final ResourceLocation ID;
        @NotNull
        private static final Codec<Data> CODEC;

        public Data(int duration, int maxDuration) {
            this.duration = duration;
            this.maxDuration = maxDuration;
        }

        public /* synthetic */ Data(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            this(n, n2);
        }

        public final int getDuration() {
            return this.duration;
        }

        public final int getMaxDuration() {
            return this.maxDuration;
        }

        public final void setMaxDuration(int n) {
            this.maxDuration = n;
        }

        public final int component1() {
            return this.duration;
        }

        public final int component2() {
            return this.maxDuration;
        }

        @NotNull
        public final Data copy(int duration, int maxDuration) {
            return new Data(duration, maxDuration);
        }

        public static /* synthetic */ Data copy$default(Data data2, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = data2.duration;
            }
            if ((n3 & 2) != 0) {
                n2 = data2.maxDuration;
            }
            return data2.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "Data(duration=" + this.duration + ", maxDuration=" + this.maxDuration + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.duration);
            result = result * 31 + Integer.hashCode(this.maxDuration);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            if (this.duration != data2.duration) {
                return false;
            }
            return this.maxDuration == data2.maxDuration;
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.INT.fieldOf("duration").forGetter(Data::CODEC$lambda$0$0), (App)Codec.INT.fieldOf("maxDuration").forGetter(Data::CODEC$lambda$0$1)).apply((Applicative)instance, Data::new);
        }

        private static final Integer CODEC$lambda$0$0(Data it) {
            return it.duration;
        }

        private static final Integer CODEC$lambda$0$1(Data it) {
            return it.maxDuration;
        }

        public Data() {
            this(0, 0, 3, null);
        }

        static {
            ResourceLocation resourceLocation = Witchery.Companion.id("player_under_water");
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
            ID = resourceLocation;
            Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/features/misc/UnderWaterBreathPlayerAttachment$Data$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/misc/UnderWaterBreathPlayerAttachment$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ResourceLocation getID() {
                return ID;
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

