/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.poppet;

import dev.sterner.witchery.core.api.PoppetLocation;
import dev.sterner.witchery.core.api.PoppetUsage;
import dev.sterner.witchery.core.api.WitcheryApi;
import dev.sterner.witchery.core.api.interfaces.PoppetType;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.core.registry.WitcheryPoppetRegistry;
import dev.sterner.witchery.features.misc.AccessoryHandler;
import dev.sterner.witchery.features.poppet.CorruptPoppetPlayerAttachment;
import dev.sterner.witchery.features.poppet.DeathProtectionPoppet;
import dev.sterner.witchery.features.poppet.HungerProtectionPoppet;
import dev.sterner.witchery.features.poppet.PoppetLevelAttachment;
import dev.sterner.witchery.features.poppet.VampiricPoppet;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\tJ.\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u001a\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00172\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0002J&\u0010!\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0006\u0012\u0004\u0018\u00010#0\"2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010$\u001a\u0004\u0018\u00010\u001c2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0017J\u0018\u0010(\u001a\u0004\u0018\u00010\u00072\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0017\u00a8\u0006)"}, d2={"Ldev/sterner/witchery/features/poppet/PoppetHandler;", "", "<init>", "()V", "onLivingHurt", "", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "remainingDamage", "onLivingDeath", "", "event", "Lnet/neoforged/neoforge/event/entity/living/LivingDeathEvent;", "livingEntity", "activatePoppet", "", "owner", "poppetType", "Ldev/sterner/witchery/core/api/interfaces/PoppetType;", "source", "findAndHurtPoppet", "Lnet/minecraft/world/item/ItemStack;", "damagePoppet", "", "handleVoodooPoppet", "attacker", "Lnet/minecraft/world/entity/player/Player;", "victim", "damage", "isPoppetBoundToLiving", "itemStack", "findPoppet", "Lkotlin/Pair;", "Ldev/sterner/witchery/core/api/PoppetLocation;", "getBoundPlayer", "level", "Lnet/minecraft/world/level/Level;", "poppet", "getBoundEntity", "witchery"})
@SourceDebugExtension(value={"SMAP\nPoppetHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PoppetHandler.kt\ndev/sterner/witchery/features/poppet/PoppetHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,407:1\n808#2,11:408\n295#2,2:419\n*S KotlinDebug\n*F\n+ 1 PoppetHandler.kt\ndev/sterner/witchery/features/poppet/PoppetHandler\n*L\n401#1:408,11\n402#1:419,2\n*E\n"})
public final class PoppetHandler {
    @NotNull
    public static final PoppetHandler INSTANCE = new PoppetHandler();

    private PoppetHandler() {
    }

    public final float onLivingHurt(@NotNull LivingEntity entity, @NotNull DamageSource damageSource, float remainingDamage) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        if (damageSource.is(DamageTypes.STARVE)) {
            HungerProtectionPoppet hungerPoppetType = (HungerProtectionPoppet)WitcheryPoppetRegistry.INSTANCE.getHUNGER_PROTECTION().get();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)hungerPoppetType);
            if (INSTANCE.activatePoppet(entity, hungerPoppetType, damageSource)) {
                return 0.0f;
            }
        }
        float modifiedDamage = 0.0f;
        modifiedDamage = remainingDamage;
        VampiricPoppet vampiricPoppet = (VampiricPoppet)WitcheryPoppetRegistry.INSTANCE.getVAMPIRIC().get();
        boolean bl = false;
        modifiedDamage = vampiricPoppet.handleDamage(entity, damageSource, modifiedDamage);
        if (damageSource.getEntity() instanceof Player) {
            Entity entity2 = damageSource.getEntity();
            Intrinsics.checkNotNull((Object)entity2, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
            Player attacker = (Player)entity2;
            float voodooBonusDamage = this.handleVoodooPoppet(attacker, entity, modifiedDamage);
            modifiedDamage += voodooBonusDamage;
        }
        return modifiedDamage;
    }

    public final void onLivingDeath(@NotNull LivingDeathEvent event, @Nullable LivingEntity livingEntity, @Nullable DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(livingEntity instanceof Player) || WitcheryApi.INSTANCE.isInSpiritWorld((Player)livingEntity)) {
            return;
        }
        DeathProtectionPoppet deathPoppetType = (DeathProtectionPoppet)WitcheryPoppetRegistry.INSTANCE.getDEATH_PROTECTION().get();
        boolean bl = false;
        CorruptPoppetPlayerAttachment.Data corruptData = CorruptPoppetPlayerAttachment.getData((Player)livingEntity);
        boolean isCorrupted = CollectionsKt.contains((Iterable)corruptData.getCorruptedPoppets(), (Object)deathPoppetType.getRegistryId());
        if (isCorrupted) {
            Intrinsics.checkNotNull((Object)deathPoppetType);
            if (INSTANCE.activatePoppet(livingEntity, deathPoppetType, damageSource)) {
                return;
            }
        } else {
            Intrinsics.checkNotNull((Object)deathPoppetType);
            if (INSTANCE.activatePoppet(livingEntity, deathPoppetType, damageSource)) {
                ((Player)livingEntity).setHealth(((Player)livingEntity).getMaxHealth() * 0.5f);
                ((Player)livingEntity).invulnerableTime = 60;
                ((Player)livingEntity).removeAllEffects();
                ((Player)livingEntity).addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
                ((Player)livingEntity).addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
                ((Player)livingEntity).addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
                if (((Player)livingEntity).level() instanceof ServerLevel) {
                    Level level = ((Player)livingEntity).level();
                    Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.ENCHANTED_HIT, ((Player)livingEntity).getX(), ((Player)livingEntity).getY() + (double)((Player)livingEntity).getBbHeight() * 0.5, ((Player)livingEntity).getZ(), 20, 0.3, 0.3, 0.3, 0.1);
                }
                event.setCanceled(true);
                return;
            }
        }
    }

    public final boolean activatePoppet(@NotNull LivingEntity owner, @NotNull PoppetType poppetType, @Nullable DamageSource source) {
        CorruptPoppetPlayerAttachment.Data corruptData;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)poppetType, (String)"poppetType");
        if (!poppetType.isValidFor(owner, source)) {
            return false;
        }
        int damageAmount = poppetType.getDurabilityDamage(PoppetUsage.PROTECTION);
        if (owner instanceof Player && CollectionsKt.contains((Iterable)(corruptData = CorruptPoppetPlayerAttachment.getData((Player)owner)).getCorruptedPoppets(), (Object)poppetType.getRegistryId())) {
            ItemStack foundPoppet = this.findAndHurtPoppet(owner, poppetType, source, damageAmount);
            if (foundPoppet == null) {
                return false;
            }
            if (owner.level() instanceof ServerLevel) {
                Level level = owner.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.WITCH, ((Player)owner).getX(), ((Player)owner).getY() + (double)((Player)owner).getBbHeight() * 0.5, ((Player)owner).getZ(), 15, 0.3, 0.3, 0.3, 0.05);
            }
            return poppetType.onCorruptedActivate(owner, source);
        }
        ItemStack foundPoppet = this.findAndHurtPoppet(owner, poppetType, source, damageAmount);
        if (foundPoppet == null) {
            return false;
        }
        if (owner.level() instanceof ServerLevel) {
            Level level = owner.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.ENCHANTED_HIT, owner.getX(), owner.getY() + (double)owner.getBbHeight() * 0.5, owner.getZ(), 10, 0.3, 0.3, 0.3, 0.1);
        }
        return poppetType.onActivate(owner, source);
    }

    private final ItemStack findAndHurtPoppet(LivingEntity owner, PoppetType poppetType, DamageSource source, int damagePoppet) {
        if (owner instanceof Player) {
            Triple<Boolean, ItemStack, Integer> triple = AccessoryHandler.INSTANCE.checkPoppet(owner, poppetType.getItem());
            boolean accessoryFound = (Boolean)triple.component1();
            ItemStack accessoryItem = (ItemStack)triple.component2();
            Integer slot = (Integer)triple.component3();
            if (accessoryFound && accessoryItem != null && slot != null && this.isPoppetBoundToLiving(accessoryItem, owner)) {
                if (damagePoppet > 0 && owner.level() instanceof ServerLevel) {
                    Level level = owner.level();
                    Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    ServerLevel level2 = (ServerLevel)level;
                    accessoryItem.hurtAndBreak(damagePoppet, level2, owner, arg_0 -> PoppetHandler.findAndHurtPoppet$lambda$0(owner, poppetType, arg_0));
                }
                return accessoryItem;
            }
        }
        if (owner instanceof Player) {
            for (InteractionHand hand : EntriesMappings.entries$0) {
                ItemStack handItem = owner.getItemInHand(hand);
                if (!handItem.is(poppetType.getItem())) continue;
                Intrinsics.checkNotNull((Object)handItem);
                if (!this.isPoppetBoundToLiving(handItem, owner)) continue;
                if (damagePoppet > 0 && owner.level() instanceof ServerLevel) {
                    Level level = owner.level();
                    Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    handItem.hurtAndBreak(damagePoppet, (ServerLevel)level, owner, arg_0 -> PoppetHandler.findAndHurtPoppet$lambda$1(owner, hand, arg_0));
                }
                return handItem;
            }
            int hand = ((Player)owner).getInventory().getContainerSize();
            for (int i = 0; i < hand; ++i) {
                ItemStack invItem = ((Player)owner).getInventory().getItem(i);
                if (!invItem.is(poppetType.getItem())) continue;
                Intrinsics.checkNotNull((Object)invItem);
                if (!this.isPoppetBoundToLiving(invItem, owner)) continue;
                if (damagePoppet > 0 && owner.level() instanceof ServerLevel) {
                    Level level = owner.level();
                    Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    invItem.hurtAndBreak(damagePoppet, (ServerLevel)level, owner, arg_0 -> PoppetHandler.findAndHurtPoppet$lambda$2(owner, i, arg_0));
                }
                return invItem;
            }
        }
        if (owner.level() instanceof ServerLevel) {
            Object v4;
            PoppetLevelAttachment.PoppetData poppetData;
            ServerLevel level;
            block12: {
                Level level3 = owner.level();
                Intrinsics.checkNotNull((Object)level3, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                level = (ServerLevel)level3;
                poppetData = PoppetLevelAttachment.getPoppetData(level);
                Iterable iterable = poppetData.getPoppetDataMap();
                for (Object t : iterable) {
                    PoppetLevelAttachment.PoppetData.Data it = (PoppetLevelAttachment.PoppetData.Data)t;
                    boolean bl = false;
                    if (!(it.getPoppetItemStack().is(poppetType.getItem()) && INSTANCE.isPoppetBoundToLiving(it.getPoppetItemStack(), owner))) continue;
                    v4 = t;
                    break block12;
                }
                v4 = null;
            }
            PoppetLevelAttachment.PoppetData.Data blockPoppet = v4;
            if (blockPoppet != null) {
                if (damagePoppet > 0) {
                    blockPoppet.getPoppetItemStack().hurtAndBreak(damagePoppet, level, owner, arg_0 -> PoppetHandler.findAndHurtPoppet$lambda$4(poppetData, blockPoppet, arg_0));
                }
                PoppetLevelAttachment.INSTANCE.updatePoppetItem(level, blockPoppet.getBlockPos(), blockPoppet.getPoppetItemStack());
                return blockPoppet.getPoppetItemStack();
            }
        }
        return null;
    }

    static /* synthetic */ ItemStack findAndHurtPoppet$default(PoppetHandler poppetHandler, LivingEntity livingEntity, PoppetType poppetType, DamageSource damageSource, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        return poppetHandler.findAndHurtPoppet(livingEntity, poppetType, damageSource, n);
    }

    /*
     * Unable to fully structure code
     */
    private final float handleVoodooPoppet(Player attacker, LivingEntity victim, float damage) {
        block6: {
            v0 = WitcheryPoppetRegistry.INSTANCE.getVOODOO().get();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"get(...)");
            var4_4 = this.findPoppet(victim, (PoppetType)v0);
            voodooPoppet = (ItemStack)var4_4.component1();
            location = (PoppetLocation)var4_4.component2();
            if (voodooPoppet == null || location == null) break block6;
            damageMultiplier = victim instanceof Player != false && WitcheryApi.INSTANCE.isWitchy((Player)victim) == false ? 0.15f : 0.5f;
            bonusDamage = damage * damageMultiplier;
            durabilityDamage = RangesKt.coerceAtLeast((int)(voodooPoppet.getMaxDamage() / 10), (int)1);
            switch (WhenMappings.$EnumSwitchMapping$0[location.ordinal()]) {
                case 1: {
                    if (!(attacker.level() instanceof ServerLevel)) break;
                    v1 = attacker.level();
                    Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    voodooPoppet.hurtAndBreak(durabilityDamage, (ServerLevel)v1, null, (Consumer<Item>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, handleVoodooPoppet$lambda$0(net.minecraft.world.entity.player.Player net.minecraft.world.item.ItemStack net.minecraft.world.item.Item ), (Lnet/minecraft/world/item/Item;)V)((Player)attacker, (ItemStack)voodooPoppet));
                    break;
                }
                case 2: {
                    if (!(attacker.level() instanceof ServerLevel)) break;
                    v2 = attacker.level();
                    Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    voodooPoppet.hurtAndBreak(durabilityDamage, (ServerLevel)v2, null, (Consumer<Item>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, handleVoodooPoppet$lambda$1(net.minecraft.world.item.ItemStack net.minecraft.world.item.Item ), (Lnet/minecraft/world/item/Item;)V)((ItemStack)voodooPoppet));
                    break;
                }
                case 3: {
                    if (!(attacker.level() instanceof ServerLevel)) break;
                    v3 = attacker.level();
                    Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    level = (ServerLevel)v3;
                    poppetData = PoppetLevelAttachment.getPoppetData(level);
                    var13_12 = poppetData.getPoppetDataMap();
                    for (T var15_14 : var13_12) {
                        it = (PoppetLevelAttachment.PoppetData.Data)var15_14;
                        $i$a$-find-PoppetHandler$handleVoodooPoppet$blockPoppet$1 = false;
                        if (!(Intrinsics.areEqual((Object)it.getPoppetItemStack(), (Object)voodooPoppet) != false && PoppetHandler.INSTANCE.isPoppetBoundToLiving(it.getPoppetItemStack(), victim) != false)) continue;
                        v4 = var15_14;
                        ** GOTO lbl37
                    }
                    v4 = null;
lbl37:
                    // 2 sources

                    blockPoppet = v4;
                    if (blockPoppet == null) break;
                    blockPoppet.getPoppetItemStack().hurtAndBreak(durabilityDamage, level, null, (Consumer<Item>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, handleVoodooPoppet$lambda$3(dev.sterner.witchery.features.poppet.PoppetLevelAttachment$PoppetData$Data net.minecraft.world.item.Item ), (Lnet/minecraft/world/item/Item;)V)((PoppetLevelAttachment.PoppetData.Data)blockPoppet));
                    PoppetLevelAttachment.INSTANCE.updatePoppetItem(level, blockPoppet.getBlockPos(), blockPoppet.getPoppetItemStack());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return bonusDamage;
        }
        return 0.0f;
    }

    private final boolean isPoppetBoundToLiving(ItemStack itemStack, LivingEntity livingEntity) {
        boolean bl;
        if (livingEntity == null) {
            return false;
        }
        if (livingEntity instanceof Player) {
            ResolvableProfile profile;
            ResolvableProfile resolvableProfile = profile = (ResolvableProfile)itemStack.get(DataComponents.PROFILE);
            bl = Intrinsics.areEqual((Object)(resolvableProfile != null ? resolvableProfile.gameProfile() : null), (Object)((Player)livingEntity).getGameProfile());
        } else {
            String entityId = (String)itemStack.get((DataComponentType)WitcheryDataComponents.INSTANCE.getENTITY_ID_COMPONENT().get());
            bl = Intrinsics.areEqual((Object)entityId, (Object)livingEntity.getStringUUID());
        }
        return bl;
    }

    @NotNull
    public final Pair<ItemStack, PoppetLocation> findPoppet(@NotNull LivingEntity owner, @NotNull PoppetType poppetType) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)poppetType, (String)"poppetType");
        Triple<Boolean, ItemStack, Integer> triple = AccessoryHandler.INSTANCE.checkPoppet(owner, poppetType.getItem());
        boolean accessoryFound = (Boolean)triple.component1();
        ItemStack accessoryItem = (ItemStack)triple.component2();
        Integer slot = (Integer)triple.component3();
        if (accessoryFound && accessoryItem != null && this.isPoppetBoundToLiving(accessoryItem, owner)) {
            return new Pair((Object)accessoryItem, (Object)PoppetLocation.ACCESSORY);
        }
        if (owner instanceof Player) {
            for (InteractionHand hand : EntriesMappings.entries$0) {
                ItemStack handItem = owner.getItemInHand(hand);
                if (!handItem.is(poppetType.getItem())) continue;
                Intrinsics.checkNotNull((Object)handItem);
                if (!this.isPoppetBoundToLiving(handItem, owner)) continue;
                return new Pair((Object)handItem, (Object)PoppetLocation.INVENTORY);
            }
            Iterator iterator = ((Player)owner).getInventory().items.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                ItemStack item = (ItemStack)iterator2.next();
                if (!item.is(poppetType.getItem())) continue;
                Intrinsics.checkNotNull((Object)item);
                if (!this.isPoppetBoundToLiving(item, owner)) continue;
                return new Pair((Object)item, (Object)PoppetLocation.INVENTORY);
            }
        }
        if (owner.level() instanceof ServerLevel) {
            Object v2;
            block7: {
                Level level = owner.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel level2 = (ServerLevel)level;
                PoppetLevelAttachment.PoppetData poppetData = PoppetLevelAttachment.getPoppetData(level2);
                Iterable iterable = poppetData.getPoppetDataMap();
                for (Object t : iterable) {
                    PoppetLevelAttachment.PoppetData.Data it = (PoppetLevelAttachment.PoppetData.Data)t;
                    boolean bl = false;
                    if (!(it.getPoppetItemStack().is(poppetType.getItem()) && INSTANCE.isPoppetBoundToLiving(it.getPoppetItemStack(), owner))) continue;
                    v2 = t;
                    break block7;
                }
                v2 = null;
            }
            PoppetLevelAttachment.PoppetData.Data blockPoppet = v2;
            if (blockPoppet != null) {
                return new Pair((Object)blockPoppet.getPoppetItemStack(), (Object)PoppetLocation.WORLD);
            }
        }
        return new Pair(null, null);
    }

    @Nullable
    public final Player getBoundPlayer(@NotNull Level level, @NotNull ItemStack poppet) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)poppet, (String)"poppet");
        ResolvableProfile profile = (ResolvableProfile)poppet.get(DataComponents.PROFILE);
        if (profile != null && level instanceof ServerLevel) {
            return (Player)((ServerLevel)level).getServer().getPlayerList().getPlayer(profile.gameProfile().getId());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final LivingEntity getBoundEntity(@NotNull Level level, @NotNull ItemStack poppet) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)poppet, (String)"poppet");
        if (level instanceof ServerLevel && poppet.has((DataComponentType)WitcheryDataComponents.INSTANCE.getENTITY_ID_COMPONENT().get())) {
            Object v2;
            block6: {
                void $this$firstOrNull$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                Object object;
                String string = (String)poppet.get((DataComponentType)WitcheryDataComponents.INSTANCE.getENTITY_ID_COMPONENT().get());
                if (string == null) {
                    return null;
                }
                String entityIdStr = string;
                try {
                    object = UUID.fromString(entityIdStr);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
                UUID uuid = object;
                Iterable iterable = ((ServerLevel)level).getAllEntities();
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getAllEntities(...)");
                object = iterable;
                boolean $i$f$filterIsInstance = false;
                Iterator iterator = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof LivingEntity)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    LivingEntity it = (LivingEntity)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getUUID(), (Object)uuid)) continue;
                    v2 = element$iv;
                    break block6;
                }
                v2 = null;
            }
            return v2;
        }
        return null;
    }

    private static final void findAndHurtPoppet$lambda$0(LivingEntity $owner, PoppetType $poppetType, Item it) {
        AccessoryHandler.INSTANCE.removeAccessory($owner, $poppetType.getItem());
    }

    private static final void findAndHurtPoppet$lambda$1(LivingEntity $owner, InteractionHand $hand, Item it) {
        $owner.setItemInHand($hand, ItemStack.EMPTY);
    }

    private static final void findAndHurtPoppet$lambda$2(LivingEntity $owner, int $i, Item it) {
        ((Player)$owner).getInventory().setItem($i, ItemStack.EMPTY);
    }

    private static final void findAndHurtPoppet$lambda$4(PoppetLevelAttachment.PoppetData $poppetData, PoppetLevelAttachment.PoppetData.Data $blockPoppet, Item it) {
        $poppetData.getPoppetDataMap().remove($blockPoppet);
    }

    private static final void handleVoodooPoppet$lambda$0(Player $attacker, ItemStack $voodooPoppet, Item item) {
        LivingEntity livingEntity = (LivingEntity)$attacker;
        Item item2 = $voodooPoppet.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)item2, (String)"getItem(...)");
        AccessoryHandler.INSTANCE.checkPoppet(livingEntity, item2);
    }

    private static final void handleVoodooPoppet$lambda$1(ItemStack $voodooPoppet, Item item) {
        $voodooPoppet.shrink(1);
    }

    private static final void handleVoodooPoppet$lambda$3(PoppetLevelAttachment.PoppetData.Data $blockPoppet, Item item) {
        $blockPoppet.getPoppetItemStack().shrink(1);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<InteractionHand> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])InteractionHand.values()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PoppetLocation.values().length];
            try {
                nArray[PoppetLocation.ACCESSORY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PoppetLocation.INVENTORY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PoppetLocation.WORLD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

