/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.possession;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.core.api.interfaces.DisableableAiController;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.mixin.possession.MobAccessor;
import dev.sterner.witchery.network.SyncAIEntityToggleS2CPayload;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tJ*\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0007J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0013H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Ldev/sterner/witchery/features/possession/EntityAiToggle;", "", "<init>", "()V", "POSSESSION_MECHANISM_ID", "Lnet/minecraft/resources/ResourceLocation;", "getPOSSESSION_MECHANISM_ID", "()Lnet/minecraft/resources/ResourceLocation;", "getEntityToggle", "Ldev/sterner/witchery/features/possession/EntityAiToggle$Data;", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "setEntityToggle", "", "data", "toggleAi", "entity", "inhibitorId", "inhibit", "", "persistent", "refresh", "nowDisabled", "Data", "witchery"})
public final class EntityAiToggle {
    @NotNull
    public static final EntityAiToggle INSTANCE = new EntityAiToggle();
    @NotNull
    private static final ResourceLocation POSSESSION_MECHANISM_ID;

    private EntityAiToggle() {
    }

    @NotNull
    public final ResourceLocation getPOSSESSION_MECHANISM_ID() {
        return POSSESSION_MECHANISM_ID;
    }

    @NotNull
    public final Data getEntityToggle(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Object object = livingEntity.getData(WitcheryDataAttachments.getENTITY_TOGGLE_DATA_ATTACHMENT());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        return (Data)object;
    }

    public final void setEntityToggle(@NotNull LivingEntity livingEntity, @NotNull Data data2) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        livingEntity.setData(WitcheryDataAttachments.getENTITY_TOGGLE_DATA_ATTACHMENT(), (Object)data2);
        if (livingEntity.level() instanceof ServerLevel) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)((Entity)livingEntity), (CustomPacketPayload)new SyncAIEntityToggleS2CPayload(livingEntity.getId(), data2), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @JvmStatic
    public static final void toggleAi(@NotNull LivingEntity entity, @Nullable ResourceLocation inhibitorId, boolean inhibit, boolean persistent) {
        boolean nowDisabled;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Data toggle = INSTANCE.getEntityToggle(entity);
        boolean wasDisabled = toggle.isAiDisabled();
        boolean bl = inhibit ? toggle.getInhibitors().put((Object)inhibitorId, persistent) : toggle.getInhibitors().removeBoolean((Object)inhibitorId);
        boolean bl2 = nowDisabled = !toggle.getInhibitors().isEmpty();
        if (wasDisabled != nowDisabled) {
            INSTANCE.refresh(entity, nowDisabled);
        }
    }

    private final void refresh(LivingEntity entity, boolean nowDisabled) {
        Data toggle = this.getEntityToggle(entity);
        toggle.setAiDisabled(nowDisabled);
        Brain brain = entity.getBrain();
        Intrinsics.checkNotNull((Object)brain, (String)"null cannot be cast to non-null type dev.sterner.witchery.core.api.interfaces.DisableableAiController");
        ((DisableableAiController)brain).witchery$setDisabled(nowDisabled);
        if (entity instanceof MobAccessor) {
            GoalSelector goalSelector = ((MobAccessor)entity).getGoalSelector();
            Intrinsics.checkNotNull((Object)goalSelector, (String)"null cannot be cast to non-null type dev.sterner.witchery.core.api.interfaces.DisableableAiController");
            ((DisableableAiController)goalSelector).witchery$setDisabled(nowDisabled);
            GoalSelector goalSelector2 = ((MobAccessor)entity).getTargetSelector();
            Intrinsics.checkNotNull((Object)goalSelector2, (String)"null cannot be cast to non-null type dev.sterner.witchery.core.api.interfaces.DisableableAiController");
            ((DisableableAiController)goalSelector2).witchery$setDisabled(nowDisabled);
            PathNavigation pathNavigation = ((MobAccessor)entity).witchery$getNavigation();
            Intrinsics.checkNotNull((Object)pathNavigation, (String)"null cannot be cast to non-null type dev.sterner.witchery.core.api.interfaces.DisableableAiController");
            ((DisableableAiController)pathNavigation).witchery$setDisabled(nowDisabled);
        }
    }

    static {
        ResourceLocation resourceLocation = Witchery.Companion.id("possession");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"id(...)");
        POSSESSION_MECHANISM_ID = resourceLocation;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B!\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Ldev/sterner/witchery/features/possession/EntityAiToggle$Data;", "", "isAiDisabled", "", "inhibitors", "Lit/unimi/dsi/fastutil/objects/Object2BooleanMap;", "Lnet/minecraft/resources/ResourceLocation;", "<init>", "(ZLit/unimi/dsi/fastutil/objects/Object2BooleanMap;)V", "()Z", "setAiDisabled", "(Z)V", "getInhibitors", "()Lit/unimi/dsi/fastutil/objects/Object2BooleanMap;", "setInhibitors", "(Lit/unimi/dsi/fastutil/objects/Object2BooleanMap;)V", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "witchery"})
    public static final class Data {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private boolean isAiDisabled;
        @NotNull
        private Object2BooleanMap<ResourceLocation> inhibitors;
        @NotNull
        private static final Codec<Data> CODEC;

        public Data(boolean isAiDisabled, @NotNull Object2BooleanMap<ResourceLocation> inhibitors) {
            Intrinsics.checkNotNullParameter(inhibitors, (String)"inhibitors");
            this.isAiDisabled = isAiDisabled;
            this.inhibitors = inhibitors;
        }

        public /* synthetic */ Data(boolean bl, Object2BooleanMap object2BooleanMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                object2BooleanMap = (Object2BooleanMap)new Object2BooleanOpenHashMap();
            }
            this(bl, (Object2BooleanMap<ResourceLocation>)object2BooleanMap);
        }

        public final boolean isAiDisabled() {
            return this.isAiDisabled;
        }

        public final void setAiDisabled(boolean bl) {
            this.isAiDisabled = bl;
        }

        @NotNull
        public final Object2BooleanMap<ResourceLocation> getInhibitors() {
            return this.inhibitors;
        }

        public final void setInhibitors(@NotNull Object2BooleanMap<ResourceLocation> object2BooleanMap) {
            Intrinsics.checkNotNullParameter(object2BooleanMap, (String)"<set-?>");
            this.inhibitors = object2BooleanMap;
        }

        public final boolean component1() {
            return this.isAiDisabled;
        }

        @NotNull
        public final Object2BooleanMap<ResourceLocation> component2() {
            return this.inhibitors;
        }

        @NotNull
        public final Data copy(boolean isAiDisabled, @NotNull Object2BooleanMap<ResourceLocation> inhibitors) {
            Intrinsics.checkNotNullParameter(inhibitors, (String)"inhibitors");
            return new Data(isAiDisabled, inhibitors);
        }

        public static /* synthetic */ Data copy$default(Data data2, boolean bl, Object2BooleanMap object2BooleanMap, int n, Object object) {
            if ((n & 1) != 0) {
                bl = data2.isAiDisabled;
            }
            if ((n & 2) != 0) {
                object2BooleanMap = data2.inhibitors;
            }
            return data2.copy(bl, object2BooleanMap);
        }

        @NotNull
        public String toString() {
            return "Data(isAiDisabled=" + this.isAiDisabled + ", inhibitors=" + this.inhibitors + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.isAiDisabled);
            result = result * 31 + this.inhibitors.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            if (this.isAiDisabled != data2.isAiDisabled) {
                return false;
            }
            return Intrinsics.areEqual(this.inhibitors, data2.inhibitors);
        }

        private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Codec.BOOL.fieldOf("isAiDisabled").forGetter(Data::CODEC$lambda$0$0), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)((Codec)Codec.BOOL)).fieldOf("inhibitors").forGetter(Data::CODEC$lambda$0$1)).apply((Applicative)instance, Data::CODEC$lambda$0$2);
        }

        private static final Boolean CODEC$lambda$0$0(Data it) {
            return it.isAiDisabled;
        }

        private static final Map CODEC$lambda$0$1(Data it) {
            return (Map)it.inhibitors;
        }

        private static final Data CODEC$lambda$0$2(Boolean isAiDisabled, Map inhibitorsMap) {
            Object2BooleanOpenHashMap fastUtilMap = new Object2BooleanOpenHashMap();
            fastUtilMap.putAll(inhibitorsMap);
            Intrinsics.checkNotNull((Object)isAiDisabled);
            return new Data(isAiDisabled, (Object2BooleanMap<ResourceLocation>)((Object2BooleanMap)fastUtilMap));
        }

        public Data() {
            this(false, null, 3, null);
        }

        static {
            Codec codec = RecordCodecBuilder.create(Data::CODEC$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
            CODEC = codec;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/features/possession/EntityAiToggle$Data$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/sterner/witchery/features/possession/EntityAiToggle$Data;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "witchery"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Codec<Data> getCODEC() {
                return CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

