/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.ritual;

import dev.sterner.witchery.content.block.ritual.GoldenChalkBlockEntity;
import dev.sterner.witchery.core.api.Ritual;
import dev.sterner.witchery.core.registry.WitcheryDataAttachments;
import dev.sterner.witchery.features.petrification.PetrificationHandler;
import dev.sterner.witchery.features.petrification.PetrifiedEntityAttachment;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u000f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\tH\u0002\u00a8\u0006\u0017"}, d2={"Ldev/sterner/witchery/features/ritual/PetrificationRitual;", "Ldev/sterner/witchery/core/api/Ritual;", "<init>", "()V", "onStartRitual", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "goldenChalkBlockEntity", "Ldev/sterner/witchery/content/block/ritual/GoldenChalkBlockEntity;", "onTickRitual", "", "pos", "onEndRitual", "spawnPetrificationEffects", "Lnet/minecraft/server/level/ServerLevel;", "entities", "", "Lnet/minecraft/world/entity/LivingEntity;", "spawnCompletionEffects", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nPetrificationRitual.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PetrificationRitual.kt\ndev/sterner/witchery/features/ritual/PetrificationRitual\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1869#2,2:102\n1869#2,2:104\n1869#2,2:106\n*S KotlinDebug\n*F\n+ 1 PetrificationRitual.kt\ndev/sterner/witchery/features/ritual/PetrificationRitual\n*L\n37#1:102,2\n57#1:104,2\n77#1:106,2\n*E\n"})
public final class PetrificationRitual
extends Ritual {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double RITUAL_RADIUS = 10.0;
    private static final int PETRIFICATION_DURATION = 1200;

    public PetrificationRitual() {
        super("petrification");
    }

    @Override
    public boolean onStartRitual(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull GoldenChalkBlockEntity goldenChalkBlockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)goldenChalkBlockEntity, (String)"goldenChalkBlockEntity");
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        AABB box = AABB.ofSize((Vec3)blockPos.getCenter(), (double)20.0, (double)20.0, (double)20.0);
        List entities = level.getEntitiesOfClass(LivingEntity.class, box, arg_0 -> PetrificationRitual.onStartRitual$lambda$1(PetrificationRitual::onStartRitual$lambda$0, arg_0));
        if (entities.isEmpty()) {
            return false;
        }
        Intrinsics.checkNotNull((Object)entities);
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LivingEntity entity = (LivingEntity)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entity);
            PetrificationHandler.INSTANCE.petrify(entity, 1200);
        }
        this.spawnPetrificationEffects((ServerLevel)level, blockPos, entities);
        return true;
    }

    @Override
    public void onTickRitual(@NotNull Level level, @NotNull BlockPos pos, @NotNull GoldenChalkBlockEntity goldenChalkBlockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)goldenChalkBlockEntity, (String)"goldenChalkBlockEntity");
        if (!(level instanceof ServerLevel)) {
            return;
        }
        if (((ServerLevel)level).getGameTime() % (long)10 == 0L) {
            AABB box = AABB.ofSize((Vec3)pos.getCenter(), (double)20.0, (double)20.0, (double)20.0);
            List entities = level.getEntitiesOfClass(LivingEntity.class, box);
            Intrinsics.checkNotNull((Object)entities);
            Iterable $this$forEach$iv = entities;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LivingEntity entity = (LivingEntity)element$iv;
                boolean bl = false;
                PetrifiedEntityAttachment.Data data2 = (PetrifiedEntityAttachment.Data)entity.getData(WitcheryDataAttachments.getPETRIFIED_ENTITY());
                if (!data2.isPetrified()) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                Intrinsics.checkNotNull((Object)entity);
                PetrificationHandler.INSTANCE.spawnPetrifiedParticles(serverLevel, entity);
            }
        }
    }

    @Override
    public void onEndRitual(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull GoldenChalkBlockEntity goldenChalkBlockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)goldenChalkBlockEntity, (String)"goldenChalkBlockEntity");
        if (level instanceof ServerLevel) {
            this.spawnCompletionEffects((ServerLevel)level, blockPos);
        }
    }

    private final void spawnPetrificationEffects(ServerLevel level, BlockPos pos, List<? extends LivingEntity> entities) {
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LivingEntity entity = (LivingEntity)element$iv;
            boolean bl = false;
            Vec3 vec3 = pos.getCenter();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
            Vec3 vec32 = entity.position();
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"position(...)");
            PetrificationHandler.INSTANCE.spawnPetrificationWave(level, vec3, vec32);
            PetrificationHandler.INSTANCE.spawnTransformationParticles(level, entity);
        }
    }

    private final void spawnCompletionEffects(ServerLevel level, BlockPos pos) {
        Vec3 center = pos.getCenter();
        for (int i = 0; i < 21; ++i) {
            double angle = (double)i / 20.0 * Math.PI * (double)2;
            double x = center.x + Math.cos(angle) * 10.0;
            double z = center.z + Math.sin(angle) * 10.0;
            level.sendParticles((ParticleOptions)ParticleTypes.END_ROD, x, center.y + 1.0, z, 5, 0.1, 0.5, 0.1, 0.02);
        }
    }

    private static final boolean onStartRitual$lambda$0(LivingEntity entity) {
        return entity != null && entity.isAlive() && !entity.isSpectator();
    }

    private static final boolean onStartRitual$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldev/sterner/witchery/features/ritual/PetrificationRitual$Companion;", "", "<init>", "()V", "RITUAL_RADIUS", "", "PETRIFICATION_DURATION", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

