/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.ritual;

import dev.sterner.witchery.content.block.ritual.GoldenChalkBlockEntity;
import dev.sterner.witchery.core.api.Ritual;
import dev.sterner.witchery.core.registry.WitcheryTags;
import dev.sterner.witchery.features.affliction.AfflictionTypes;
import dev.sterner.witchery.features.affliction.ability.AfflictionAbilityHandler;
import dev.sterner.witchery.features.affliction.lich.LichdomAbility;
import dev.sterner.witchery.features.affliction.lich.LichdomSpecificEventHandler;
import dev.sterner.witchery.features.necromancy.EtherealEntityAttachment;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Ldev/sterner/witchery/features/ritual/SoulSeveranceRitual;", "Ldev/sterner/witchery/core/api/Ritual;", "<init>", "()V", "onStartRitual", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "goldenChalkBlockEntity", "Ldev/sterner/witchery/content/block/ritual/GoldenChalkBlockEntity;", "witchery"})
public final class SoulSeveranceRitual
extends Ritual {
    public SoulSeveranceRitual() {
        super("soul_severance");
    }

    @Override
    public boolean onStartRitual(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull GoldenChalkBlockEntity goldenChalkBlockEntity) {
        LivingEntity target;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)goldenChalkBlockEntity, (String)"goldenChalkBlockEntity");
        if (level.isClientSide) {
            return true;
        }
        if (goldenChalkBlockEntity.getTargetPlayer() != null) {
            ServerPlayer serverPlayer;
            MinecraftServer minecraftServer = level.getServer();
            if (minecraftServer != null && (minecraftServer = minecraftServer.getPlayerList()) != null) {
                UUID uUID = goldenChalkBlockEntity.getTargetPlayer();
                Intrinsics.checkNotNull((Object)uUID);
                serverPlayer = minecraftServer.getPlayer(uUID);
            } else {
                serverPlayer = null;
            }
            v3 = (LivingEntity)serverPlayer;
        } else if (goldenChalkBlockEntity.getTargetEntity() != null) {
            Integer n = goldenChalkBlockEntity.getTargetEntity();
            Intrinsics.checkNotNull((Object)n);
            Entity entity = level.getEntity(n.intValue());
            v3 = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        } else {
            v3 = target = null;
        }
        if (target == null) {
            return false;
        }
        if (target.getType().is(WitcheryTags.INSTANCE.getNECROMANCER_SUMMONABLE())) {
            CompoundTag tagCopy = target.saveWithoutId(new CompoundTag());
            tagCopy.remove("UUID");
            Entity deadTargetCopy = target.getType().create(level);
            if (deadTargetCopy instanceof LivingEntity) {
                ((LivingEntity)deadTargetCopy).load(tagCopy);
                ((LivingEntity)deadTargetCopy).moveTo(target.getX(), target.getY(), target.getZ(), target.getYRot(), target.getXRot());
                ((LivingEntity)deadTargetCopy).copyPosition((Entity)target);
                EtherealEntityAttachment.setData((LivingEntity)deadTargetCopy, new EtherealEntityAttachment.Data(null, false, false, 0L, 0L, 31, null));
                EtherealEntityAttachment.setData((LivingEntity)deadTargetCopy, new EtherealEntityAttachment.Data(null, false, true, level.getGameTime(), 6000L));
                target.kill();
                level.addFreshEntity(deadTargetCopy);
            }
            return true;
        }
        if (target instanceof ServerPlayer) {
            AfflictionAbilityHandler.INSTANCE.addAbilityOnLevelUp((Player)target, LichdomAbility.SOUL_FORM.getRequiredLevel(), AfflictionTypes.LICHDOM, true);
            LichdomSpecificEventHandler.INSTANCE.activateSoulForm((ServerPlayer)target);
            return true;
        }
        return true;
    }
}

