/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.tarot;

import dev.sterner.witchery.features.tarot.TarotEffect;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0014"}, d2={"Ldev/sterner/witchery/features/tarot/StrengthEffect;", "Ldev/sterner/witchery/features/tarot/TarotEffect;", "<init>", "()V", "getDisplayName", "Lnet/minecraft/network/chat/MutableComponent;", "kotlin.jvm.PlatformType", "isReversed", "", "getDescription", "onAdded", "", "player", "Lnet/minecraft/world/entity/player/Player;", "onRemoved", "onEntityKill", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "updateDamageModifier", "Companion", "witchery"})
public final class StrengthEffect
extends TarotEffect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final ResourceLocation STRENGTH_DAMAGE_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"witchery", (String)"strength_damage_modifier");

    public StrengthEffect() {
        super(9);
    }

    public MutableComponent getDisplayName(boolean isReversed) {
        return Component.translatable((String)(isReversed ? "tarot.witchery.strength.reversed" : "tarot.witchery.strength"));
    }

    public MutableComponent getDescription(boolean isReversed) {
        return Component.translatable((String)(isReversed ? "tarot.witchery.strength.reversed.description" : "tarot.witchery.strength.description"));
    }

    @Override
    public void onAdded(@NotNull Player player, boolean isReversed) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.updateDamageModifier(player, isReversed);
    }

    @Override
    public void onRemoved(@NotNull Player player, boolean isReversed) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            AttributeInstance attributeInstance = player.getAttribute(Attributes.ATTACK_DAMAGE);
            if (attributeInstance == null) break block0;
            attributeInstance.removeModifier(STRENGTH_DAMAGE_MODIFIER_ID);
        }
    }

    @Override
    public void onEntityKill(@NotNull Player player, @NotNull LivingEntity entity, boolean isReversed) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!isReversed) {
            player.heal(2.0f);
        }
    }

    private final void updateDamageModifier(Player player, boolean isReversed) {
        AttributeInstance attributeInstance = player.getAttribute(Attributes.ATTACK_DAMAGE);
        if (attributeInstance == null) {
            return;
        }
        AttributeInstance damageAttribute = attributeInstance;
        damageAttribute.removeModifier(STRENGTH_DAMAGE_MODIFIER_ID);
        AttributeModifier modifier = new AttributeModifier(STRENGTH_DAMAGE_MODIFIER_ID, isReversed ? -2.0 : 3.0, AttributeModifier.Operation.ADD_VALUE);
        damageAttribute.addPermanentModifier(modifier);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ldev/sterner/witchery/features/tarot/StrengthEffect$Companion;", "", "<init>", "()V", "STRENGTH_DAMAGE_MODIFIER_ID", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

