/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.features.tarot;

import dev.sterner.witchery.content.block.altar.AltarBlockEntity;
import dev.sterner.witchery.content.item.brew.BrewItem;
import dev.sterner.witchery.content.item.brew.ThrowableBrewItem;
import dev.sterner.witchery.features.tarot.TarotEffect;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0012"}, d2={"Ldev/sterner/witchery/features/tarot/TheMagicianEffect;", "Ldev/sterner/witchery/features/tarot/TarotEffect;", "<init>", "()V", "getDisplayName", "Lnet/minecraft/network/chat/MutableComponent;", "kotlin.jvm.PlatformType", "isReversed", "", "getDescription", "onMorning", "", "player", "Lnet/minecraft/world/entity/player/Player;", "onItemUse", "item", "Lnet/minecraft/world/item/ItemStack;", "TheMagicianBrewReturn", "witchery"})
public final class TheMagicianEffect
extends TarotEffect {
    public TheMagicianEffect() {
        super(2);
    }

    public MutableComponent getDisplayName(boolean isReversed) {
        return Component.translatable((String)(isReversed ? "tarot.witchery.the_magician.reversed" : "tarot.witchery.the_magician"));
    }

    public MutableComponent getDescription(boolean isReversed) {
        return Component.translatable((String)(isReversed ? "tarot.witchery.the_magician.reversed.description" : "tarot.witchery.the_magician.description"));
    }

    @Override
    public void onMorning(@NotNull Player player, boolean isReversed) {
        block2: {
            AltarBlockEntity altar;
            block1: {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                if (!(player.level() instanceof ServerLevel)) {
                    return;
                }
                Level level = player.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel serverLevel = (ServerLevel)level;
                BlockPos blockPos = player.blockPosition();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
                altar = AltarBlockEntity.Companion.getClosestAltar(serverLevel, blockPos, 16);
                if (!isReversed) break block1;
                AltarBlockEntity altarBlockEntity = altar;
                if (altarBlockEntity == null) break block2;
                AltarBlockEntity it = altarBlockEntity;
                boolean bl = false;
                it.setCurrentPower(RangesKt.coerceAtLeast((int)(it.getCurrentPower() - 500), (int)0));
                break block2;
            }
            AltarBlockEntity altarBlockEntity = altar;
            if (altarBlockEntity == null) break block2;
            AltarBlockEntity it = altarBlockEntity;
            boolean bl = false;
            it.setCurrentPower(RangesKt.coerceAtMost((int)(it.getCurrentPower() + 1000), (int)it.getMaxPower()));
        }
    }

    @Override
    public void onItemUse(@NotNull Player player, @NotNull ItemStack item, boolean isReversed) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (!isReversed && (item.getItem() instanceof BrewItem || item.getItem() instanceof ThrowableBrewItem) && player.level().random.nextFloat() < 0.2f && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack itemStack = item.copy();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
            TheMagicianBrewReturn.INSTANCE.scheduleReturn(serverPlayer, itemStack);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ldev/sterner/witchery/features/tarot/TheMagicianEffect$TheMagicianBrewReturn;", "", "<init>", "()V", "scheduledReturns", "", "Ljava/util/UUID;", "Lnet/minecraft/world/item/ItemStack;", "scheduleReturn", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "item", "tick", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
    public static final class TheMagicianBrewReturn {
        @NotNull
        public static final TheMagicianBrewReturn INSTANCE = new TheMagicianBrewReturn();
        @NotNull
        private static final Map<UUID, ItemStack> scheduledReturns = new LinkedHashMap();

        private TheMagicianBrewReturn() {
        }

        public final void scheduleReturn(@NotNull ServerPlayer player, @NotNull ItemStack item) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            scheduledReturns.put(player.getUUID(), item);
        }

        public final void tick(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (player instanceof ServerPlayer) {
                ItemStack itemStack = scheduledReturns.remove(((ServerPlayer)player).getUUID());
                if (itemStack == null) {
                    return;
                }
                ItemStack item = itemStack;
                if (!((ServerPlayer)player).getInventory().add(item)) {
                    player.drop(item, false);
                }
            }
        }
    }
}

