/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.integration.jei;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.content.recipe.distillery.DistilleryCraftingRecipe;
import dev.sterner.witchery.core.api.multiblock.MultiBlockItem;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.integration.jei.WitcheryJeiPlugin;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J0\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006\u00a8\u0006 "}, d2={"Ldev/sterner/witchery/integration/jei/DistillingRecipeCategory;", "Lmezz/jei/api/recipe/category/IRecipeCategory;", "Ldev/sterner/witchery/content/recipe/distillery/DistilleryCraftingRecipe;", "guiHelper", "Lmezz/jei/api/helpers/IJeiHelpers;", "<init>", "(Lmezz/jei/api/helpers/IJeiHelpers;)V", "getGuiHelper", "()Lmezz/jei/api/helpers/IJeiHelpers;", "setGuiHelper", "getRecipeType", "Lmezz/jei/api/recipe/RecipeType;", "getTitle", "Lnet/minecraft/network/chat/Component;", "getBackground", "Lmezz/jei/api/gui/drawable/IDrawable;", "getIcon", "setRecipe", "", "builder", "Lmezz/jei/api/gui/builder/IRecipeLayoutBuilder;", "recipe", "focuses", "Lmezz/jei/api/recipe/IFocusGroup;", "draw", "recipeSlotsView", "Lmezz/jei/api/gui/ingredient/IRecipeSlotsView;", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "mouseX", "", "mouseY", "witchery"})
public final class DistillingRecipeCategory
implements IRecipeCategory<DistilleryCraftingRecipe> {
    @NotNull
    private IJeiHelpers guiHelper;

    public DistillingRecipeCategory(@NotNull IJeiHelpers guiHelper) {
        Intrinsics.checkNotNullParameter((Object)guiHelper, (String)"guiHelper");
        this.guiHelper = guiHelper;
    }

    @NotNull
    public final IJeiHelpers getGuiHelper() {
        return this.guiHelper;
    }

    public final void setGuiHelper(@NotNull IJeiHelpers iJeiHelpers) {
        Intrinsics.checkNotNullParameter((Object)iJeiHelpers, (String)"<set-?>");
        this.guiHelper = iJeiHelpers;
    }

    @NotNull
    public RecipeType<DistilleryCraftingRecipe> getRecipeType() {
        return WitcheryJeiPlugin.Companion.getDISTILLING();
    }

    @NotNull
    public Component getTitle() {
        MutableComponent mutableComponent = Component.translatable((String)"witchery.distilling.category");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    @NotNull
    public IDrawable getBackground() {
        IDrawableStatic iDrawableStatic = this.guiHelper.getGuiHelper().createBlankDrawable(144, 90);
        Intrinsics.checkNotNullExpressionValue((Object)iDrawableStatic, (String)"createBlankDrawable(...)");
        return (IDrawable)iDrawableStatic;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.guiHelper.getGuiHelper().createDrawableItemStack(((MultiBlockItem)((Object)WitcheryItems.INSTANCE.getDISTILLERY().get())).getDefaultInstance());
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull DistilleryCraftingRecipe recipe, @NotNull IFocusGroup focuses) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        Intrinsics.checkNotNullParameter((Object)focuses, (String)"focuses");
        int baseX = 4;
        int baseY = 28;
        builder.addSlot(RecipeIngredientRole.INPUT, baseX + 9 - 4, baseY - 18 - 2 + 1).addItemStack(recipe.getInputItems().get(0));
        if (recipe.getInputItems().size() > 1) {
            builder.addSlot(RecipeIngredientRole.INPUT, baseX + 9 + 18 - 4, baseY - 18 - 2 + 1).addItemStack(recipe.getInputItems().get(1));
        }
        builder.addSlot(RecipeIngredientRole.INPUT, baseX + 9 + 9 - 4, baseY + 36 - 20 + 1).addItemStack(new ItemStack((ItemLike)WitcheryItems.INSTANCE.getJAR().get(), recipe.getJarConsumption()));
        if (!((Collection)recipe.getOutputItems()).isEmpty()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, baseX + 18 + 24 + 24 + 9 + 18 - 1, baseY - 9 - 1).addItemStack(recipe.getOutputItems().get(0));
        }
        if (recipe.getOutputItems().size() > 1) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, baseX + 18 + 24 + 24 + 9 + 18 + 18 - 1, baseY - 9 - 1).addItemStack(recipe.getOutputItems().get(1));
        }
        if (recipe.getOutputItems().size() > 2) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, baseX + 18 + 24 + 24 + 9 + 18 - 1, baseY + 18 - 9 - 1).addItemStack(recipe.getOutputItems().get(2));
        }
        if (recipe.getOutputItems().size() > 3) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, baseX + 18 + 24 + 24 + 9 + 18 + 18 - 1, baseY + 18 - 9 - 1).addItemStack(recipe.getOutputItems().get(3));
        }
    }

    public void draw(@NotNull DistilleryCraftingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        Intrinsics.checkNotNullParameter((Object)recipeSlotsView, (String)"recipeSlotsView");
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        ResourceLocation texture = Witchery.Companion.id("textures/gui/distillery_emi.png");
        guiGraphics.blit(texture, 8, 8, 0, 0, 123, 54);
        MutableComponent text = Component.literal((String)("Altar Power: " + recipe.getAltarPower() + "/s"));
        Font font = Minecraft.getInstance().font;
        int textX = this.getWidth() / 2;
        int textY = this.getHeight() - 24;
        guiGraphics.drawCenteredString(font, (Component)text, textX, textY, 0xFFFFFF);
    }
}

