/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.features.death.DeathPlayerAttachment;
import dev.sterner.witchery.features.death.DeathTransformationHelper;
import dev.sterner.witchery.features.poppet.PoppetHandler;
import dev.sterner.witchery.features.poppet.VoodooPoppetLivingEntityAttachment;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Inject(method={"isInWaterRainOrBubble"}, at={@At(value="RETURN")}, cancellable=true)
    private void witchery$isInWaterRainOrBubble(CallbackInfoReturnable<Boolean> info) {
        LivingEntity living;
        VoodooPoppetLivingEntityAttachment.Data data2;
        Entity entity;
        if (!((Boolean)info.getReturnValue()).booleanValue() && (entity = (Entity)Entity.class.cast(this)) instanceof LivingEntity && (data2 = VoodooPoppetLivingEntityAttachment.getPoppetData(living = (LivingEntity)entity)).isUnderWater()) {
            info.setReturnValue((Object)true);
        }
    }

    @ModifyReturnValue(method={"isEyeInFluid"}, at={@At(value="RETURN")})
    private boolean witchery$isEyeInFluid(boolean original) {
        LivingEntity living;
        Entity entity = (Entity)Entity.class.cast(this);
        if (entity instanceof LivingEntity && VoodooPoppetLivingEntityAttachment.getPoppetData(living = (LivingEntity)entity).isUnderWater()) {
            return true;
        }
        return original;
    }

    @Inject(method={"updateFluidHeightAndDoFluidPushing*"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$deathBootsFluidWalking(CallbackInfoReturnable<Boolean> cir) {
        DeathPlayerAttachment.Data data2;
        Player player;
        Entity entity = (Entity)this;
        if (entity instanceof Player && DeathTransformationHelper.INSTANCE.hasDeathBoots(player = (Player)entity) && (data2 = DeathPlayerAttachment.getData(player)).getHasDeathFluidWalking() && !player.isShiftKeyDown()) {
            AABB aabb = entity.getBoundingBox().deflate(0.001);
            int minX = Mth.floor((double)aabb.minX);
            int maxX = Mth.ceil((double)aabb.maxX);
            int minY = Mth.floor((double)aabb.minY);
            int maxY = Mth.ceil((double)aabb.maxY);
            int minZ = Mth.floor((double)aabb.minZ);
            int maxZ = Mth.ceil((double)aabb.maxZ);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            Double highestWaterSurface = null;
            for (int x = minX; x < maxX; ++x) {
                block1: for (int z = minZ; z < maxZ; ++z) {
                    for (int y = maxY - 1; y >= minY; --y) {
                        mutablePos.set(x, y, z);
                        FluidState fluidState = entity.level().getFluidState((BlockPos)mutablePos);
                        if (fluidState.isEmpty() || fluidState.getAmount() < 8) continue;
                        mutablePos.set(x, y + 1, z);
                        FluidState aboveFluidState = entity.level().getFluidState((BlockPos)mutablePos);
                        boolean isWaterAbove = !aboveFluidState.isEmpty() && aboveFluidState.getAmount() >= 8;
                        mutablePos.set(x, y, z);
                        fluidState = entity.level().getFluidState((BlockPos)mutablePos);
                        double fluidHeight = (float)y + fluidState.getHeight((BlockGetter)entity.level(), (BlockPos)mutablePos);
                        if (isWaterAbove || !(fluidHeight >= aabb.minY - 0.1) || highestWaterSurface != null && !(fluidHeight > highestWaterSurface)) continue block1;
                        highestWaterSurface = fluidHeight;
                        continue block1;
                    }
                }
            }
            if (highestWaterSurface != null) {
                double feetY = aabb.minY;
                double distanceToSurface = highestWaterSurface - feetY;
                if (distanceToSurface >= -0.1 && distanceToSurface <= 0.5 && entity.getDeltaMovement().y <= 0.0) {
                    entity.setDeltaMovement(entity.getDeltaMovement().x, 0.0, entity.getDeltaMovement().z);
                    entity.setOnGround(true);
                    cir.setReturnValue((Object)false);
                    return;
                }
            }
        }
    }

    @Inject(method={"setRemainingFireTicks"}, at={@At(value="HEAD")})
    private void witchery$poppet(int remainingFireTicks, CallbackInfo ci) {
        ItemEntity item;
        Entity entity = (Entity)this;
        if (remainingFireTicks > 0 && entity instanceof ItemEntity && (item = (ItemEntity)entity).getItem().is((Item)WitcheryItems.INSTANCE.getVOODOO_POPPET().get())) {
            LivingEntity targetEntity = PoppetHandler.INSTANCE.getBoundEntity(entity.level(), item.getItem());
            Player targetPlayer = PoppetHandler.INSTANCE.getBoundPlayer(entity.level(), item.getItem());
            if (targetEntity != null) {
                targetEntity.setRemainingFireTicks(80);
            } else if (targetPlayer != null) {
                targetPlayer.setRemainingFireTicks(80);
            }
        }
    }
}

