/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin;

import dev.sterner.witchery.features.tarot.TarotPlayerAttachment;
import java.util.List;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PanicGoal.class})
public class PanicGoalMixin {
    @Shadow
    @Final
    protected PathfinderMob mob;

    @Inject(method={"canUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$preventPanicNearLoversCard(CallbackInfoReturnable<Boolean> cir) {
        if (this.witchery$hasNearbyLoversCard()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"canContinueToUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$stopPanicNearLoversCard(CallbackInfoReturnable<Boolean> cir) {
        if (this.witchery$hasNearbyLoversCard()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    private boolean witchery$hasNearbyLoversCard() {
        AABB searchBox = this.mob.getBoundingBox().inflate(8.0);
        List nearbyPlayers = this.mob.level().getEntitiesOfClass(Player.class, searchBox);
        for (Player player : nearbyPlayers) {
            boolean isReversed;
            TarotPlayerAttachment.Data data2 = TarotPlayerAttachment.getData(player);
            int loversIndex = data2.getDrawnCards().indexOf(7);
            if (loversIndex == -1 || (isReversed = data2.getReversedCards().size() > loversIndex && data2.getReversedCards().get(loversIndex) != false)) continue;
            return true;
        }
        return false;
    }
}

