/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin;

import dev.sterner.witchery.content.entity.player_shell.SleepingPlayerEntity;
import dev.sterner.witchery.features.spirit_world.SleepingLevelAttachment;
import dev.sterner.witchery.features.spirit_world.SleepingPlayerHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public class ServerPlayerMixin {
    @Inject(method={"findRespawnPositionAndUseSpawnBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$respawnAtSleeping(boolean keepInventory, DimensionTransition.PostDimensionTransition postDimensionTransition, CallbackInfoReturnable<DimensionTransition> cir) {
        ServerPlayer player = (ServerPlayer)ServerPlayer.class.cast(this);
        for (ServerLevel serverLevel : player.level().getServer().getAllLevels()) {
            SleepingLevelAttachment.PlayerSleepingData hasSleeping = SleepingPlayerHandler.INSTANCE.getPlayerFromSleeping(player.getUUID(), serverLevel);
            if (hasSleeping == null) continue;
            ChunkPos chunk = new ChunkPos(hasSleeping.getPos());
            serverLevel.setChunkForced(chunk.x, chunk.z, true);
            Entity sleepEntity = serverLevel.getEntity(hasSleeping.getUuid());
            if (!(sleepEntity instanceof SleepingPlayerEntity)) continue;
            SleepingPlayerEntity sleepingPlayerEntity = (SleepingPlayerEntity)sleepEntity;
            BlockPos pos = sleepingPlayerEntity.blockPosition();
            DimensionTransition tran = new DimensionTransition(serverLevel, pos.getCenter(), Vec3.ZERO, sleepingPlayerEntity.getYRot(), 0.0f, postDimensionTransition);
            cir.setReturnValue((Object)tran);
        }
    }
}

