/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin.client;

import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.features.misc.InventoryLockPlayerAttachment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={InventoryScreen.class})
public abstract class InventoryScreenMixin
extends EffectRenderingInventoryScreen<InventoryMenu> {
    public InventoryScreenMixin(InventoryMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    @Inject(method={"renderBg"}, at={@At(value="TAIL")})
    private void witchery$renderLockedSlots(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY, CallbackInfo ci) {
        if (this.minecraft == null || this.minecraft.player == null) {
            return;
        }
        InventoryLockPlayerAttachment.Data data2 = InventoryLockPlayerAttachment.getData((Player)this.minecraft.player);
        for (int lockedSlot : data2.getLockedSlots()) {
            Slot slot = this.witchery_neoforge$findSlotForInventoryIndex(lockedSlot);
            if (slot == null) continue;
            this.witchery_neoforge$renderBarrierOverSlot(guiGraphics, slot);
        }
    }

    @Unique
    private Slot witchery_neoforge$findSlotForInventoryIndex(int inventoryIndex) {
        for (Slot slot : ((InventoryMenu)this.menu).slots) {
            if (!(slot.container instanceof Inventory) || slot.getContainerSlot() != inventoryIndex) continue;
            return slot;
        }
        return null;
    }

    @Unique
    private void witchery_neoforge$renderBarrierOverSlot(GuiGraphics guiGraphics, Slot slot) {
        int x = this.leftPos + slot.x;
        int y = this.topPos + slot.y;
        guiGraphics.blit(Witchery.Companion.id("textures/gui/locked_slot.png"), x, y, 0.0f, 0.0f, 16, 16, 16, 16);
    }
}

