/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.mixin.possession.client;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.possession.PossessionComponentAttachment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    @Shadow
    protected abstract void setModelProperties(AbstractClientPlayer var1);

    public PlayerRendererMixin(EntityRendererProvider.Context ctx, PlayerModel<AbstractClientPlayer> model, float shadowRadius) {
        super(ctx, model, shadowRadius);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$render(AbstractClientPlayer renderedPlayer, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int lightmap, CallbackInfo ci) {
        Mob possessedEntity = PossessionComponentAttachment.INSTANCE.get((Player)renderedPlayer).getHost();
        if (possessedEntity != null) {
            if (renderedPlayer == Minecraft.getInstance().player) {
                possessedEntity.yBodyRot = renderedPlayer.yBodyRot;
                possessedEntity.yBodyRotO = renderedPlayer.yBodyRotO;
                possessedEntity.setYRot(renderedPlayer.getYRot());
                possessedEntity.yRotO = renderedPlayer.yRotO;
                possessedEntity.setXRot(renderedPlayer.getXRot());
                possessedEntity.xRotO = renderedPlayer.xRotO;
                possessedEntity.yHeadRot = renderedPlayer.yHeadRot;
                possessedEntity.yHeadRotO = renderedPlayer.yHeadRotO;
                this.entityRenderDispatcher.render((Entity)possessedEntity, 0.0, 0.0, 0.0, yaw, tickDelta, matrices, vertexConsumers, lightmap);
            }
            ci.cancel();
        }
    }

    @Inject(method={"renderRightHand"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$renderRightHand(PoseStack matrices, MultiBufferSource vertices, int lightmap, AbstractClientPlayer renderedPlayer, CallbackInfo ci) {
        if (this.witchery$renderPossessedArm(matrices, vertices, renderedPlayer, lightmap, true)) {
            ci.cancel();
        }
    }

    @Inject(method={"renderLeftHand"}, at={@At(value="HEAD")}, cancellable=true)
    private void witchery$renderLeftHand(PoseStack matrices, MultiBufferSource vertices, int lightmap, AbstractClientPlayer renderedPlayer, CallbackInfo ci) {
        if (this.witchery$renderPossessedArm(matrices, vertices, renderedPlayer, lightmap, false)) {
            ci.cancel();
        }
    }

    @Unique
    private boolean witchery$renderPossessedArm(PoseStack matrices, MultiBufferSource vertices, AbstractClientPlayer renderedPlayer, int lightmapCoordinates, boolean rightArm) {
        boolean vag = AfflictionPlayerAttachment.getData((Player)renderedPlayer).isVagrant();
        if (vag) {
            EntityModel possessedModel;
            EntityRenderer possessedRenderer;
            Mob possessed = PossessionComponentAttachment.INSTANCE.get((Player)renderedPlayer).getHost();
            if (possessed != null && (possessedRenderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)possessed)) instanceof RenderLayerParent && (possessedModel = ((RenderLayerParent)possessedRenderer).getModel()) instanceof HumanoidModel) {
                HumanoidModel bipedModel = (HumanoidModel)possessedModel;
                PlayerModel playerModel = (PlayerModel)this.getModel();
                ModelPart arm = rightArm ? bipedModel.rightArm : bipedModel.leftArm;
                this.setModelProperties(renderedPlayer);
                bipedModel.leftArmPose = playerModel.leftArmPose;
                bipedModel.rightArmPose = playerModel.rightArmPose;
                bipedModel.attackTime = 0.0f;
                bipedModel.crouching = false;
                bipedModel.setupAnim((LivingEntity)possessed, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                arm.xRot = 0.0f;
                arm.render(matrices, vertices.getBuffer(possessedModel.renderType(possessedRenderer.getTextureLocation((Entity)possessed))), lightmapCoordinates, OverlayTexture.NO_OVERLAY);
            }
            return true;
        }
        return false;
    }
}

