/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client;

import dev.sterner.witchery.content.block.ancient_tablet.AncientTabletBlockEntity;
import dev.sterner.witchery.features.affliction.AfflictionPlayerAttachment;
import dev.sterner.witchery.features.infusion.InfusionPlayerAttachment;
import dev.sterner.witchery.features.infusion.InfusionType;
import dev.sterner.witchery.network.ReadTabletC2SPayload;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eJ&\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u000eH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/sterner/witchery/client/TabletGazeTracker;", "", "<init>", "()V", "currentTablet", "Ljava/util/UUID;", "currentPos", "Lnet/minecraft/core/BlockPos;", "gazeStartTime", "", "REQUIRED_GAZE_TIME", "", "MAX_TABLETS", "tick", "", "findTabletInView", "Lkotlin/Pair;", "Ldev/sterner/witchery/content/block/ancient_tablet/AncientTabletBlockEntity;", "player", "Lnet/minecraft/world/entity/player/Player;", "level", "Lnet/minecraft/world/level/Level;", "reset", "witchery"})
public final class TabletGazeTracker {
    @NotNull
    public static final TabletGazeTracker INSTANCE = new TabletGazeTracker();
    @Nullable
    private static UUID currentTablet;
    @Nullable
    private static BlockPos currentPos;
    private static long gazeStartTime;
    private static final int REQUIRED_GAZE_TIME = 140;
    private static final int MAX_TABLETS = 3;

    private TabletGazeTracker() {
    }

    public final void tick() {
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        InfusionPlayerAttachment.Data infusion = InfusionPlayerAttachment.getData((Player)player);
        if (infusion.getType() != InfusionType.NECRO) {
            this.reset();
            return;
        }
        AfflictionPlayerAttachment.Data affliction = AfflictionPlayerAttachment.getData((Player)player);
        if (affliction.getLichData().getReadTablets().size() >= 3) {
            this.reset();
            return;
        }
        Level level = player.level();
        Player player2 = (Player)player;
        Intrinsics.checkNotNull((Object)level);
        Pair<BlockPos, AncientTabletBlockEntity> lookingAt = this.findTabletInView(player2, level);
        if (lookingAt != null) {
            Pair<BlockPos, AncientTabletBlockEntity> pair = lookingAt;
            BlockPos pos = (BlockPos)pair.component1();
            AncientTabletBlockEntity tablet = (AncientTabletBlockEntity)pair.component2();
            if (affliction.getLichData().getReadTablets().contains(tablet.getTabletId())) {
                this.reset();
                return;
            }
            if (Intrinsics.areEqual((Object)tablet.getTabletId(), (Object)currentTablet) && Intrinsics.areEqual((Object)pos, (Object)currentPos)) {
                long l = gazeStartTime;
                gazeStartTime = l + 1L;
                float progress = RangesKt.coerceIn((float)((float)gazeStartTime / (float)140), (float)0.0f, (float)1.0f);
                tablet.updateGlowProgress(progress);
                if (gazeStartTime >= 140L) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ReadTabletC2SPayload(tablet.getTabletId(), pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.reset();
                }
            } else {
                if (currentPos != null) {
                    BlockEntity blockEntity = level.getBlockEntity(currentPos);
                    AncientTabletBlockEntity ancientTabletBlockEntity = blockEntity instanceof AncientTabletBlockEntity ? (AncientTabletBlockEntity)blockEntity : null;
                    if (ancientTabletBlockEntity != null) {
                        ancientTabletBlockEntity.resetGlow();
                    }
                }
                currentTablet = tablet.getTabletId();
                currentPos = pos;
                gazeStartTime = 0L;
            }
        } else {
            if (currentPos != null) {
                BlockEntity blockEntity = level.getBlockEntity(currentPos);
                AncientTabletBlockEntity ancientTabletBlockEntity = blockEntity instanceof AncientTabletBlockEntity ? (AncientTabletBlockEntity)blockEntity : null;
                if (ancientTabletBlockEntity != null) {
                    ancientTabletBlockEntity.resetGlow();
                }
            }
            this.reset();
        }
    }

    private final Pair<BlockPos, AncientTabletBlockEntity> findTabletInView(Player player, Level level) {
        Vec3 eyePos = player.getEyePosition(1.0f);
        Vec3 lookVec = player.getLookAngle();
        double maxDistance = 10.0;
        BlockPos playerPos = player.blockPosition();
        for (int x = -10; x < 11; ++x) {
            for (int y = -10; y < 11; ++y) {
                for (int z = -10; z < 11; ++z) {
                    Vec3 toTablet;
                    double dot;
                    double distance;
                    BlockPos checkPos = playerPos.offset(x, y, z);
                    BlockEntity blockEntity = level.getBlockEntity(checkPos);
                    if (!(blockEntity instanceof AncientTabletBlockEntity) || !((distance = eyePos.distanceTo(Vec3.atCenterOf((Vec3i)((Vec3i)checkPos)))) <= maxDistance) || !((dot = lookVec.dot(toTablet = Vec3.atCenterOf((Vec3i)((Vec3i)checkPos)).subtract(eyePos).normalize())) > 0.5)) continue;
                    return new Pair((Object)checkPos, (Object)blockEntity);
                }
            }
        }
        return null;
    }

    private final void reset() {
        currentTablet = null;
        currentPos = null;
        gazeStartTime = 0L;
    }
}

