/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.sterner.witchery.Witchery;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 -*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001-B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J=\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010#J0\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*H\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\tR\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\t\u00a8\u0006."}, d2={"Ldev/sterner/witchery/client/model/BabaYagaEntityModel;", "T", "Lnet/minecraft/world/entity/Mob;", "Lnet/minecraft/client/model/HierarchicalModel;", "root", "Lnet/minecraft/client/model/geom/ModelPart;", "<init>", "(Lnet/minecraft/client/model/geom/ModelPart;)V", "getRoot", "()Lnet/minecraft/client/model/geom/ModelPart;", "holdingItem", "", "getHoldingItem", "()Z", "setHoldingItem", "(Z)V", "head", "getHead", "nose", "getNose", "body", "arms", "rightLeg", "getRightLeg", "leftLeg", "getLeftLeg", "setupAnim", "", "entity", "limbSwing", "", "limbSwingAmount", "ageInTicks", "netHeadYaw", "headPitch", "(Lnet/minecraft/world/entity/Mob;FFFFF)V", "renderToBuffer", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "vertexConsumer", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "packedLight", "", "packedOverlay", "color", "Companion", "witchery"})
public final class BabaYagaEntityModel<T extends Mob>
extends HierarchicalModel<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModelPart root;
    private boolean holdingItem;
    @NotNull
    private final ModelPart head;
    @NotNull
    private final ModelPart nose;
    @NotNull
    private final ModelPart body;
    @NotNull
    private final ModelPart arms;
    @NotNull
    private final ModelPart rightLeg;
    @NotNull
    private final ModelPart leftLeg;
    @NotNull
    private static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Witchery.Companion.id("baba_yaga"), "main");

    public BabaYagaEntityModel(@NotNull ModelPart root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        super(BabaYagaEntityModel::_init_$lambda$0);
        this.root = root;
        ModelPart modelPart = this.root.getChild("head");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"getChild(...)");
        this.head = modelPart;
        ModelPart modelPart2 = this.head.getChild("nose");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart2, (String)"getChild(...)");
        this.nose = modelPart2;
        ModelPart modelPart3 = this.root.getChild("body");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart3, (String)"getChild(...)");
        this.body = modelPart3;
        ModelPart modelPart4 = this.root.getChild("arms");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart4, (String)"getChild(...)");
        this.arms = modelPart4;
        ModelPart modelPart5 = this.root.getChild("right_leg");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart5, (String)"getChild(...)");
        this.rightLeg = modelPart5;
        ModelPart modelPart6 = this.root.getChild("left_leg");
        Intrinsics.checkNotNullExpressionValue((Object)modelPart6, (String)"getChild(...)");
        this.leftLeg = modelPart6;
    }

    @NotNull
    public final ModelPart getRoot() {
        return this.root;
    }

    public final boolean getHoldingItem() {
        return this.holdingItem;
    }

    public final void setHoldingItem(boolean bl) {
        this.holdingItem = bl;
    }

    @NotNull
    public final ModelPart getHead() {
        return this.head;
    }

    @NotNull
    public final ModelPart getNose() {
        return this.nose;
    }

    @NotNull
    public final ModelPart getRightLeg() {
        return this.rightLeg;
    }

    @NotNull
    public final ModelPart getLeftLeg() {
        return this.leftLeg;
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.zRot = 0.0f;
        this.nose.setPos(0.0f, -2.0f, 0.0f);
        float f = 0.01f * (float)(((Entity)entity).getId() % 10);
        this.nose.xRot = Mth.sin((float)((float)((Mob)entity).tickCount * f)) * 4.5f * ((float)Math.PI / 180);
        this.nose.yRot = 0.0f;
        this.nose.zRot = Mth.cos((float)((float)((Mob)entity).tickCount * f)) * 2.5f * ((float)Math.PI / 180);
        if (this.holdingItem) {
            this.nose.setPos(0.0f, 1.0f, -1.5f);
            this.nose.xRot = -0.9f;
        }
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)vertexConsumer, (String)"vertexConsumer");
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.arms.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }

    private static final RenderType _init_$lambda$0(ResourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return RenderType.entityTranslucent((ResourceLocation)location);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ldev/sterner/witchery/client/model/BabaYagaEntityModel$Companion;", "", "<init>", "()V", "LAYER_LOCATION", "Lnet/minecraft/client/model/geom/ModelLayerLocation;", "getLAYER_LOCATION", "()Lnet/minecraft/client/model/geom/ModelLayerLocation;", "createBodyLayer", "Lnet/minecraft/client/model/geom/builders/LayerDefinition;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModelLayerLocation getLAYER_LOCATION() {
            return LAYER_LOCATION;
        }

        @NotNull
        public final LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.getRoot();
            PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
            partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 20).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 38).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            partdefinition.addOrReplaceChild("arms", CubeListBuilder.create().texOffs(40, 38).addBox(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(44, 22).addBox(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(44, 22).addBox(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
            partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 22).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
            partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
            LayerDefinition layerDefinition = LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)128);
            Intrinsics.checkNotNullExpressionValue((Object)layerDefinition, (String)"create(...)");
            return layerDefinition;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

