/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.particle;

import dev.sterner.witchery.client.particle.ColorBubbleData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/sterner/witchery/client/particle/ColorBubbleParticle;", "Lnet/minecraft/client/particle/TextureSheetParticle;", "level", "Lnet/minecraft/client/multiplayer/ClientLevel;", "pos", "Lnet/minecraft/world/phys/Vec3;", "red", "", "green", "blue", "spriteSet", "Lnet/minecraft/client/particle/SpriteSet;", "<init>", "(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/world/phys/Vec3;FFFLnet/minecraft/client/particle/SpriteSet;)V", "tick", "", "getRenderType", "Lnet/minecraft/client/particle/ParticleRenderType;", "Provider", "witchery"})
public final class ColorBubbleParticle
extends TextureSheetParticle {
    @NotNull
    private final SpriteSet spriteSet;

    public ColorBubbleParticle(@NotNull ClientLevel level, @NotNull Vec3 pos, float red, float green, float blue, @NotNull SpriteSet spriteSet) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)spriteSet, (String)"spriteSet");
        super(level, pos.x, pos.y, pos.z);
        this.spriteSet = spriteSet;
        this.setSpriteFromAge(this.spriteSet);
        this.quadSize *= 0.3f + (float)Math.random() * 0.7f;
        this.hasPhysics = false;
        this.gravity = 0.0f;
        this.friction = 0.8f + (float)Math.random() * 0.2f;
        this.xd *= 0.3;
        this.yd = 0.025 + Math.random() * 0.03;
        this.zd *= 0.3;
        this.rCol = red;
        this.gCol = green;
        this.bCol = blue;
        this.lifetime = (int)((double)20 + Math.random() * (double)6);
        this.alpha = 0.5f;
        this.setSize(0.25f, 0.25f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        int n = this.age;
        this.age = n + 1;
        if (n >= this.lifetime) {
            this.remove();
        } else {
            this.setSpriteFromAge(this.spriteSet);
            this.yd -= 0.04 * (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            if (this.speedUpWhenYMotionIsBlocked && this.y == this.yo) {
                this.xd *= 1.1;
                this.zd *= 1.1;
            }
            this.xd *= (double)this.friction;
            this.yd *= (double)this.friction;
            this.zd *= (double)this.friction;
            if (this.onGround) {
                this.xd *= (double)0.7f;
                this.zd *= (double)0.7f;
            }
        }
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        ParticleRenderType particleRenderType = ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
        Intrinsics.checkNotNullExpressionValue((Object)particleRenderType, (String)"PARTICLE_SHEET_TRANSLUCENT");
        return particleRenderType;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006JH\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/sterner/witchery/client/particle/ColorBubbleParticle$Provider;", "Lnet/minecraft/client/particle/ParticleProvider;", "Ldev/sterner/witchery/client/particle/ColorBubbleData;", "spriteSet", "Lnet/minecraft/client/particle/SpriteSet;", "<init>", "(Lnet/minecraft/client/particle/SpriteSet;)V", "createParticle", "Lnet/minecraft/client/particle/Particle;", "data", "level", "Lnet/minecraft/client/multiplayer/ClientLevel;", "x", "", "y", "z", "xSpeed", "ySpeed", "zSpeed", "witchery"})
    public static final class Provider
    implements ParticleProvider<ColorBubbleData> {
        @NotNull
        private final SpriteSet spriteSet;

        public Provider(@NotNull SpriteSet spriteSet) {
            Intrinsics.checkNotNullParameter((Object)spriteSet, (String)"spriteSet");
            this.spriteSet = spriteSet;
        }

        @NotNull
        public Particle createParticle(@NotNull ColorBubbleData data2, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Vec3 pos = new Vec3(x, y, z);
            ColorBubbleParticle particle = new ColorBubbleParticle(level, pos, data2.getRed(), data2.getGreen(), data2.getBlue(), this.spriteSet);
            return (Particle)particle;
        }
    }
}

