/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.sterner.witchery.Witchery;
import dev.sterner.witchery.client.model.AncientTabletModel;
import dev.sterner.witchery.content.block.ancient_tablet.AncientTabletBlockEntity;
import dev.sterner.witchery.core.registry.WitcheryRenderTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J8\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\r0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001e"}, d2={"Ldev/sterner/witchery/client/renderer/block/AncientTabletBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Ldev/sterner/witchery/content/block/ancient_tablet/AncientTabletBlockEntity;", "ctx", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "model", "Ldev/sterner/witchery/client/model/AncientTabletModel;", "getRenderBoundingBox", "Lnet/minecraft/world/phys/AABB;", "blockEntity", "textureLocation", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "getTextureLocation", "()Lnet/minecraft/resources/ResourceLocation;", "textureLocationGlow", "getTextureLocationGlow", "render", "", "partialTick", "", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "packedOverlay", "witchery"})
public final class AncientTabletBlockEntityRenderer
implements BlockEntityRenderer<AncientTabletBlockEntity> {
    @NotNull
    private final AncientTabletModel model;
    private final ResourceLocation textureLocation;
    private final ResourceLocation textureLocationGlow;

    public AncientTabletBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ModelPart modelPart = ctx.bakeLayer(AncientTabletModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        this.model = new AncientTabletModel(modelPart);
        this.textureLocation = Witchery.Companion.id("textures/block/ancient_tablet.png");
        this.textureLocationGlow = Witchery.Companion.id("textures/block/ancient_tablet_glow.png");
    }

    @NotNull
    public AABB getRenderBoundingBox(@NotNull AncientTabletBlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX() - 1.5, (double)pos.getY() - 0.0, (double)pos.getZ() - 1.5, (double)pos.getX() + 2.5, (double)pos.getY() + 2.5, (double)pos.getZ() + 2.5);
    }

    public final ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public final ResourceLocation getTextureLocationGlow() {
        return this.textureLocationGlow;
    }

    public void render(@NotNull AncientTabletBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Direction dir;
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        poseStack.pushPose();
        Direction direction = dir = (Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                poseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                poseStack.translate(-0.5, 1.5, 0.5);
                break;
            }
            case 2: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                poseStack.translate(-1.5, 1.5, -0.5);
                break;
            }
            case 3: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                poseStack.translate(-1.5, 1.5, 0.5);
                break;
            }
            case 4: {
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                poseStack.translate(-0.5, 1.5, -0.5);
                break;
            }
            default: {
                poseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                poseStack.translate(-0.5, 1.5, 0.5);
            }
        }
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)this.textureLocation));
        Intrinsics.checkNotNull((Object)vertexConsumer);
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay, -1);
        float glowAlpha = blockEntity.getGlowAlpha();
        if (glowAlpha > 0.0f) {
            VertexConsumer glowConsumer = bufferSource.getBuffer((RenderType)WitcheryRenderTypes.INSTANCE.getGLOW().apply(this.textureLocationGlow));
            int alpha = (int)(glowAlpha * (float)255);
            int color = alpha << 24 | 0xFFFFFF;
            Intrinsics.checkNotNull((Object)glowConsumer);
            this.model.renderToBuffer(poseStack, glowConsumer, 0xF000F0, packedOverlay, color);
        }
        poseStack.popPose();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

