/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.cauldron;

import dev.sterner.witchery.content.block.WitcheryBaseEntityBlock;
import dev.sterner.witchery.content.block.cauldron.CauldronBlockComponent;
import dev.sterner.witchery.content.block.cauldron.CauldronBlockEntity;
import dev.sterner.witchery.core.api.multiblock.MultiBlockHorizontalDirectionStructure;
import dev.sterner.witchery.core.api.multiblock.MultiBlockStructure;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import java.util.Iterator;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0001,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\t0\u0010H\u0014J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0016J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H\u0002J(\u0010&\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0016J(\u0010'\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010)\u001a\u00020*H\u0014J(\u0010+\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010)\u001a\u00020*H\u0016\u00a8\u0006-"}, d2={"Ldev/sterner/witchery/content/block/cauldron/WitcheryCauldronBlock;", "Ldev/sterner/witchery/content/block/WitcheryBaseEntityBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "getStateForPlacement", "blockPlaceContext", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "level", "Lnet/minecraft/world/level/BlockGetter;", "pos", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "shouldHandlePrecipitation", "", "Lnet/minecraft/world/level/Level;", "precipitation", "Lnet/minecraft/world/level/biome/Biome$Precipitation;", "giveFluid", "cauldron", "Ldev/sterner/witchery/content/block/cauldron/CauldronBlockEntity;", "handlePrecipitation", "randomTick", "Lnet/minecraft/server/level/ServerLevel;", "random", "Lnet/minecraft/util/RandomSource;", "animateTick", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nWitcheryCauldronBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WitcheryCauldronBlock.kt\ndev/sterner/witchery/content/block/cauldron/WitcheryCauldronBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n1869#2,2:179\n*S KotlinDebug\n*F\n+ 1 WitcheryCauldronBlock.kt\ndev/sterner/witchery/content/block/cauldron/WitcheryCauldronBlock\n*L\n118#1:179,2\n*E\n"})
public class WitcheryCauldronBlock
extends WitcheryBaseEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final VoxelShape INSIDE;
    @NotNull
    private static final VoxelShape SHAPE;
    @NotNull
    private static final Supplier<MultiBlockHorizontalDirectionStructure> STRUCTURE;

    public WitcheryCauldronBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        BlockBehaviour.Properties properties2 = properties.noOcclusion().lightLevel(Companion.litBlockEmission(8));
        Intrinsics.checkNotNullExpressionValue((Object)properties2, (String)"lightLevel(...)");
        super(properties2);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.MODEL;
    }

    @NotNull
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext blockPlaceContext) {
        Intrinsics.checkNotNullParameter((Object)blockPlaceContext, (String)"blockPlaceContext");
        Object object = this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)blockPlaceContext.getHorizontalDirection().getOpposite());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.LIT};
        builder.add(propertyArray);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return ((BlockEntityType)WitcheryBlockEntityTypes.INSTANCE.getCAULDRON().get()).create(blockPos, blockState);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof CauldronBlockEntity && ((CauldronBlockEntity)be).getFluidTank().isEmpty()) {
            VoxelShape voxelShape = Shapes.block();
            Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"block(...)");
            return voxelShape;
        }
        return SHAPE;
    }

    private final boolean shouldHandlePrecipitation(Level level, Biome.Precipitation precipitation) {
        return switch (WhenMappings.$EnumSwitchMapping$0[precipitation.ordinal()]) {
            case 1 -> {
                if (level.getRandom().nextFloat() < 0.05f) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (level.getRandom().nextFloat() < 0.1f) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private final void giveFluid(CauldronBlockEntity cauldron) {
        cauldron.getFluidTank().fill(new FluidStack((Fluid)Fluids.WATER, 10), IFluidHandler.FluidAction.EXECUTE);
    }

    public void handlePrecipitation(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Biome.Precipitation precipitation) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)precipitation, (String)"precipitation");
        if (this.shouldHandlePrecipitation(level, precipitation) && !level.isClientSide) {
            level.getBlockEntity(pos, (BlockEntityType)WitcheryBlockEntityTypes.INSTANCE.getCAULDRON().get()).ifPresent(arg_0 -> WitcheryCauldronBlock.handlePrecipitation$lambda$1(arg_0 -> WitcheryCauldronBlock.handlePrecipitation$lambda$0(this, arg_0), arg_0));
        }
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        super.randomTick(state, level, pos, random);
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Comparable comparable = state.getValue((Property)BlockStateProperties.LIT);
        Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type kotlin.Boolean");
        if (((Boolean)comparable).booleanValue()) {
            if (random.nextInt(20) == 0) {
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
            }
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)(random.nextInt(1) + 1));
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int i = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                double d = (double)pos.getX() + 0.5;
                double e = pos.getY();
                double f = (double)pos.getZ() + 0.5;
                if (random.nextDouble() < 0.1) {
                    level.playLocalSound(d, e, f, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                for (Direction direction : EntriesMappings.entries$0) {
                    Direction.Axis axis = direction.getAxis();
                    double h = random.nextDouble() * 0.6 - 0.3;
                    double i2 = axis == Direction.Axis.X ? (double)direction.getStepX() * 0.42 : h;
                    double j = random.nextDouble() * 6.0 / 16.0;
                    double k = axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.42 : h;
                    level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d + i2, e + j, f + k, 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ParticleTypes.FLAME, d + i2, e + j, f + k, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private static final Unit handlePrecipitation$lambda$0(WitcheryCauldronBlock this$0, CauldronBlockEntity cauldron) {
        Intrinsics.checkNotNullParameter((Object)cauldron, (String)"cauldron");
        this$0.giveFluid(cauldron);
        return Unit.INSTANCE;
    }

    private static final void handlePrecipitation$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final MultiBlockHorizontalDirectionStructure STRUCTURE$lambda$0() {
        MultiBlockStructure.StructurePiece[] structurePieceArray = new MultiBlockStructure.StructurePiece[1];
        BlockState blockState = ((CauldronBlockComponent)((Object)WitcheryBlocks.INSTANCE.getCAULDRON_COMPONENT().get())).defaultBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
        structurePieceArray[0] = new MultiBlockStructure.StructurePiece(0, 1, 0, blockState);
        return MultiBlockHorizontalDirectionStructure.Companion.of(structurePieceArray);
    }

    static {
        VoxelShape voxelShape = Block.box((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        INSIDE = voxelShape;
        VoxelShape voxelShape2 = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)INSIDE, (BooleanOp)BooleanOp.ONLY_FIRST);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"join(...)");
        SHAPE = voxelShape2;
        STRUCTURE = WitcheryCauldronBlock::STRUCTURE$lambda$0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Ldev/sterner/witchery/content/block/cauldron/WitcheryCauldronBlock$Companion;", "", "<init>", "()V", "INSIDE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "SHAPE", "getSHAPE", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "STRUCTURE", "Ljava/util/function/Supplier;", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockHorizontalDirectionStructure;", "getSTRUCTURE", "()Ljava/util/function/Supplier;", "litBlockEmission", "Ljava/util/function/ToIntFunction;", "Lnet/minecraft/world/level/block/state/BlockState;", "lightValue", "", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VoxelShape getSHAPE() {
            return SHAPE;
        }

        @NotNull
        public final Supplier<MultiBlockHorizontalDirectionStructure> getSTRUCTURE() {
            return STRUCTURE;
        }

        @NotNull
        public final ToIntFunction<BlockState> litBlockEmission(int lightValue) {
            return arg_0 -> Companion.litBlockEmission$lambda$0(lightValue, arg_0);
        }

        private static final int litBlockEmission$lambda$0(int $lightValue, BlockState blockState) {
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Comparable comparable = blockState.getValue((Property)BlockStateProperties.LIT);
            Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type kotlin.Boolean");
            return (Boolean)comparable != false ? $lightValue : 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Biome.Precipitation.values().length];
            try {
                nArray[Biome.Precipitation.RAIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Biome.Precipitation.SNOW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

