/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.crystal_ball;

import dev.sterner.witchery.core.registry.WitcheryTarotEffects;
import dev.sterner.witchery.features.curse.CursePlayerAttachment;
import dev.sterner.witchery.features.tarot.TarotEffect;
import dev.sterner.witchery.features.tarot.TarotPlayerAttachment;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014\u00a8\u0006\u0018"}, d2={"Ldev/sterner/witchery/content/block/crystal_ball/CrystalBall;", "Lnet/minecraft/world/level/block/Block;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "level", "Lnet/minecraft/world/level/BlockGetter;", "pos", "Lnet/minecraft/core/BlockPos;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nCrystalBall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrystalBall.kt\ndev/sterner/witchery/content/block/crystal_ball/CrystalBall\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1869#2,2:104\n*S KotlinDebug\n*F\n+ 1 CrystalBall.kt\ndev/sterner/witchery/content/block/crystal_ball/CrystalBall\n*L\n52#1:104,2\n*E\n"})
public final class CrystalBall
extends Block {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final VoxelShape base = Shapes.create((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.1875, (double)0.75);
    private static final VoxelShape glass = Shapes.create((double)0.21875, (double)0.25, (double)0.21875, (double)0.78125, (double)0.8125, (double)0.78125);
    private static final VoxelShape SHAPE = Shapes.join((VoxelShape)base, (VoxelShape)glass, (BooleanOp)BooleanOp.OR);

    public CrystalBall(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VoxelShape voxelShape = SHAPE;
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"SHAPE");
        return voxelShape;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (!level.isClientSide) {
            CursePlayerAttachment.Data curseData = CursePlayerAttachment.getData(player);
            if (curseData.getPlayerCurseList().isEmpty()) {
                Object[] objectArray = new Object[]{player.getDisplayName()};
                player.displayClientMessage((Component)Component.translatable((String)"witchery.curse.free", (Object[])objectArray).withStyle(ChatFormatting.GREEN), false);
            } else {
                Iterable $this$forEach$iv = curseData.getPlayerCurseList();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CursePlayerAttachment.PlayerCurseData curse = (CursePlayerAttachment.PlayerCurseData)element$iv;
                    boolean bl = false;
                    Object[] objectArray = new Object[]{player.getDisplayName(), Component.translatable((String)("witchery.curse." + curse.getCurseId().getPath() + ".name")).withStyle(ChatFormatting.RED)};
                    player.displayClientMessage((Component)Component.translatable((String)"witchery.curse.afflicted", (Object[])objectArray), false);
                }
            }
            TarotPlayerAttachment.Data tarot2 = TarotPlayerAttachment.getData(player);
            if (!((Collection)tarot2.getDrawnCards()).isEmpty()) {
                int n = ((Collection)tarot2.getDrawnCards()).size();
                for (int i = 0; i < n; ++i) {
                    MutableComponent mutableComponent;
                    TarotEffect desc;
                    TarotEffect tarotEffect;
                    Object nameText;
                    int cardNumber = ((Number)tarot2.getDrawnCards().get(i)).intValue();
                    Boolean bl = (Boolean)CollectionsKt.getOrNull(tarot2.getReversedCards(), (int)i);
                    boolean isReversed = bl != null ? bl : false;
                    TarotEffect effect = WitcheryTarotEffects.INSTANCE.getByCardNumber(cardNumber);
                    Object object = effect;
                    if (object == null || (object = ((TarotEffect)object).getDisplayName(isReversed)) == null || (object = object.getString()) == null) {
                        object = nameText = "Unknown Card";
                    }
                    if ((tarotEffect = effect) == null || (tarotEffect = tarotEffect.getDescription(isReversed)) == null) {
                        MutableComponent mutableComponent2 = Component.literal((String)"No description.");
                        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"literal(...)");
                        tarotEffect = desc = (Component)mutableComponent2;
                    }
                    if (isReversed && StringsKt.endsWith$default((String)nameText, (String)"(Reversed)", (boolean)false, (int)2, null)) {
                        String mainName = ((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)nameText, (CharSequence)"(Reversed)"))).toString();
                        String reversedText = "(Reversed)";
                        mutableComponent = Component.literal((String)mainName).withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)(" " + reversedText)).withStyle(ChatFormatting.RED));
                    } else {
                        mutableComponent = Component.literal((String)nameText).withStyle(ChatFormatting.GOLD);
                    }
                    MutableComponent nameComponent = mutableComponent;
                    MutableComponent message = nameComponent.withStyle(arg_0 -> CrystalBall.useWithoutItem$lambda$1((Component)desc, arg_0));
                    player.displayClientMessage((Component)message, false);
                }
            }
        }
        InteractionResult interactionResult = super.useWithoutItem(state, level, pos, player, hitResult);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useWithoutItem(...)");
        return interactionResult;
    }

    private static final Style useWithoutItem$lambda$1(Component $desc, Style style) {
        return style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)$desc));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0019\u0010\u000b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\r"}, d2={"Ldev/sterner/witchery/content/block/crystal_ball/CrystalBall$Companion;", "", "<init>", "()V", "base", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "kotlin.jvm.PlatformType", "getBase", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "glass", "getGlass", "SHAPE", "getSHAPE", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        public final VoxelShape getBase() {
            return base;
        }

        public final VoxelShape getGlass() {
            return glass;
        }

        public final VoxelShape getSHAPE() {
            return SHAPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

