/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.effigy;

import dev.sterner.witchery.content.block.WitcheryBaseEntityBlock;
import dev.sterner.witchery.content.block.effigy.EffigyBlockEntity;
import dev.sterner.witchery.content.block.effigy.EffigyCompanionBlock;
import dev.sterner.witchery.core.api.multiblock.MultiBlockItem;
import dev.sterner.witchery.core.api.multiblock.MultiBlockStructure;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryBlocks;
import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.core.registry.WitcheryItems;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0014J\u001c\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00070\u0010H\u0014J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u0007H\u0016J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J:\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010\u00132\u0006\u0010!\u001a\u00020\u0017H\u0016J\u0018\u0010\"\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020#H\u0002J(\u0010$\u001a\u00020%2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020&2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(H\u0014\u00a8\u0006*"}, d2={"Ldev/sterner/witchery/content/block/effigy/EffigyBlock;", "Ldev/sterner/witchery/content/block/WitcheryBaseEntityBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getStateForPlacement", "Lnet/minecraft/world/level/block/state/BlockState;", "blockPlaceContext", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "state", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "getCloneItemStack", "Lnet/minecraft/world/item/ItemStack;", "target", "Lnet/minecraft/world/phys/HitResult;", "level", "Lnet/minecraft/world/level/LevelReader;", "player", "Lnet/minecraft/world/entity/player/Player;", "playerDestroy", "Lnet/minecraft/world/level/Level;", "blockEntity", "tool", "makeEffigyItem", "Ldev/sterner/witchery/content/block/effigy/EffigyBlockEntity;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "Companion", "witchery"})
public final class EffigyBlock
extends WitcheryBaseEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Supplier<MultiBlockStructure> STRUCTURE = EffigyBlock::STRUCTURE$lambda$0;

    public EffigyBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext blockPlaceContext) {
        Intrinsics.checkNotNullParameter((Object)blockPlaceContext, (String)"blockPlaceContext");
        Object object = this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)blockPlaceContext.getHorizontalDirection().getOpposite());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.INVISIBLE;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.HORIZONTAL_FACING};
        builder.add(propertyArray);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return ((BlockEntityType)WitcheryBlockEntityTypes.INSTANCE.getEFFIGY().get()).create(pos, state);
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof EffigyBlockEntity && !level.isClientSide()) {
            return this.makeEffigyItem(state, (EffigyBlockEntity)blockEntity);
        }
        ItemStack itemStack = super.getCloneItemStack(state, target, level, pos, player);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getCloneItemStack(...)");
        return itemStack;
    }

    public void playerDestroy(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity blockEntity, @NotNull ItemStack tool) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof EffigyBlockEntity && !level.isClientSide && !player.isCreative() && !player.isSpectator()) {
            ItemStack itemStack = this.makeEffigyItem(state, (EffigyBlockEntity)be);
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemStack);
            itemEntity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itemEntity);
        }
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
    }

    private final ItemStack makeEffigyItem(BlockState state, EffigyBlockEntity blockEntity) {
        ItemStack baseItem = state.is((Block)WitcheryBlocks.INSTANCE.getCLAY_EFFIGY().get()) ? ((BlockItem)WitcheryItems.INSTANCE.getCLAY_EFFIGY().get()).getDefaultInstance() : (state.is((Block)WitcheryBlocks.INSTANCE.getSCARECROW().get()) ? ((MultiBlockItem)((Object)WitcheryItems.INSTANCE.getSCARECROW().get())).getDefaultInstance() : ((MultiBlockItem)((Object)WitcheryItems.INSTANCE.getWITCHES_LADDER().get())).getDefaultInstance());
        baseItem.set((DataComponentType)WitcheryDataComponents.INSTANCE.getPOLTERGEIST_COUNT().get(), (Object)blockEntity.getSpiritCount());
        baseItem.set((DataComponentType)WitcheryDataComponents.INSTANCE.getBANSHEE_COUNT().get(), (Object)blockEntity.getBansheeCount());
        baseItem.set((DataComponentType)WitcheryDataComponents.INSTANCE.getSPECTRE_COUNT().get(), (Object)blockEntity.getSpecterCount());
        Intrinsics.checkNotNull((Object)baseItem);
        return baseItem;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VoxelShape foot = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
        VoxelShape clay = Shapes.joinUnoptimized((VoxelShape)foot, (VoxelShape)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0), (BooleanOp)BooleanOp.OR);
        VoxelShape scarecrow = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        if (state.is((Block)WitcheryBlocks.INSTANCE.getCLAY_EFFIGY().get())) {
            Intrinsics.checkNotNull((Object)clay);
            voxelShape = clay;
        } else {
            Intrinsics.checkNotNull((Object)scarecrow);
            voxelShape = scarecrow;
        }
        return voxelShape;
    }

    private static final MultiBlockStructure STRUCTURE$lambda$0() {
        MultiBlockStructure.StructurePiece[] structurePieceArray = new MultiBlockStructure.StructurePiece[1];
        BlockState blockState = ((EffigyCompanionBlock)((Object)WitcheryBlocks.INSTANCE.getEFFIGY_COMPONENT().get())).defaultBlockState();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
        structurePieceArray[0] = new MultiBlockStructure.StructurePiece(0, 1, 0, blockState);
        return MultiBlockStructure.Companion.of(structurePieceArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/sterner/witchery/content/block/effigy/EffigyBlock$Companion;", "", "<init>", "()V", "STRUCTURE", "Ljava/util/function/Supplier;", "Ldev/sterner/witchery/core/api/multiblock/MultiBlockStructure;", "getSTRUCTURE", "()Ljava/util/function/Supplier;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Supplier<MultiBlockStructure> getSTRUCTURE() {
            return STRUCTURE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

