/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.oven;

import dev.sterner.witchery.content.block.WitcheryBaseEntityBlock;
import dev.sterner.witchery.content.block.cauldron.WitcheryCauldronBlock;
import dev.sterner.witchery.content.block.oven.OvenBlockEntity;
import dev.sterner.witchery.content.block.oven.OvenFumeExtensionBlockEntity;
import dev.sterner.witchery.core.registry.WitcheryBlockEntityTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J8\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J0\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0015H\u0014J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0007H\u0016J\u001c\u0010\"\u001a\u00020\u000b2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00070$H\u0014\u00a8\u0006%"}, d2={"Ldev/sterner/witchery/content/block/oven/OvenBlock;", "Ldev/sterner/witchery/content/block/WitcheryBaseEntityBlock;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getStateForPlacement", "Lnet/minecraft/world/level/block/state/BlockState;", "blockPlaceContext", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "neighborChanged", "", "pState", "pLevel", "Lnet/minecraft/world/level/Level;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlock", "Lnet/minecraft/world/level/block/Block;", "pFromPos", "pIsMoving", "", "checkFumeFunnels", "", "state", "level", "Lnet/minecraft/world/level/LevelReader;", "pos", "regular", "onRemove", "newState", "movedByPiston", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "createBlockStateDefinition", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "witchery"})
public class OvenBlock
extends WitcheryBaseEntityBlock {
    public OvenBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        BlockBehaviour.Properties properties2 = properties.noOcclusion().lightLevel(WitcheryCauldronBlock.Companion.litBlockEmission(8));
        Intrinsics.checkNotNullExpressionValue((Object)properties2, (String)"lightLevel(...)");
        super(properties2);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext blockPlaceContext) {
        Intrinsics.checkNotNullParameter((Object)blockPlaceContext, (String)"blockPlaceContext");
        Object object = this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)blockPlaceContext.getHorizontalDirection().getOpposite());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    @Override
    public void neighborChanged(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Block pBlock, @NotNull BlockPos pFromPos, boolean pIsMoving) {
        Intrinsics.checkNotNullParameter((Object)pState, (String)"pState");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlock, (String)"pBlock");
        Intrinsics.checkNotNullParameter((Object)pFromPos, (String)"pFromPos");
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        if (pLevel.getBlockEntity(pPos) instanceof OvenBlockEntity) {
            BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
            Intrinsics.checkNotNull((Object)blockEntity, (String)"null cannot be cast to non-null type dev.sterner.witchery.content.block.oven.OvenBlockEntity");
            OvenBlockEntity oven = (OvenBlockEntity)blockEntity;
            oven.setFumeHoodCount(this.checkFumeFunnels(pState, (LevelReader)pLevel, pPos, true));
            oven.setFilteredFumeHoodCount(this.checkFumeFunnels(pState, (LevelReader)pLevel, pPos, false));
        }
    }

    private final int checkFumeFunnels(BlockState state, LevelReader level, BlockPos pos, boolean regular) {
        Direction blockFacing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        BlockPos leftPos = pos.relative(blockFacing.getCounterClockWise());
        BlockPos rightPos = pos.relative(blockFacing.getClockWise());
        BlockEntity leftState = level.getBlockEntity(leftPos);
        BlockEntity rightState = level.getBlockEntity(rightPos);
        int count = 0;
        if (regular) {
            if (leftState instanceof OvenFumeExtensionBlockEntity && !((OvenFumeExtensionBlockEntity)leftState).isFiltered()) {
                ++count;
            }
            if (rightState instanceof OvenFumeExtensionBlockEntity && !((OvenFumeExtensionBlockEntity)rightState).isFiltered()) {
                ++count;
            }
        } else {
            if (leftState instanceof OvenFumeExtensionBlockEntity && ((OvenFumeExtensionBlockEntity)leftState).isFiltered()) {
                ++count;
            }
            if (rightState instanceof OvenFumeExtensionBlockEntity && ((OvenFumeExtensionBlockEntity)rightState).isFiltered()) {
                ++count;
            }
        }
        return count;
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return ((BlockEntityType)WitcheryBlockEntityTypes.INSTANCE.getOVEN().get()).create(pos, state);
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.LIT};
        builder.add(propertyArray);
    }
}

