/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.block.ritual;

import dev.sterner.witchery.core.registry.WitcheryBlocks;
import dev.sterner.witchery.features.affliction.vampire.VampireSpecificEventHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B%\u0012\f\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ8\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0014J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u001c\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0\u001fH\u0014J\u0012\u0010 \u001a\u0004\u0018\u00010\u000f2\u0006\u0010!\u001a\u00020\"H\u0016J(\u0010#\u001a\u00020$2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020&H\u0014J(\u0010'\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020(2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006,"}, d2={"Ldev/sterner/witchery/content/block/ritual/RitualChalkBlock;", "Lnet/minecraft/world/level/block/Block;", "type", "Lnet/minecraft/core/particles/ParticleType;", "color", "", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/core/particles/ParticleType;ILnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getType", "()Lnet/minecraft/core/particles/ParticleType;", "getColor", "()I", "updateShape", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "direction", "Lnet/minecraft/core/Direction;", "neighborState", "level", "Lnet/minecraft/world/level/LevelAccessor;", "pos", "Lnet/minecraft/core/BlockPos;", "neighborPos", "canSurvive", "", "Lnet/minecraft/world/level/LevelReader;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "getStateForPlacement", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "animateTick", "Lnet/minecraft/world/level/Level;", "random", "Lnet/minecraft/util/RandomSource;", "Companion", "witchery"})
public final class RitualChalkBlock
extends Block {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ParticleType<?> type;
    private final int color;
    public static final int VARIANTS = 15;
    @NotNull
    private static final IntegerProperty VARIANT;

    public RitualChalkBlock(@Nullable ParticleType<?> type, int color, @NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties.noOcclusion().noCollission().replaceable());
        this.type = type;
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)VARIANT, (Comparable)Integer.valueOf(0)));
    }

    @Nullable
    public final ParticleType<?> getType() {
        return this.type;
    }

    public final int getColor() {
        return this.color;
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (!state.canSurvive((LevelReader)level, pos)) {
            BlockState blockState2 = Blocks.AIR.defaultBlockState();
            blockState = blockState2;
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"defaultBlockState(...)");
        } else {
            BlockState blockState3 = super.updateShape(state, direction, neighborState, level, pos, neighborPos);
            blockState = blockState3;
            Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"updateShape(...)");
        }
        return blockState;
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return Block.isFaceFull((VoxelShape)level.getBlockState(pos.below()).getCollisionShape((BlockGetter)level, pos.below()), (Direction)Direction.UP);
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{VARIANT};
        builder.add(propertyArray);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BlockState blockState = super.getStateForPlacement(context);
        return blockState != null ? (BlockState)blockState.setValue((Property)VARIANT, (Comparable)Integer.valueOf(context.getLevel().random.nextIntBetweenInclusive(0, 15))) : null;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VoxelShape voxelShape = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        return voxelShape;
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (this.type != null) {
            ParticleType<?> particleType = this.type;
            Intrinsics.checkNotNull(particleType, (String)"null cannot be cast to non-null type net.minecraft.core.particles.ParticleOptions");
            level.addParticle((ParticleOptions)particleType, (double)pos.getX() + 0.5 + Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5), (double)pos.getY() + 0.0625, (double)pos.getZ() + 0.5 + Mth.nextDouble((RandomSource)random, (double)-0.5, (double)0.5), 0.0, 0.0, 0.0);
        }
        super.animateTick(state, level, pos, random);
    }

    static {
        IntegerProperty integerProperty = IntegerProperty.create((String)"variant", (int)0, (int)15);
        Intrinsics.checkNotNullExpressionValue((Object)integerProperty, (String)"create(...)");
        VARIANT = integerProperty;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J(\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Ldev/sterner/witchery/content/block/ritual/RitualChalkBlock$Companion;", "", "<init>", "()V", "VARIANTS", "", "VARIANT", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getVARIANT", "()Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "placeInfernal", "", "event", "Lnet/neoforged/neoforge/event/level/BlockEvent$EntityPlaceEvent;", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "entity", "Lnet/minecraft/world/entity/Entity;", "tryMakeSacrificialCircle", "skullPos", "Lnet/minecraft/world/entity/player/Player;", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntegerProperty getVARIANT() {
            return VARIANT;
        }

        public final void placeInfernal(@NotNull BlockEvent.EntityPlaceEvent event, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @Nullable Entity entity) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            if (!(entity instanceof Player)) {
                return;
            }
            if (blockState.is((Block)WitcheryBlocks.INSTANCE.getINFERNAL_CHALK_BLOCK().get())) {
                BlockPos[] blockPosArray = new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(1, 0, 1), new BlockPos(0, 0, 1), new BlockPos(-1, 0, 1), new BlockPos(-1, 0, 0), new BlockPos(-1, 0, -1), new BlockPos(0, 0, -1), new BlockPos(1, 0, -1)};
                List surroundingOffsets = CollectionsKt.listOf((Object[])blockPosArray);
                for (BlockPos offset : surroundingOffsets) {
                    BlockPos testPos = blockPos.offset((Vec3i)offset);
                    if (!level.getBlockState(testPos).is(Blocks.SKELETON_SKULL)) continue;
                    BlockPos blockPos2 = testPos.immutable();
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"immutable(...)");
                    this.tryMakeSacrificialCircle(event, level, blockPos2, (Player)entity);
                    return;
                }
            }
        }

        private final void tryMakeSacrificialCircle(BlockEvent.EntityPlaceEvent event, Level level, BlockPos skullPos, Player entity) {
            long allInfernalChalk = level.getBlockStates(AABB.ofSize((Vec3)skullPos.getCenter(), (double)2.0, (double)2.0, (double)2.0)).filter(arg_0 -> Companion.tryMakeSacrificialCircle$lambda$1(Companion::tryMakeSacrificialCircle$lambda$0, arg_0)).count();
            if (allInfernalChalk >= 7L) {
                VampireSpecificEventHandler.INSTANCE.makeSacrificialCircle(entity, skullPos);
                event.setCanceled(true);
            }
        }

        private static final boolean tryMakeSacrificialCircle$lambda$0(BlockState it) {
            return it.is((Block)WitcheryBlocks.INSTANCE.getINFERNAL_CHALK_BLOCK().get());
        }

        private static final boolean tryMakeSacrificialCircle$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

