/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.core.registry.WitcheryDataComponents;
import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.features.familiar.FamiliarHandler;
import dev.sterner.witchery.network.SyncOwlAbilityS2CPayload;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 d2\u00020\u0001:\u0001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0011H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\n\u0010'\u001a\u0004\u0018\u00010(H\u0016J \u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0007H\u0014J\u0018\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020#2\u0006\u00106\u001a\u00020\u0001H\u0014J8\u00107\u001a\u00020#2\u0006\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u00072\u0006\u0010=\u001a\u00020\tH\u0016J\b\u0010>\u001a\u00020\u000bH\u0016J\b\u0010?\u001a\u00020\u000bH\u0016J\b\u0010@\u001a\u00020\u000bH\u0016J\b\u0010A\u001a\u00020\u0007H\u0016J\b\u0010B\u001a\u00020\u0007H\u0016J\b\u0010C\u001a\u00020DH\u0016J\b\u0010E\u001a\u00020#H\u0002J\b\u0010F\u001a\u00020#H\u0002J\b\u0010G\u001a\u00020#H\u0016J8\u0010H\u001a\u00020#2\u0006\u0010I\u001a\u00020\u00112\u0006\u0010J\u001a\u00020\u00112\u0006\u0010K\u001a\u00020\u00112\u0006\u0010L\u001a\u00020\u00112\u0006\u0010M\u001a\u00020\u00112\u0006\u0010N\u001a\u00020\u0011H\u0002J\u0018\u0010O\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010P\u001a\u00020\u0007H\u0016J\b\u0010Q\u001a\u00020#H\u0002J\u0010\u0010R\u001a\u00020#2\u0006\u0010S\u001a\u00020\u0001H\u0016J\u0012\u0010T\u001a\u00020\u00112\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u0012\u0010U\u001a\u00020#2\b\u0010V\u001a\u0004\u0018\u00010WH\u0002J\u0010\u0010X\u001a\u00020#2\u0006\u0010Y\u001a\u00020ZH\u0014J\u0010\u0010[\u001a\u00020#2\u0006\u0010\\\u001a\u00020\tH\u0002J\u0010\u0010]\u001a\u00020#2\u0006\u0010^\u001a\u00020\tH\u0002J\u0010\u0010_\u001a\u00020#2\u0006\u0010`\u001a\u00020\u0007H\u0002J\b\u0010a\u001a\u00020\u0007H\u0002J\b\u0010b\u001a\u00020\tH\u0002J\b\u0010c\u001a\u00020\tH\u0002J\u0012\u0010U\u001a\u00020#2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006e"}, d2={"Ldev/sterner/witchery/content/entity/BroomEntity;", "Lnet/minecraft/world/entity/Entity;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/level/Level;)V", "deltaRotation", "", "lerpSteps", "", "lerpX", "", "lerpY", "lerpZ", "lerpYRot", "lerpXRot", "inputLeft", "", "inputRight", "inputUp", "inputDown", "inputShift", "inputJump", "hasFamiliar", "getHasFamiliar", "()Z", "setHasFamiliar", "(Z)V", "causeFallDamage", "fallDistance", "multiplier", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "isPickable", "readAdditionalSaveData", "", "compound", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "getControllingPassenger", "Lnet/minecraft/world/entity/LivingEntity;", "getPassengerAttachmentPoint", "Lnet/minecraft/world/phys/Vec3;", "entity", "dimensions", "Lnet/minecraft/world/entity/EntityDimensions;", "partialTick", "interact", "Lnet/minecraft/world/InteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "addPassenger", "passenger", "lerpTo", "x", "y", "z", "yRot", "xRot", "steps", "lerpTargetX", "lerpTargetY", "lerpTargetZ", "lerpTargetXRot", "lerpTargetYRot", "getMotionDirection", "Lnet/minecraft/core/Direction;", "tickLerp", "controlBroom", "tick", "updateInputs", "leftInputDown", "rightInputDown", "forwardInputDown", "backInputDown", "jumpInputDown", "sneakingInputDown", "hurt", "amount", "updateMotion", "onPassengerTurned", "entityToUpdate", "shouldSourceDestroy", "destroy", "dropItem", "Lnet/minecraft/world/item/Item;", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "setHurtTime", "hurtTime", "setHurtDir", "hurtDir", "setDamage", "damage", "getDamage", "getHurtTime", "getHurtDir", "Companion", "witchery"})
@SourceDebugExtension(value={"SMAP\nBroomEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BroomEntity.kt\ndev/sterner/witchery/content/entity/BroomEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,416:1\n1#2:417\n*E\n"})
public final class BroomEntity
extends Entity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private boolean inputLeft;
    private boolean inputRight;
    private boolean inputUp;
    private boolean inputDown;
    private boolean inputShift;
    private boolean inputJump;
    private boolean hasFamiliar;
    @NotNull
    private static final EntityDataAccessor<Integer> DATA_ID_HURT;
    @NotNull
    private static final EntityDataAccessor<Integer> DATA_ID_HURTDIR;
    @NotNull
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE;

    public BroomEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType)WitcheryEntityTypes.INSTANCE.getBROOM().get(), level);
        this.setPos(this.getX(), this.getY(), this.getZ());
    }

    public final boolean getHasFamiliar() {
        return this.hasFamiliar;
    }

    public final void setHasFamiliar(boolean bl) {
        this.hasFamiliar = bl;
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, @NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return false;
    }

    public boolean isPickable() {
        return true;
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity livingEntity;
        if (this.getFirstPassenger() instanceof LivingEntity) {
            Entity entity = this.getFirstPassenger();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
            livingEntity = (LivingEntity)entity;
        } else {
            livingEntity = super.getControllingPassenger();
        }
        return livingEntity;
    }

    @NotNull
    protected Vec3 getPassengerAttachmentPoint(@NotNull Entity entity, @NotNull EntityDimensions dimensions, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)dimensions, (String)"dimensions");
        Vec3 vec3 = new Vec3(0.0, (double)(dimensions.height() / 3.0f), 0.0).yRot(-this.getYRot() * ((float)Math.PI / 180));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"yRot(...)");
        return vec3;
    }

    @NotNull
    public InteractionResult interact(@NotNull Player player, @NotNull InteractionHand hand) {
        InteractionResult interactionResult;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        InteractionResult interactionResult2 = super.interact(player, hand);
        if (interactionResult2 != InteractionResult.PASS) {
            InteractionResult interactionResult3 = interactionResult2;
            Intrinsics.checkNotNull((Object)interactionResult3);
            interactionResult = interactionResult3;
        } else if (player.isSecondaryUseActive()) {
            interactionResult = InteractionResult.PASS;
        } else {
            BroomEntity $this$interact_u24lambda_u240 = this;
            boolean bl = false;
            interactionResult = !$this$interact_u24lambda_u240.level().isClientSide ? (player.startRiding((Entity)$this$interact_u24lambda_u240) ? InteractionResult.CONSUME : InteractionResult.PASS) : InteractionResult.SUCCESS;
        }
        return interactionResult;
    }

    protected void addPassenger(@NotNull Entity passenger) {
        Intrinsics.checkNotNullParameter((Object)passenger, (String)"passenger");
        super.addPassenger(passenger);
        if (this.isControlledByLocalInstance() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.absMoveTo(this.lerpX, this.lerpY, this.lerpZ, this.getYRot(), (float)this.lerpXRot);
        }
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yRot;
        this.lerpXRot = xRot;
        this.lerpSteps = 10;
    }

    public double lerpTargetX() {
        return this.lerpSteps > 0 ? this.lerpX : this.getX();
    }

    public double lerpTargetY() {
        return this.lerpSteps > 0 ? this.lerpY : this.getY();
    }

    public double lerpTargetZ() {
        return this.lerpSteps > 0 ? this.lerpZ : this.getZ();
    }

    public float lerpTargetXRot() {
        return this.lerpSteps > 0 ? (float)this.lerpXRot : this.getXRot();
    }

    public float lerpTargetYRot() {
        return this.lerpSteps > 0 ? (float)this.lerpYRot : this.getYRot();
    }

    @NotNull
    public Direction getMotionDirection() {
        Direction direction = this.getDirection().getClockWise();
        Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"getClockWise(...)");
        return direction;
    }

    private final void tickLerp() {
        if (this.isControlledByLocalInstance()) {
            this.lerpSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.lerpSteps > 0) {
            this.lerpPositionAndRotationStep(this.lerpSteps, this.lerpX, this.lerpY, this.lerpZ, this.lerpYRot, this.lerpXRot);
            int n = this.lerpSteps;
            this.lerpSteps = n + -1;
        }
    }

    private final void controlBroom() {
        if (this.isVehicle()) {
            float f = 0.0f;
            if (this.inputLeft) {
                this.deltaRotation -= this.hasFamiliar ? 5.0f : 1.0f;
            }
            if (this.inputRight) {
                this.deltaRotation += this.hasFamiliar ? 5.0f : 1.0f;
            }
            if (!(this.hasFamiliar || this.inputRight == this.inputLeft || this.inputUp || this.inputDown)) {
                f += 0.1f;
            }
            if (this.inputDown) {
                f -= 0.02f;
            }
            if (this.inputUp) {
                f += this.hasFamiliar ? 0.35f : 0.25f;
            }
            this.setYRot(this.getYRot() + this.deltaRotation);
            if (this.inputJump) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.2, 0.0));
            }
            if (this.inputShift) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.2, 0.0));
            }
            this.setDeltaMovement(this.getDeltaMovement().add((double)(Mth.sin((float)(-this.getYRot() * ((float)Math.PI / 180))) * f) * 2.0, 0.0, (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * f) * 2.0));
        }
    }

    public void tick() {
        this.baseTick();
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        Entity entityPassenger = (Entity)this.getControllingPassenger();
        if (!this.level().isClientSide && entityPassenger instanceof LivingEntity) {
            UUID uUID = ((LivingEntity)entityPassenger).getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            Level level = this.level();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            boolean bl = this.hasFamiliar = FamiliarHandler.INSTANCE.getFamiliarEntityType(uUID, (ServerLevel)level) != null;
            if (this.level() instanceof ServerLevel && entityPassenger instanceof Player) {
                Level level2 = this.level();
                Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerLevel serverLevel = (ServerLevel)level2;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)serverLevel, (CustomPacketPayload)new SyncOwlAbilityS2CPayload((Player)entityPassenger, this.hasFamiliar), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        if (this.level().isClientSide() && entityPassenger instanceof LivingEntity && Intrinsics.areEqual((Object)entityPassenger, (Object)Minecraft.getInstance().player)) {
            LocalPlayer player = Minecraft.getInstance().player;
            this.setNoGravity(true);
            LocalPlayer localPlayer = player;
            Intrinsics.checkNotNull((Object)localPlayer);
            this.updateInputs(localPlayer.input.left, player.input.right, player.input.up, player.input.down, player.input.jumping, player.input.shiftKeyDown);
        }
        super.tick();
        this.tickLerp();
        if (this.isControlledByLocalInstance()) {
            this.updateMotion();
            if (this.level().isClientSide) {
                this.controlBroom();
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
        } else {
            this.setDeltaMovement(Vec3.ZERO);
        }
        this.checkInsideBlocks();
    }

    private final void updateInputs(boolean leftInputDown, boolean rightInputDown, boolean forwardInputDown, boolean backInputDown, boolean jumpInputDown, boolean sneakingInputDown) {
        this.inputLeft = leftInputDown;
        this.inputRight = rightInputDown;
        this.inputUp = forwardInputDown;
        this.inputDown = backInputDown;
        this.inputJump = jumpInputDown;
        this.inputShift = sneakingInputDown;
    }

    /*
     * Unable to fully structure code
     */
    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (this.level().isClientSide || this.isRemoved()) {
            return true;
        }
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.markHurt();
        this.setDamage(this.getDamage() + amount * 10.0f);
        this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, source.getEntity());
        if (!(source.getEntity() instanceof Player)) ** GOTO lbl-1000
        v0 = (Player)source.getEntity();
        Intrinsics.checkNotNull((Object)v0);
        if (v0.getAbilities().instabuild) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = bl = false;
        }
        if (!(!bl && this.getDamage() > 40.0f || this.shouldSourceDestroy(source))) {
            if (bl) {
                this.discard();
            }
        } else {
            this.destroy(source);
        }
        return true;
    }

    private final void updateMotion() {
        double d1 = this.isNoGravity() ? 0.0 : -0.04;
        float momentum = 0.05f;
        double speedMultiplier = 0.4;
        Vec3 vector3d = this.getDeltaMovement();
        this.setDeltaMovement(vector3d.x * (double)momentum, vector3d.y + d1, vector3d.z * (double)momentum);
        this.deltaRotation *= momentum;
        if (this.isNoGravity() && Mth.abs((float)((float)(this.getDeltaMovement().y() / (double)(1.15f + Mth.abs((float)((float)this.getDeltaMovement().y())) / 6.0f)))) > 0.0f) {
            this.setDeltaMovement(this.getDeltaMovement().x(), Mth.abs((float)((float)(this.getDeltaMovement().y() / (double)(1.15f + Mth.abs((float)((float)this.getDeltaMovement().y())) / 6.0f)))) < 0.1f ? 0.0 : this.getDeltaMovement().y() / (double)(1.15f + Mth.abs((float)((float)this.getDeltaMovement().y())) / 6.0f), this.getDeltaMovement().z());
        }
        if (this.getDeltaMovement().y() > speedMultiplier / (double)4.0f) {
            this.setDeltaMovement(this.getDeltaMovement().x(), speedMultiplier / (double)4.0f, this.getDeltaMovement().z());
        }
        if (this.getDeltaMovement().y() < -speedMultiplier / (double)4.0f) {
            this.setDeltaMovement(this.getDeltaMovement().x(), -speedMultiplier / (double)4.0f, this.getDeltaMovement().z());
        }
    }

    public void onPassengerTurned(@NotNull Entity entityToUpdate) {
        Intrinsics.checkNotNullParameter((Object)entityToUpdate, (String)"entityToUpdate");
        entityToUpdate.setYBodyRot(this.getYRot());
        float f = Mth.wrapDegrees((float)(entityToUpdate.getYRot() - this.getYRot()));
        float g = Mth.clamp((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.yRotO += g - f;
        entityToUpdate.setYRot(entityToUpdate.getYRot() + g - f);
        entityToUpdate.setYHeadRot(entityToUpdate.getYRot());
        super.onPassengerTurned(entityToUpdate);
    }

    private final boolean shouldSourceDestroy(DamageSource source) {
        return false;
    }

    private final void destroy(Item dropItem) {
        this.kill();
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            ItemStack itemStack;
            ItemStack itemStack2;
            Item item = dropItem;
            if (item != null) {
                Item it = item;
                boolean bl = false;
                itemStack2 = new ItemStack((ItemLike)it);
            } else {
                itemStack2 = null;
            }
            ItemStack itemStack3 = itemStack = itemStack2;
            if (itemStack3 != null) {
                Component cfr_ignored_0 = (Component)itemStack3.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
            }
            ItemStack itemStack4 = itemStack;
            if (itemStack4 != null) {
                Boolean cfr_ignored_1 = (Boolean)itemStack4.set((DataComponentType)WitcheryDataComponents.INSTANCE.getHAS_OINTMENT().get(), (Object)true);
            }
            if (itemStack != null) {
                this.spawnAtLocation(itemStack);
            }
        }
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(DATA_ID_HURT, (Object)0);
        builder.define(DATA_ID_HURTDIR, (Object)1);
        builder.define(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    private final void setHurtTime(int hurtTime) {
        this.entityData.set(DATA_ID_HURT, (Object)hurtTime);
    }

    private final void setHurtDir(int hurtDir) {
        this.entityData.set(DATA_ID_HURTDIR, (Object)hurtDir);
    }

    private final void setDamage(float damage) {
        this.entityData.set(DATA_ID_DAMAGE, (Object)Float.valueOf(damage));
    }

    private final float getDamage() {
        Object object = this.entityData.get(DATA_ID_DAMAGE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).floatValue();
    }

    private final int getHurtTime() {
        Object object = this.entityData.get(DATA_ID_HURT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    private final int getHurtDir() {
        Object object = this.entityData.get(DATA_ID_HURTDIR);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    private final void destroy(DamageSource source) {
        this.destroy((Item)WitcheryItems.INSTANCE.getBROOM().get());
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        DATA_ID_HURT = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        DATA_ID_HURTDIR = entityDataAccessor2;
        EntityDataAccessor entityDataAccessor3 = SynchedEntityData.defineId(BroomEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor3, (String)"defineId(...)");
        DATA_ID_DAMAGE = entityDataAccessor3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\b\u00a8\u0006\u000e"}, d2={"Ldev/sterner/witchery/content/entity/BroomEntity$Companion;", "", "<init>", "()V", "DATA_ID_HURT", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getDATA_ID_HURT", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "DATA_ID_HURTDIR", "getDATA_ID_HURTDIR", "DATA_ID_DAMAGE", "", "getDATA_ID_DAMAGE", "witchery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Integer> getDATA_ID_HURT() {
            return DATA_ID_HURT;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getDATA_ID_HURTDIR() {
            return DATA_ID_HURTDIR;
        }

        @NotNull
        public final EntityDataAccessor<Float> getDATA_ID_DAMAGE() {
            return DATA_ID_DAMAGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

