/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.witchery.content.entity;

import dev.sterner.witchery.core.registry.WitcheryEntityTypes;
import dev.sterner.witchery.core.registry.WitcheryItems;
import dev.sterner.witchery.core.util.BoatTypeHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B)\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Ldev/sterner/witchery/content/entity/CustomBoat;", "Lnet/minecraft/world/entity/vehicle/Boat;", "type", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "x", "", "y", "z", "(Lnet/minecraft/world/level/Level;DDD)V", "getDisplayName", "Lnet/minecraft/network/chat/MutableComponent;", "getDropItem", "Lnet/minecraft/world/item/Item;", "witchery"})
public final class CustomBoat
extends Boat {
    public CustomBoat(@NotNull EntityType<? extends Boat> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type, level);
    }

    public CustomBoat(@NotNull Level level, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Object object = WitcheryEntityTypes.INSTANCE.getCUSTOM_BOAT().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this((EntityType<? extends Boat>)((EntityType)object), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    @NotNull
    public MutableComponent getDisplayName() {
        MutableComponent mutableComponent = Component.translatable((String)("entity.witchery." + this.getVariant().name() + "_boat"));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return mutableComponent;
    }

    @NotNull
    public Item getDropItem() {
        Item item;
        Boat.Type type = this.getVariant();
        if (type == BoatTypeHelper.getRowanBoatType()) {
            Object object = WitcheryItems.INSTANCE.getROWAN_BOAT().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            item = (Item)object;
        } else if (type == BoatTypeHelper.getAlderBoatType()) {
            Object object = WitcheryItems.INSTANCE.getALDER_BOAT().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            item = (Item)object;
        } else if (type == BoatTypeHelper.getHawthornBoatType()) {
            Object object = WitcheryItems.INSTANCE.getHAWTHORN_BOAT().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            item = (Item)object;
        } else {
            Item item2 = super.getDropItem();
            item = item2;
            Intrinsics.checkNotNullExpressionValue((Object)item2, (String)"getDropItem(...)");
        }
        return item;
    }
}

